/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.IAttributes;
import org.testng.IConfigurationListener;
import org.testng.IInvokedMethod;
import org.testng.IInvokedMethodListener;
import org.testng.IMethodInterceptor;
import org.testng.IObjectFactory;
import org.testng.IObjectFactory2;
import org.testng.IReporter;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ISuiteResult;
import org.testng.ITestListener;
import org.testng.ITestNGListener;
import org.testng.ITestNGMethod;
import org.testng.ITestObjectFactory;
import org.testng.ITestResult;
import org.testng.ITestRunnerFactory;
import org.testng.SuiteResult;
import org.testng.SuiteRunState;
import org.testng.TestListenerAdapter;
import org.testng.TestRunner;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.internal.Attributes;
import org.testng.internal.IConfiguration;
import org.testng.internal.IInvoker;
import org.testng.internal.Utils;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.thread.ThreadUtil;
import org.testng.reporters.JUnitXMLReporter;
import org.testng.reporters.TestHTMLReporter;
import org.testng.reporters.TextReporter;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuiteRunner
implements ISuite,
Serializable,
IInvokedMethodListener {
    private static final long serialVersionUID = 5284208932089503131L;
    private static final String DEFAULT_OUTPUT_DIR = "test-output";
    private Map<String, ISuiteResult> m_suiteResults = Maps.newHashMap();
    private transient List<TestRunner> m_testRunners = Lists.newArrayList();
    private transient List<ISuiteListener> m_listeners = Lists.newArrayList();
    private transient TestListenerAdapter m_textReporter = new TestListenerAdapter();
    private String m_outputDir;
    private XmlSuite m_suite;
    private transient List<ITestListener> m_testListeners = Lists.newArrayList();
    private transient ITestRunnerFactory m_tmpRunnerFactory;
    private transient ITestRunnerFactory m_runnerFactory;
    private transient boolean m_useDefaultListeners = true;
    private String m_host;
    private transient IConfiguration m_configuration;
    private transient ITestObjectFactory m_objectFactory;
    private transient Boolean m_skipFailedInvocationCounts = Boolean.FALSE;
    private transient IMethodInterceptor m_methodInterceptor;
    private List<IInvokedMethodListener> m_invokedMethodListeners;
    private List<IInvokedMethod> m_invokedMethods = Collections.synchronizedList(Lists.newArrayList());
    private List<ITestNGMethod> m_allTestMethods = Lists.newArrayList();
    private List<IReporter> m_reporters = Lists.newArrayList();
    private SuiteRunState m_suiteState = new SuiteRunState();
    private IAttributes m_attributes = new Attributes();

    public SuiteRunner(IConfiguration configuration, XmlSuite suite, String outputDir) {
        this(configuration, suite, outputDir, null);
    }

    public SuiteRunner(IConfiguration configuration, XmlSuite suite, String outputDir, ITestRunnerFactory runnerFactory) {
        this(configuration, suite, outputDir, runnerFactory, false);
    }

    public SuiteRunner(IConfiguration configuration, XmlSuite suite, String outputDir, ITestRunnerFactory runnerFactory, boolean useDefaultListeners) {
        this(configuration, suite, outputDir, runnerFactory, useDefaultListeners, null, null, null);
    }

    protected SuiteRunner(IConfiguration configuration, XmlSuite suite, String outputDir, ITestRunnerFactory runnerFactory, boolean useDefaultListeners, IMethodInterceptor methodInterceptor, List<IInvokedMethodListener> invokedMethodListeners, List<ITestListener> testListeners) {
        this.init(configuration, suite, outputDir, runnerFactory, useDefaultListeners, methodInterceptor, invokedMethodListeners, testListeners);
    }

    private void init(IConfiguration configuration, XmlSuite suite, String outputDir, ITestRunnerFactory runnerFactory, boolean useDefaultListeners, IMethodInterceptor methodInterceptor, List<IInvokedMethodListener> invokedMethodListener, List<ITestListener> testListeners) {
        this.m_configuration = configuration;
        this.m_suite = suite;
        this.m_useDefaultListeners = useDefaultListeners;
        this.m_tmpRunnerFactory = runnerFactory;
        this.m_methodInterceptor = methodInterceptor;
        this.setOutputDir(outputDir);
        this.m_objectFactory = this.m_configuration.getObjectFactory();
        if (this.m_objectFactory == null) {
            this.m_objectFactory = suite.getObjectFactory();
        }
        this.m_invokedMethodListeners = invokedMethodListener;
        if (this.m_invokedMethodListeners == null) {
            this.m_invokedMethodListeners = Lists.newArrayList();
        }
        this.m_invokedMethodListeners.add(this);
        this.m_skipFailedInvocationCounts = suite.skipFailedInvocationCounts();
        if (null != testListeners) {
            this.m_testListeners.addAll(testListeners);
        }
        this.m_runnerFactory = this.buildRunnerFactory();
        List<XmlTest> xmlTests = this.m_suite.getTests();
        Collections.sort(xmlTests, new Comparator<XmlTest>(){

            @Override
            public int compare(XmlTest arg0, XmlTest arg1) {
                return arg0.getIndex() - arg1.getIndex();
            }
        });
        for (XmlTest test : xmlTests) {
            TestRunner tr = this.m_runnerFactory.newTestRunner(this, test, this.m_invokedMethodListeners);
            if (this.m_methodInterceptor != null) {
                tr.setMethodInterceptor(this.m_methodInterceptor);
            }
            tr.addListener(this.m_textReporter);
            this.m_testRunners.add(tr);
            this.m_allTestMethods.addAll(Arrays.asList(tr.getAllTestMethods()));
        }
    }

    @Override
    public XmlSuite getXmlSuite() {
        return this.m_suite;
    }

    @Override
    public String getName() {
        return this.m_suite.getName();
    }

    public void setObjectFactory(ITestObjectFactory objectFactory) {
        this.m_objectFactory = objectFactory;
    }

    public void setReportResults(boolean reportResults) {
        this.m_useDefaultListeners = reportResults;
    }

    private void invokeListeners(boolean start) {
        for (ISuiteListener sl : this.m_listeners) {
            if (start) {
                sl.onStart(this);
                continue;
            }
            sl.onFinish(this);
        }
    }

    private void setOutputDir(String outputdir) {
        if (Utils.isStringBlank(outputdir) && this.m_useDefaultListeners) {
            outputdir = DEFAULT_OUTPUT_DIR;
        }
        this.m_outputDir = null != outputdir ? new File(outputdir).getAbsolutePath() : null;
    }

    private ITestRunnerFactory buildRunnerFactory() {
        ITestRunnerFactory factory = null;
        factory = null == this.m_tmpRunnerFactory ? new DefaultTestRunnerFactory(this.m_configuration, this.m_testListeners.toArray(new ITestListener[this.m_testListeners.size()]), this.m_useDefaultListeners, this.m_skipFailedInvocationCounts) : new ProxyTestRunnerFactory(this.m_testListeners.toArray(new ITestListener[this.m_testListeners.size()]), this.m_tmpRunnerFactory);
        return factory;
    }

    @Override
    public String getParallel() {
        return this.m_suite.getParallel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.invokeListeners(true);
        try {
            this.privateRun();
            Object var2_1 = null;
            this.invokeListeners(false);
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.invokeListeners(false);
            throw throwable;
        }
    }

    private void privateRun() {
        LinkedHashMap<Method, ITestNGMethod> beforeSuiteMethods = new LinkedHashMap<Method, ITestNGMethod>();
        LinkedHashMap<Method, ITestNGMethod> afterSuiteMethods = new LinkedHashMap<Method, ITestNGMethod>();
        IInvoker invoker = null;
        for (TestRunner tr : this.m_testRunners) {
            invoker = tr.getInvoker();
            for (ITestNGMethod m : tr.getBeforeSuiteMethods()) {
                beforeSuiteMethods.put(m.getMethod(), m);
            }
            for (ITestNGMethod m : tr.getAfterSuiteMethods()) {
                afterSuiteMethods.put(m.getMethod(), m);
            }
        }
        if (invoker != null) {
            if (beforeSuiteMethods.values().size() > 0) {
                invoker.invokeConfigurations(null, beforeSuiteMethods.values().toArray(new ITestNGMethod[beforeSuiteMethods.size()]), this.m_suite, this.m_suite.getParameters(), null, null);
            }
            Utils.log("SuiteRunner", 3, "Created " + this.m_testRunners.size() + " TestRunners");
            boolean testsInParallel = "tests".equals(this.m_suite.getParallel());
            if (!testsInParallel) {
                this.runSequentially();
            } else {
                this.runInParallelTestMode();
            }
            if (afterSuiteMethods.values().size() > 0) {
                invoker.invokeConfigurations(null, afterSuiteMethods.values().toArray(new ITestNGMethod[afterSuiteMethods.size()]), this.m_suite, this.m_suite.getAllParameters(), null, null);
            }
        }
    }

    private void addReporter(IReporter listener) {
        this.m_reporters.add(listener);
    }

    public List<IReporter> getReporters() {
        return this.m_reporters;
    }

    private void runSequentially() {
        for (TestRunner tr : this.m_testRunners) {
            this.runTest(tr);
        }
    }

    private void runTest(TestRunner tr) {
        tr.run();
        SuiteResult sr = new SuiteResult(this.m_suite, tr);
        this.m_suiteResults.put(tr.getName(), sr);
    }

    private void runInParallelTestMode() {
        List tasks = Lists.newArrayList(this.m_testRunners.size());
        for (TestRunner tr : this.m_testRunners) {
            tasks.add(new SuiteWorker(tr));
        }
        ThreadUtil.execute(tasks, this.m_suite.getThreadCount(), this.m_suite.getTimeOut(XmlTest.DEFAULT_TIMEOUT_MS), false);
    }

    protected void addListener(ISuiteListener reporter) {
        this.m_listeners.add(reporter);
    }

    @Override
    public void addListener(ITestNGListener listener) {
        if (listener instanceof IInvokedMethodListener) {
            this.m_invokedMethodListeners.add((IInvokedMethodListener)listener);
        }
        if (listener instanceof ISuiteListener) {
            this.addListener((ISuiteListener)listener);
        }
        if (listener instanceof IReporter) {
            this.addReporter((IReporter)listener);
        }
        if (listener instanceof IConfigurationListener) {
            this.m_configuration.addConfigurationListener((IConfigurationListener)listener);
        }
    }

    @Override
    public String getOutputDirectory() {
        return this.m_outputDir + File.separatorChar + this.getName();
    }

    @Override
    public Map<String, ISuiteResult> getResults() {
        return this.m_suiteResults;
    }

    @Override
    public String getParameter(String parameterName) {
        return this.m_suite.getParameter(parameterName);
    }

    @Override
    public Map<String, Collection<ITestNGMethod>> getMethodsByGroups() {
        Map<String, Collection<ITestNGMethod>> result = Maps.newHashMap();
        for (TestRunner tr : this.m_testRunners) {
            ITestNGMethod[] methods;
            for (ITestNGMethod m : methods = tr.getAllTestMethods()) {
                String[] groups;
                for (String groupName : groups = m.getGroups()) {
                    Collection<ITestNGMethod> testMethods = result.get(groupName);
                    if (null == testMethods) {
                        testMethods = Lists.newArrayList();
                        result.put(groupName, testMethods);
                    }
                    testMethods.add(m);
                }
            }
        }
        return result;
    }

    @Override
    public Collection<ITestNGMethod> getInvokedMethods() {
        return this.getIncludedOrExcludedMethods(true);
    }

    @Override
    public Collection<ITestNGMethod> getExcludedMethods() {
        return this.getIncludedOrExcludedMethods(false);
    }

    private Collection<ITestNGMethod> getIncludedOrExcludedMethods(boolean included) {
        List<ITestNGMethod> result = Lists.newArrayList();
        for (TestRunner tr : this.m_testRunners) {
            Collection<ITestNGMethod> methods = included ? tr.getInvokedMethods() : tr.getExcludedMethods();
            for (ITestNGMethod m : methods) {
                result.add(m);
            }
        }
        return result;
    }

    @Override
    public IObjectFactory getObjectFactory() {
        return this.m_objectFactory instanceof IObjectFactory ? (IObjectFactory)this.m_objectFactory : null;
    }

    @Override
    public IObjectFactory2 getObjectFactory2() {
        return this.m_objectFactory instanceof IObjectFactory2 ? (IObjectFactory2)this.m_objectFactory : null;
    }

    @Override
    public IAnnotationFinder getAnnotationFinder() {
        return this.m_configuration.getAnnotationFinder();
    }

    public static void ppp(String s) {
        System.out.println("[SuiteRunner] " + s);
    }

    public void setHost(String host) {
        this.m_host = host;
    }

    @Override
    public String getHost() {
        return this.m_host;
    }

    @Override
    public SuiteRunState getSuiteState() {
        return this.m_suiteState;
    }

    public void setSkipFailedInvocationCounts(Boolean skipFailedInvocationCounts) {
        if (skipFailedInvocationCounts != null) {
            this.m_skipFailedInvocationCounts = skipFailedInvocationCounts;
        }
    }

    @Override
    public Object getAttribute(String name) {
        return this.m_attributes.getAttribute(name);
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.m_attributes.setAttribute(name, value);
    }

    @Override
    public Set<String> getAttributeNames() {
        return this.m_attributes.getAttributeNames();
    }

    @Override
    public Object removeAttribute(String name) {
        return this.m_attributes.removeAttribute(name);
    }

    @Override
    public void afterInvocation(IInvokedMethod method, ITestResult testResult) {
    }

    @Override
    public void beforeInvocation(IInvokedMethod method, ITestResult testResult) {
        if (method == null) {
            throw new NullPointerException("Method should not be null");
        }
        this.m_invokedMethods.add(method);
    }

    @Override
    public List<IInvokedMethod> getAllInvokedMethods() {
        return this.m_invokedMethods;
    }

    @Override
    public List<ITestNGMethod> getAllMethods() {
        return this.m_allTestMethods;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProxyTestRunnerFactory
    implements ITestRunnerFactory {
        private ITestListener[] m_failureGenerators;
        private ITestRunnerFactory m_target;

        public ProxyTestRunnerFactory(ITestListener[] failureListeners, ITestRunnerFactory target) {
            this.m_failureGenerators = failureListeners;
            this.m_target = target;
        }

        @Override
        public TestRunner newTestRunner(ISuite suite, XmlTest test, List<IInvokedMethodListener> listeners) {
            TestRunner testRunner = this.m_target.newTestRunner(suite, test, listeners);
            testRunner.addListener(new TextReporter(testRunner.getName(), TestRunner.getVerbose()));
            for (ITestListener itl : this.m_failureGenerators) {
                testRunner.addListener(itl);
            }
            return testRunner;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultTestRunnerFactory
    implements ITestRunnerFactory {
        private ITestListener[] m_failureGenerators;
        private boolean m_useDefaultListeners;
        private boolean m_skipFailedInvocationCounts;
        private IConfiguration m_configuration;

        public DefaultTestRunnerFactory(IConfiguration configuration, ITestListener[] failureListeners, boolean useDefaultListeners, boolean skipFailedInvocationCounts) {
            this.m_configuration = configuration;
            this.m_failureGenerators = failureListeners;
            this.m_useDefaultListeners = useDefaultListeners;
            this.m_skipFailedInvocationCounts = skipFailedInvocationCounts;
        }

        @Override
        public TestRunner newTestRunner(ISuite suite, XmlTest test, List<IInvokedMethodListener> listeners) {
            boolean skip = this.m_skipFailedInvocationCounts;
            if (!skip) {
                skip = test.skipFailedInvocationCounts();
            }
            TestRunner testRunner = new TestRunner(this.m_configuration, suite, test, suite.getOutputDirectory(), suite.getAnnotationFinder(), skip, listeners);
            if (this.m_useDefaultListeners) {
                testRunner.addListener(new TestHTMLReporter());
                testRunner.addListener(new JUnitXMLReporter());
                testRunner.addListener(new TextReporter(testRunner.getName(), TestRunner.getVerbose()));
            }
            for (ITestListener itl : this.m_failureGenerators) {
                testRunner.addListener(itl);
            }
            for (IConfigurationListener cl : this.m_configuration.getConfigurationListeners()) {
                testRunner.addConfigurationListener(cl);
            }
            return testRunner;
        }
    }

    private class SuiteWorker
    implements Runnable {
        private TestRunner m_testRunner;

        public SuiteWorker(TestRunner tr) {
            this.m_testRunner = tr;
        }

        public void run() {
            Utils.log("[SuiteWorker]", 4, "Running XML Test '" + this.m_testRunner.getTest().getName() + "' in Parallel");
            SuiteRunner.this.runTest(this.m_testRunner);
        }
    }
}

