package org.gridvise.mgmtcache.coh.invocation.tasks
import org.gridvise.LocalAPI
import org.gridvise.coherence.cache.invocation.AbstractRemoteTask
import org.gridvise.mgmtcache.coh.entity.launchable.LaunchableKey
import org.gridvise.mgmtcache.coh.entity.launchable.LaunchableCache
import org.gridvise.logical.os.MachineInfo

class RemoteStartTask extends RemoteLaunchableTask {
  
  def execute(): String = {
    var launchableKeys: Seq[LaunchableKey] = this.getLaunchableKeys()
    if (launchableKeys == null) {
    	LocalAPI.start()
    } else {
          launchableKeys.foreach { key => start(key) }
    }
    "started"
  }

  def start(key: LaunchableKey) {
    println("starting... " + key)
    if(key.machineName.equals(MachineInfo.getMachineName())){
    	LaunchableCache.get(key).start()
    }
  }

}