/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.config.ConfigResolveOptions;
import com.typesafe.config.impl.ConfigImpl;
import com.typesafe.config.impl.Parseable;
import java.io.File;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;

public final class ConfigFactory {
    private ConfigFactory() {
    }

    public static Config load(String string) {
        return ConfigFactory.load(Thread.currentThread().getContextClassLoader(), string);
    }

    public static Config load(ClassLoader classLoader, String string) {
        return ConfigFactory.load(classLoader, string, ConfigParseOptions.defaults(), ConfigResolveOptions.defaults());
    }

    public static Config load(String string, ConfigParseOptions configParseOptions, ConfigResolveOptions configResolveOptions) {
        return ConfigFactory.load(Thread.currentThread().getContextClassLoader(), string, configParseOptions, configResolveOptions);
    }

    public static Config load(ClassLoader classLoader, String string, ConfigParseOptions configParseOptions, ConfigResolveOptions configResolveOptions) {
        Config config = ConfigFactory.parseResourcesAnySyntax(classLoader, string, configParseOptions);
        return ConfigFactory.load(classLoader, config, configResolveOptions);
    }

    public static Config load(Config config) {
        return ConfigFactory.load(Thread.currentThread().getContextClassLoader(), config);
    }

    public static Config load(ClassLoader classLoader, Config config) {
        return ConfigFactory.load(classLoader, config, ConfigResolveOptions.defaults());
    }

    public static Config load(Config config, ConfigResolveOptions configResolveOptions) {
        return ConfigFactory.load(Thread.currentThread().getContextClassLoader(), config, configResolveOptions);
    }

    public static Config load(ClassLoader classLoader, Config config, ConfigResolveOptions configResolveOptions) {
        return ConfigFactory.defaultOverrides(classLoader).withFallback(config).withFallback(ConfigFactory.defaultReference(classLoader)).resolve(configResolveOptions);
    }

    private static Config loadDefaultConfig(ClassLoader classLoader) {
        String string;
        String string2;
        int n = 0;
        String string3 = System.getProperty("config.resource");
        if (string3 != null) {
            ++n;
        }
        if ((string2 = System.getProperty("config.file")) != null) {
            ++n;
        }
        if ((string = System.getProperty("config.url")) != null) {
            ++n;
        }
        if (n == 0) {
            return ConfigFactory.load(classLoader, "application");
        }
        if (n > 1) {
            throw new ConfigException.Generic("You set more than one of config.file='" + string2 + "', config.url='" + string + "', config.resource='" + string3 + "'; don't know which one to use!");
        }
        if (string3 != null) {
            if (string3.startsWith("/")) {
                string3 = string3.substring(1);
            }
            return ConfigFactory.load(classLoader, ConfigFactory.parseResources(classLoader, string3));
        }
        if (string2 != null) {
            return ConfigFactory.load(classLoader, ConfigFactory.parseFile(new File(string2)));
        }
        try {
            return ConfigFactory.load(classLoader, ConfigFactory.parseURL(new URL(string)));
        }
        catch (MalformedURLException malformedURLException) {
            throw new ConfigException.Generic("Bad URL in config.url system property: '" + string + "': " + malformedURLException.getMessage(), malformedURLException);
        }
    }

    public static Config load() {
        return ConfigFactory.load(Thread.currentThread().getContextClassLoader());
    }

    public static Config load(ClassLoader classLoader) {
        return ConfigFactory.loadDefaultConfig(classLoader);
    }

    public static Config defaultReference() {
        return ConfigFactory.defaultReference(Thread.currentThread().getContextClassLoader());
    }

    public static Config defaultReference(ClassLoader classLoader) {
        return ConfigImpl.defaultReference(classLoader);
    }

    public static Config defaultOverrides() {
        return ConfigFactory.systemProperties();
    }

    public static Config defaultOverrides(ClassLoader classLoader) {
        return ConfigFactory.systemProperties();
    }

    public static Config empty() {
        return ConfigFactory.empty(null);
    }

    public static Config empty(String string) {
        return ConfigImpl.emptyConfig(string);
    }

    public static Config systemProperties() {
        return ConfigImpl.systemPropertiesAsConfig();
    }

    public static Config systemEnvironment() {
        return ConfigImpl.envVariablesAsConfig();
    }

    public static Config parseProperties(Properties properties, ConfigParseOptions configParseOptions) {
        return Parseable.newProperties(properties, configParseOptions).parse().toConfig();
    }

    public static Config parseProperties(Properties properties) {
        return ConfigFactory.parseProperties(properties, ConfigParseOptions.defaults());
    }

    public static Config parseReader(Reader reader, ConfigParseOptions configParseOptions) {
        return Parseable.newReader(reader, configParseOptions).parse().toConfig();
    }

    public static Config parseReader(Reader reader) {
        return ConfigFactory.parseReader(reader, ConfigParseOptions.defaults());
    }

    public static Config parseURL(URL uRL, ConfigParseOptions configParseOptions) {
        return Parseable.newURL(uRL, configParseOptions).parse().toConfig();
    }

    public static Config parseURL(URL uRL) {
        return ConfigFactory.parseURL(uRL, ConfigParseOptions.defaults());
    }

    public static Config parseFile(File file, ConfigParseOptions configParseOptions) {
        return Parseable.newFile(file, configParseOptions).parse().toConfig();
    }

    public static Config parseFile(File file) {
        return ConfigFactory.parseFile(file, ConfigParseOptions.defaults());
    }

    public static Config parseFileAnySyntax(File file, ConfigParseOptions configParseOptions) {
        return ConfigImpl.parseFileAnySyntax(file, configParseOptions).toConfig();
    }

    public static Config parseFileAnySyntax(File file) {
        return ConfigFactory.parseFileAnySyntax(file, ConfigParseOptions.defaults());
    }

    public static Config parseResources(Class<?> clazz, String string, ConfigParseOptions configParseOptions) {
        return Parseable.newResources(clazz, string, configParseOptions).parse().toConfig();
    }

    public static Config parseResources(Class<?> clazz, String string) {
        return ConfigFactory.parseResources(clazz, string, ConfigParseOptions.defaults());
    }

    public static Config parseResourcesAnySyntax(Class<?> clazz, String string, ConfigParseOptions configParseOptions) {
        return ConfigImpl.parseResourcesAnySyntax(clazz, string, configParseOptions).toConfig();
    }

    public static Config parseResourcesAnySyntax(Class<?> clazz, String string) {
        return ConfigFactory.parseResourcesAnySyntax(clazz, string, ConfigParseOptions.defaults());
    }

    public static Config parseResources(ClassLoader classLoader, String string, ConfigParseOptions configParseOptions) {
        return Parseable.newResources(classLoader, string, configParseOptions).parse().toConfig();
    }

    public static Config parseResources(ClassLoader classLoader, String string) {
        return ConfigFactory.parseResources(classLoader, string, ConfigParseOptions.defaults());
    }

    public static Config parseResourcesAnySyntax(ClassLoader classLoader, String string, ConfigParseOptions configParseOptions) {
        return ConfigImpl.parseResourcesAnySyntax(classLoader, string, configParseOptions).toConfig();
    }

    public static Config parseResourcesAnySyntax(ClassLoader classLoader, String string) {
        return ConfigFactory.parseResourcesAnySyntax(classLoader, string, ConfigParseOptions.defaults());
    }

    public static Config parseResources(String string, ConfigParseOptions configParseOptions) {
        return Parseable.newResources(Thread.currentThread().getContextClassLoader(), string, configParseOptions).parse().toConfig();
    }

    public static Config parseResources(String string) {
        return ConfigFactory.parseResources(Thread.currentThread().getContextClassLoader(), string, ConfigParseOptions.defaults());
    }

    public static Config parseResourcesAnySyntax(String string, ConfigParseOptions configParseOptions) {
        return ConfigImpl.parseResourcesAnySyntax(Thread.currentThread().getContextClassLoader(), string, configParseOptions).toConfig();
    }

    public static Config parseResourcesAnySyntax(String string) {
        return ConfigFactory.parseResourcesAnySyntax(Thread.currentThread().getContextClassLoader(), string, ConfigParseOptions.defaults());
    }

    public static Config parseString(String string, ConfigParseOptions configParseOptions) {
        return Parseable.newString(string, configParseOptions).parse().toConfig();
    }

    public static Config parseString(String string) {
        return ConfigFactory.parseString(string, ConfigParseOptions.defaults());
    }

    public static Config parseMap(Map<String, ? extends Object> map2, String string) {
        return ConfigImpl.fromPathMap(map2, string).toConfig();
    }

    public static Config parseMap(Map<String, ? extends Object> map2) {
        return ConfigFactory.parseMap(map2, null);
    }
}

