/*
 * Decompiled with CFR 0.152.
 */
package org.gridvise.coherence.cache.entity;

import com.tangosol.net.NamedCache;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.aggregator.DistinctValues;
import com.tangosol.util.extractor.KeyExtractor;
import com.tangosol.util.extractor.ReflectionExtractor;
import com.tangosol.util.filter.EqualsFilter;
import com.tangosol.util.filter.LessEqualsFilter;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.gridvise.coherence.cache.entity.AbstractCache;
import org.gridvise.coherence.cache.entity.IDateSensitiveCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDateSensitiveCache<K, V>
extends AbstractCache<K, V>
implements IDateSensitiveCache<K, V> {
    private static final ValueExtractor KEY_EFFECTIVE_DATE_EXTRACTOR = new KeyExtractor("getDate");
    private static final ValueExtractor VALUE_EFFECTIVE_DATE_EXTRACTOR = new ReflectionExtractor("getDate");
    private boolean keyBased;

    public AbstractDateSensitiveCache() {
        this(true);
    }

    public AbstractDateSensitiveCache(boolean keyBased) {
        this.keyBased = keyBased;
    }

    @Override
    public void evictDaysOlderOrEquals(Date effectiveDate) {
        Collection keys = this.keySet((Filter)new LessEqualsFilter(this.getEffectiveDateExtractor(), (Comparable)effectiveDate));
        this.remove(keys);
    }

    @Override
    public ValueExtractor getEffectiveDateExtractor() {
        return this.keyBased ? KEY_EFFECTIVE_DATE_EXTRACTOR : VALUE_EFFECTIVE_DATE_EXTRACTOR;
    }

    @Override
    public Filter getEffectiveDateFilter(Date effectiveDate) {
        return new EqualsFilter(this.getEffectiveDateExtractor(), (Object)effectiveDate);
    }

    @Override
    public void evictDay(Date effectiveDate) {
        this.remove(this.getKeysForDate(effectiveDate));
    }

    @Override
    public Collection<V> getValuesForDate(Date effectiveDate) {
        return (Collection)((Object)this.getCache().getAll(this.getKeysForDate(effectiveDate)));
    }

    @Override
    public Collection<K> getKeysForDate(Date effectiveDate) {
        return this.keySet((Filter)new EqualsFilter(this.getEffectiveDateExtractor(), (Object)effectiveDate));
    }

    @Override
    public Date getLatestEffectiveDate() {
        return this.getSortedEffectiveDates().last();
    }

    @Override
    public Date getEarliestEffectiveDate() {
        return this.getSortedEffectiveDates().first();
    }

    @Override
    public SortedSet<Date> getSortedEffectiveDates() {
        TreeSet<Date> sortedEffectiveDates = new TreeSet<Date>();
        sortedEffectiveDates.addAll(this.getEffectiveDates());
        return sortedEffectiveDates;
    }

    public Set<Date> getEffectiveDates() {
        return (Set)this.getCache().aggregate(PRESENT_FILTER, (InvocableMap.EntryAggregator)new DistinctValues(this.getEffectiveDateExtractor()));
    }

    @Override
    protected void addIndexes(NamedCache namedCache) {
        this.addIndex(this.getEffectiveDateExtractor(), namedCache);
    }

    @Override
    public <E> Collection<E> distictValuesForDate(Date effectiveDate, Enum<?> extractMethodName) {
        EqualsFilter effectiveDateFilter = new EqualsFilter(this.getEffectiveDateExtractor(), (Object)effectiveDate);
        return super.distictValues((Filter)effectiveDateFilter, extractMethodName);
    }

    @Override
    public <E> Collection<E> distictSetValuesForDate(Date effectiveDate, Enum<?> setExtractMethodName) {
        EqualsFilter effectiveDateFilter = new EqualsFilter(this.getEffectiveDateExtractor(), (Object)effectiveDate);
        return super.distictSetValues((Filter)effectiveDateFilter, setExtractMethodName);
    }
}

