package org.gridvise.mgmtcache.coh
import java.lang.System.getProperties
import java.net.URLClassLoader
import scala.actors.Actor
import org.gridvise.logical.messages.Start
import org.gridvise.mgmtcache.coh.entity.config.ConfigCache
import org.gridvise.LocalAPI
import com.tangosol.net.DefaultCacheServer
import org.springframework.context.support.ClassPathXmlApplicationContext

object ManagementCacheServer extends Actor {

  def main(args: Array[String]): Unit = {

    //TODO hook this into some sort of life cycle of the ManagmentCluster
    // to avoid two different ManagementCacheServer from inserting this 
    getProperties().put("tangosol.coherence.cacheconfig", "management-cache-config.xml")
    getProperties().put("localstorage.dist.mgmt", "true")
    getProperties().put("localstorage.invocation.mgmt", "true")

    this.start()
    this ! Start

    val config = getProperties().getProperty("grivdise.config")
      
     println("attempting to load grid config from "+config)

    val xmlBufferSource = scala.io.Source.fromFile(config)
    val xmlConfigString = xmlBufferSource.mkString
    xmlBufferSource.close()

    ConfigCache.putConfig(xmlConfigString)
    println("inserted config")
    LocalAPI.initialize()
    
    //bit of ascii art!
    println("\n\n***************************************************")
    println("******************* initialized *******************")
    println("***************************************************\n\n")
    
    new ClassPathXmlApplicationContext("check-schedule.xml");
  }

  def act() {
    while (true) {
      receive {
        case Start => DefaultCacheServer.main(new Array[String](0))
      }
    }
  }
  
  def printlnCPInfo() {
    var sysClassLoader = ClassLoader.getSystemClassLoader().asInstanceOf[URLClassLoader];

        //Get the URLs
       var urls = sysClassLoader.getURLs();
       urls.foreach(cp => println(cp+":"))
  }
}