/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.common.internal.net.socketbus;

import com.oracle.common.base.Disposable;
import com.oracle.common.base.Holder;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public class SharedBuffer
implements Holder<ByteBuffer>,
Disposable {
    protected final ByteBuffer m_buffer;
    protected final Disposer m_disposer;
    protected volatile int m_cRefs = 1;
    private static final AtomicIntegerFieldUpdater REF_COUNT_UPDATER = AtomicIntegerFieldUpdater.newUpdater(SharedBuffer.class, "m_cRefs");

    public SharedBuffer(ByteBuffer buffer, Disposer disposer) {
        this.m_buffer = buffer;
        this.m_disposer = disposer;
    }

    public Segment getSegment(int of, int cb) {
        return new Segment(of, cb);
    }

    public Segment getSegment() {
        return new Segment();
    }

    public SharedBuffer attach() {
        this.safeAdjust(true);
        return this;
    }

    public void detach() {
        if (this.safeAdjust(false) == 0) {
            this.m_disposer.dispose(this.m_buffer);
        }
    }

    @Override
    public void set(ByteBuffer value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuffer get() {
        return this.m_buffer;
    }

    @Override
    public void dispose() {
        this.detach();
    }

    protected final int safeAdjust(boolean fIncrement) {
        int cNew;
        int cCurr;
        do {
            if ((cCurr = this.m_cRefs) <= 0) {
                throw new IllegalStateException();
            }
            cNew = cCurr + (fIncrement ? 1 : -1);
            if (cCurr != Integer.MAX_VALUE) continue;
            return cCurr;
        } while (!REF_COUNT_UPDATER.compareAndSet(this, cCurr, cNew));
        return cNew;
    }

    public static interface Disposer {
        public void dispose(ByteBuffer var1);
    }

    public class Segment
    implements Holder<ByteBuffer>,
    Disposable {
        protected final ByteBuffer m_bufferSegment;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Segment() {
            SharedBuffer sharedBuffer2 = SharedBuffer.this;
            synchronized (sharedBuffer2) {
                this.m_bufferSegment = SharedBuffer.this.m_buffer.slice();
            }
            SharedBuffer.this.safeAdjust(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Segment(int of, int cb) {
            SharedBuffer sharedBuffer2 = SharedBuffer.this;
            synchronized (sharedBuffer2) {
                ByteBuffer buff = SharedBuffer.this.m_buffer;
                buff.limit(of + cb).position(of);
                this.m_bufferSegment = buff.slice();
            }
            SharedBuffer.this.safeAdjust(true);
        }

        @Override
        public void set(ByteBuffer value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ByteBuffer get() {
            return this.m_bufferSegment;
        }

        @Override
        public void dispose() {
            SharedBuffer.this.detach();
        }
    }
}

