/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.common.io;

import com.oracle.common.internal.io.AbstractBufferManager;
import com.oracle.common.internal.io.CheckedBufferManager;
import com.oracle.common.internal.io.SegmentedBufferManager;
import com.oracle.common.io.BufferManager;
import com.oracle.common.io.MemorySize;
import java.nio.ByteBuffer;

public final class BufferManagers {
    public static BufferManager getHeapManager() {
        return HeapManagerHolder.INSTANCE;
    }

    public static BufferManager getDirectManager() {
        return DirectManagerHolder.INSTANCE;
    }

    public static BufferManager getNetworkDirectManager() {
        return NetworkDirectManagerHolder.INSTANCE;
    }

    private static class NetworkDirectManagerHolder {
        public static final BufferManager INSTANCE;

        private NetworkDirectManagerHolder() {
        }

        static {
            BufferManager manager;
            try {
                Class.forName("com.oracle.exalogic.ExaManager");
            }
            catch (Throwable e) {
                // empty catch block
            }
            long cbMax = Runtime.getRuntime().maxMemory() / 10L;
            long lcbPool = new MemorySize(System.getProperty("buffermanager.network.pool", Long.toString(cbMax))).getByteCount();
            try {
                Class<?> clz = Class.forName("com.oracle.common.net.infinibus.DirectNetworkBufferManager");
                try {
                    manager = (BufferManager)clz.getMethod("newInstance", Long.TYPE).invoke(null, lcbPool);
                }
                catch (NoSuchMethodException e) {
                    manager = (BufferManager)clz.getMethod("newInstance", new Class[0]).invoke(null, new Object[0]);
                }
            }
            catch (Throwable e) {
                manager = DirectManagerHolder.INSTANCE;
            }
            INSTANCE = Boolean.getBoolean("buffermanager.network.checked") ? new CheckedBufferManager(manager) : manager;
        }
    }

    private static class DirectManagerHolder {
        public static final BufferManager INSTANCE;

        private DirectManagerHolder() {
        }

        static {
            long cbMax = Runtime.getRuntime().maxMemory() / 10L;
            long lcbPool = new MemorySize(System.getProperty("buffermanager.direct.pool", Long.toString(cbMax))).getByteCount();
            if (lcbPool > 0L) {
                SegmentedBufferManager mgr = new SegmentedBufferManager(new SegmentedBufferManager.BufferAllocator(){

                    @Override
                    public ByteBuffer allocate(int cb) {
                        return ByteBuffer.allocateDirect(cb);
                    }

                    @Override
                    public void release(ByteBuffer buff) {
                    }
                }, lcbPool){

                    protected void ensureCompatibility(ByteBuffer buff) {
                        if (!buff.isDirect()) {
                            throw new IllegalArgumentException();
                        }
                    }
                };
                INSTANCE = Boolean.getBoolean("buffermanager.direct.checked") ? new CheckedBufferManager(mgr) : mgr;
            } else {
                INSTANCE = new AbstractBufferManager(){

                    @Override
                    public ByteBuffer acquire(int cb) {
                        return ByteBuffer.allocateDirect(cb);
                    }

                    @Override
                    public void dispose() {
                    }

                    @Override
                    protected void ensureCompatibility(ByteBuffer buff) {
                        if (!buff.isDirect()) {
                            throw new IllegalArgumentException();
                        }
                    }
                };
            }
        }
    }

    private static class HeapManagerHolder {
        public static final BufferManager INSTANCE;

        private HeapManagerHolder() {
        }

        static {
            long lcbPool = new MemorySize(System.getProperty("buffermanager.heap.pool", "0MB")).getByteCount();
            if (lcbPool > 0L) {
                SegmentedBufferManager mgr = new SegmentedBufferManager(new SegmentedBufferManager.BufferAllocator(){

                    @Override
                    public ByteBuffer allocate(int cb) {
                        return ByteBuffer.allocate(cb);
                    }

                    @Override
                    public void release(ByteBuffer buff) {
                    }
                }, lcbPool){

                    protected void ensureCompatibility(ByteBuffer buff) {
                        if (buff.isDirect()) {
                            throw new IllegalArgumentException();
                        }
                    }
                };
                INSTANCE = Boolean.getBoolean("buffermanager.heap.checked") ? new CheckedBufferManager(mgr) : mgr;
            } else {
                INSTANCE = new AbstractBufferManager(){

                    @Override
                    public ByteBuffer acquire(int cb) {
                        return ByteBuffer.allocate(cb);
                    }

                    @Override
                    public void dispose() {
                    }

                    @Override
                    protected void ensureCompatibility(ByteBuffer buff) {
                        if (buff.isDirect()) {
                            throw new IllegalArgumentException();
                        }
                    }
                };
            }
        }
    }
}

