/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.common.net;

import java.net.InetAddress;
import java.util.Comparator;

public class InetAddressComparator
implements Comparator<InetAddress> {
    public static final InetAddressComparator INSTANCE = new InetAddressComparator();

    @Override
    public int compare(InetAddress addrA, InetAddress addrB) {
        int i;
        int ofB;
        int ofA;
        if (addrA == addrB) {
            return 0;
        }
        if (addrA == null) {
            return -1;
        }
        if (addrB == null) {
            return 1;
        }
        if (addrA.isLoopbackAddress() && addrB.isLoopbackAddress()) {
            return 0;
        }
        byte[] abA = addrA.getAddress();
        byte[] abB = addrB.getAddress();
        int cbA = abA.length;
        for (ofA = 0; ofA < cbA && abA[ofA] == 0; ++ofA) {
        }
        int cbsA = cbA - ofA;
        int cbB = abB.length;
        for (ofB = 0; ofB < cbB && abB[ofB] == 0; ++ofB) {
        }
        int cbsB = cbB - ofB;
        if (cbsA < cbsB) {
            return -1;
        }
        if (cbsB < cbsA) {
            return 1;
        }
        int c = cbsA;
        for (i = 0; i < c && abA[ofA + i] == abB[ofB + i]; ++i) {
        }
        return i == c ? 0 : ((0xFF & abA[0]) < (0xFF & abB[0]) ? -1 : 1);
    }
}

