/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.management.model.localModel;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.application.console.Coherence;
import com.tangosol.coherence.component.application.console.Coherence$Logger;
import com.tangosol.coherence.component.net.Cluster;
import com.tangosol.coherence.component.net.Cluster$SocketManager;
import com.tangosol.coherence.component.net.Cluster$SocketManager$MulticastUdpSocket;
import com.tangosol.coherence.component.net.Cluster$SocketManager$PreferredUnicastUdpSocket;
import com.tangosol.coherence.component.net.Cluster$SocketManager$UnicastUdpSocket;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.Member$FlowControl;
import com.tangosol.coherence.component.net.TcpRing;
import com.tangosol.coherence.component.net.management.Model;
import com.tangosol.coherence.component.net.management.model.LocalModel;
import com.tangosol.coherence.component.net.socket.udpSocket.MulticastUdpSocket;
import com.tangosol.coherence.component.net.socket.udpSocket.UnicastUdpSocket;
import com.tangosol.coherence.component.util.Queue;
import com.tangosol.coherence.component.util.SafeCluster;
import com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor.PacketPublisher;
import com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor.PacketPublisher$InQueue;
import com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor.PacketReceiver;
import com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor.PacketSpeaker;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService;
import com.tangosol.coherence.component.util.queue.concurrentQueue.balancedQueue.BundlingQueue;
import com.tangosol.net.ActionPolicy;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.ConfigurableQuorumPolicy;
import com.tangosol.net.Service;
import com.tangosol.util.Base;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.WrapperException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ClusterNodeModel
extends LocalModel {
    private int __m_BufferPublishSize;
    private int __m_BufferReceiveSize;
    private String __m_LoggingFormat;
    private int __m_LoggingLevel;
    private int __m_LoggingLimit;
    private int __m_MulticastThreshold;
    private int __m_ResendDelay;
    private int __m_SendAckDelay;
    private int __m_TrafficJamCount;
    private int __m_TrafficJamDelay;
    private transient com.tangosol.net.Cluster __m__Cluster;
    private transient com.tangosol.net.Member __m__Member;

    public ClusterNodeModel() {
        this(null, null, true);
    }

    public ClusterNodeModel(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.set_SnapshotMap(new HashMap());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public String ensureService(String sServiceName) {
        this.checkReadOnly("ensureService");
        Service service = CacheFactory.getService(sServiceName);
        return service == null ? null : service.getInfo().getServiceType();
    }

    public int getBufferPublishSize() {
        PacketPublisher publisher = this.get_Publisher();
        return publisher == null ? -1 : publisher.getUdpSocketUnicast().getBufferSent();
    }

    public int getBufferReceiveSize() {
        PacketPublisher publisher = this.get_Publisher();
        return publisher == null ? -1 : publisher.getUdpSocketUnicast().getBufferReceived();
    }

    public int getCpuCount() {
        return ((Member)this.get_Member()).getCpuCount();
    }

    public String getDescription() {
        return String.valueOf("Uid=") + this.get_Member().getUid();
    }

    public int getId() {
        return this.get_Member().getId();
    }

    public String getLoggingDestination() {
        Coherence singleton = (Coherence)Coherence.get_Instance();
        Coherence$Logger logger = singleton.getLogger();
        return logger == null ? null : logger.getDestination();
    }

    public String getLoggingFormat() {
        Coherence singleton = (Coherence)Coherence.get_Instance();
        Coherence$Logger logger = singleton.getLogger();
        return logger == null ? null : logger.getFormat();
    }

    public int getLoggingLevel() {
        Coherence singleton = (Coherence)Coherence.get_Instance();
        Coherence$Logger logger = singleton.getLogger();
        return logger == null ? -1 : logger.getLevel();
    }

    public int getLoggingLimit() {
        Coherence singleton = (Coherence)Coherence.get_Instance();
        Coherence$Logger logger = singleton.getLogger();
        return logger == null ? -1 : logger.getLimit();
    }

    public int getMachineId() {
        return this.get_Member().getMachineId();
    }

    public String getMachineName() {
        return Model.canonicalString(this.get_Member().getMachineName());
    }

    public String getMemberName() {
        return Model.canonicalString(this.get_Member().getMemberName());
    }

    public int getMemoryAvailableMB() {
        Runtime runtime = Runtime.getRuntime();
        return (int)((runtime.freeMemory() + runtime.maxMemory() - runtime.totalMemory()) / (long)(1024 * 1024));
    }

    public int getMemoryMaxMB() {
        return (int)(Runtime.getRuntime().maxMemory() / (long)(1024 * 1024));
    }

    public String getMulticastAddress() {
        PacketPublisher publisher = this.get_Publisher();
        MulticastUdpSocket socket = publisher == null ? null : publisher.getUdpSocketMulticast();
        return socket == null ? Model.canonicalString(null) : String.valueOf(socket.getInetAddress());
    }

    public int getMulticastPort() {
        PacketPublisher publisher = this.get_Publisher();
        MulticastUdpSocket socket = publisher == null ? null : publisher.getUdpSocketMulticast();
        return socket == null ? -1 : socket.getPort();
    }

    public int getMulticastTTL() {
        PacketPublisher publisher = this.get_Publisher();
        MulticastUdpSocket socket = publisher == null ? null : publisher.getUdpSocketMulticast();
        return socket == null ? -1 : socket.getTimeToLive();
    }

    public int getMulticastThreshold() {
        PacketPublisher publisher = this.get_Publisher();
        return publisher == null ? -1 : (int)((double)100 * publisher.getMulticastThreshold());
    }

    public long getNackSent() {
        PacketPublisher publisher = this.get_Publisher();
        return publisher == null ? -1L : publisher.getStatsNacksSent();
    }

    public float getPacketDeliveryEfficiency() {
        PacketPublisher publisher = this.get_Publisher();
        if (publisher == null) {
            return 0.0f;
        }
        long lSent = publisher.getStatsSent();
        long lWasted = publisher.getStatsResentExcess();
        return lSent == 0L ? 1.0f : (float)(1.0 - (double)lWasted / (double)lSent);
    }

    public long getPacketsBundled() {
        PacketSpeaker speaker = this.get_Speaker();
        return speaker == null ? -1L : ((BundlingQueue)speaker.getQueue()).getStatsBundled();
    }

    public long getPacketsReceived() {
        PacketReceiver receiver = this.get_Receiver();
        return receiver == null ? -1L : receiver.getStatsReceived();
    }

    public long getPacketsRepeated() {
        PacketReceiver receiver = this.get_Receiver();
        return receiver == null ? -1L : receiver.getStatsRepeated();
    }

    public long getPacketsResent() {
        PacketPublisher publisher = this.get_Publisher();
        return publisher == null ? -1L : publisher.getStatsResent();
    }

    public long getPacketsResentEarly() {
        PacketPublisher publisher = this.get_Publisher();
        return publisher == null ? -1L : publisher.getStatsResentEarly();
    }

    public long getPacketsResentExcess() {
        PacketPublisher publisher = this.get_Publisher();
        return publisher == null ? -1L : publisher.getStatsResentExcess();
    }

    public long getPacketsSent() {
        PacketPublisher publisher = this.get_Publisher();
        return publisher == null ? -1L : publisher.getStatsSent();
    }

    public int getPriority() {
        return ((Member)this.get_Member()).getPriority();
    }

    public String getProcessName() {
        return Model.canonicalString(this.get_Member().getProcessName());
    }

    public String getProductEdition() {
        return Member.EDITION_NAME[((Member)this.get_Member()).getEdition()];
    }

    public float getPublisherPacketUtilization() {
        SafeCluster clusterSafe = (SafeCluster)this.get_Cluster();
        if (clusterSafe.isRunning()) {
            Cluster$SocketManager manager = ((Cluster)clusterSafe.getCluster()).getSocketManager();
            Cluster$SocketManager$UnicastUdpSocket socket = manager.getUnicastUdpSocket();
            Cluster$SocketManager$PreferredUnicastUdpSocket socketPref = manager.getPreferredUnicastUdpSocket();
            Cluster$SocketManager$MulticastUdpSocket socketMulti = manager.getMulticastUdpSocket();
            long cPackets = socketPref.getCountSent() + socket.getCountSent();
            long cBytes = socketPref.getBytesSent() + socket.getBytesSent();
            if (socketMulti != null) {
                cPackets += (long)socketMulti.getCountSent();
                cBytes += socketMulti.getBytesSent();
            }
            if (cPackets == 0L) {
                return 1.0f;
            }
            return (float)((double)cBytes / (double)cPackets / (double)socketPref.getPacketLength());
        }
        return 0.0f;
    }

    public float getPublisherSuccessRate() {
        PacketPublisher publisher = this.get_Publisher();
        if (publisher == null) {
            return 0.0f;
        }
        long lSent = publisher.getStatsSent();
        long lResent = publisher.getStatsResent();
        return lSent == 0L ? 1.0f : (float)(1.0 - (double)lResent / (double)lSent);
    }

    public String getQuorumStatus() {
        StringBuilder sbQuorum = new StringBuilder();
        ClusterService service = this.get_ClusterService();
        if (service != null) {
            ActionPolicy policy = service.getActionPolicy();
            String sPolicy = null;
            String sStatus = service.getQuorumControl().formatStatus();
            if (sStatus.length() > 0) {
                sbQuorum.append(sStatus).append("; ");
            }
            if (policy instanceof NullImplementation.NullActionPolicy) {
                sPolicy = "Not configured";
            } else if (policy instanceof ConfigurableQuorumPolicy) {
                sPolicy = ((ConfigurableQuorumPolicy)policy).getStatusDescription();
            } else if (policy != null) {
                sPolicy = policy.toString();
            }
            if (sPolicy != null) {
                sbQuorum.append(sPolicy);
            }
        }
        return Model.canonicalString(sbQuorum.toString());
    }

    public String getRackName() {
        return Model.canonicalString(this.get_Member().getRackName());
    }

    public float getReceiverPacketUtilization() {
        SafeCluster clusterSafe = (SafeCluster)this.get_Cluster();
        if (clusterSafe.isRunning()) {
            Cluster$SocketManager manager = ((Cluster)clusterSafe.getCluster()).getSocketManager();
            Cluster$SocketManager$UnicastUdpSocket socket = manager.getUnicastUdpSocket();
            Cluster$SocketManager$PreferredUnicastUdpSocket socketPref = manager.getPreferredUnicastUdpSocket();
            Cluster$SocketManager$MulticastUdpSocket socketMulti = manager.getMulticastUdpSocket();
            long cPackets = socketPref.getCountReceived() + socket.getCountReceived();
            long cBytes = socketPref.getBytesReceived() + socket.getBytesReceived();
            if (socketMulti != null) {
                cPackets += (long)socketMulti.getCountReceived();
                cBytes += socketMulti.getBytesReceived();
            }
            if (cPackets == 0L) {
                return 1.0f;
            }
            return (float)((double)cBytes / (double)cPackets / (double)socketPref.getPacketLength());
        }
        return 0.0f;
    }

    public float getReceiverSuccessRate() {
        PacketReceiver receiver = this.get_Receiver();
        if (receiver == null) {
            return 0.0f;
        }
        long lReceived = receiver.getStatsReceived();
        long lRepeated = receiver.getStatsRepeated();
        return lReceived == 0L ? 1.0f : (float)(1.0 - (double)lRepeated / (double)lReceived);
    }

    public int getResendDelay() {
        PacketPublisher publisher = this.get_Publisher();
        return publisher == null ? -1 : publisher.getResendDelay();
    }

    public String getRoleName() {
        return Model.canonicalString(this.get_Member().getRoleName());
    }

    public int getSendAckDelay() {
        PacketPublisher publisher = this.get_Publisher();
        return publisher == null ? -1 : publisher.getAckDelay();
    }

    public int getSendQueueSize() {
        PacketPublisher publisher = this.get_Publisher();
        if (publisher == null) {
            return -1;
        }
        int iSize = ((PacketPublisher$InQueue)publisher.getQueue()).getPacketAdapter().size() + publisher.getResendQueue().size();
        Queue queueDeferred = publisher.getDeferredReadyQueue();
        if (queueDeferred != null) {
            iSize += queueDeferred.size();
        }
        return iSize;
    }

    public String getSiteName() {
        return Model.canonicalString(this.get_Member().getSiteName());
    }

    public int getSocketCount() {
        return ((Member)this.get_Member()).getSocketCount();
    }

    public String getStatistics() {
        SafeCluster clusterSafe = (SafeCluster)this.get_Cluster();
        if (clusterSafe.isRunning()) {
            return ((Cluster)clusterSafe.getCluster()).formatStats();
        }
        return "n/a";
    }

    public long getTcpRingFailures() {
        TcpRing ring = this.get_TcpRing();
        return ring != null ? ring.getStatsFailures() : -1L;
    }

    public Date getTimestamp() {
        return new Date(this.get_Member().getTimestamp());
    }

    public int getTrafficJamCount() {
        PacketPublisher publisher = this.get_Publisher();
        return publisher == null ? -1 : publisher.getCloggedCount();
    }

    public int getTrafficJamDelay() {
        PacketPublisher publisher = this.get_Publisher();
        return publisher == null ? -1 : publisher.getCloggedDelay();
    }

    public String getUnicastAddress() {
        return String.valueOf(this.get_Member().getAddress());
    }

    public int getUnicastPort() {
        return this.get_Member().getPort();
    }

    public int getWeakestChannel() {
        Member memberWorst;
        PacketPublisher publisher = this.get_Publisher();
        if (publisher != null && (memberWorst = Member.findWeakestMember(publisher.getMemberSet())) != null) {
            return memberWorst.getId();
        }
        return -1;
    }

    public String[] getWellKnownAddresses() {
        SafeCluster clusterSafe = (SafeCluster)this.get_Cluster();
        Set setWka = clusterSafe.isRunning() ? ((Cluster)clusterSafe.getCluster()).getClusterService().getWellKnownAddresses() : null;
        if (setWka == null) {
            return new String[0];
        }
        InetSocketAddress[] asock = new InetSocketAddress[setWka.size()];
        asock = setWka.toArray(asock);
        int cAddress = asock.length;
        String[] asAddress = new String[cAddress];
        int i = 0;
        while (i < cAddress) {
            asAddress[i] = String.valueOf(asock[i]);
            ++i;
        }
        return asAddress;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/management/model/localModel/ClusterNodeModel".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public com.tangosol.net.Cluster get_Cluster() {
        return this.__m__Cluster;
    }

    public ClusterService get_ClusterService() {
        SafeCluster clusterSafe = (SafeCluster)this.get_Cluster();
        return clusterSafe.isRunning() ? ((Cluster)clusterSafe.getCluster()).getClusterService() : null;
    }

    public static Component get_Instance() {
        return new ClusterNodeModel();
    }

    public com.tangosol.net.Member get_Member() {
        return this.__m__Member;
    }

    private final Component get_Module() {
        return this;
    }

    public PacketPublisher get_Publisher() {
        SafeCluster clusterSafe = (SafeCluster)this.get_Cluster();
        return clusterSafe.isRunning() ? ((Cluster)clusterSafe.getCluster()).getPublisher() : null;
    }

    public PacketReceiver get_Receiver() {
        SafeCluster clusterSafe = (SafeCluster)this.get_Cluster();
        return clusterSafe.isRunning() ? ((Cluster)clusterSafe.getCluster()).getReceiver() : null;
    }

    public PacketSpeaker get_Speaker() {
        SafeCluster clusterSafe = (SafeCluster)this.get_Cluster();
        return clusterSafe.isRunning() ? ((Cluster)clusterSafe.getCluster()).getSpeaker() : null;
    }

    public TcpRing get_TcpRing() {
        SafeCluster clusterSafe = (SafeCluster)this.get_Cluster();
        return clusterSafe.isRunning() ? ((Cluster)clusterSafe.getCluster()).getClusterService().getTcpRing() : null;
    }

    public boolean isFlowControlEnabled() {
        return Member$FlowControl.isEnabled();
    }

    public boolean isMulticastEnabled() {
        PacketPublisher publisher = this.get_Publisher();
        return publisher == null ? false : publisher.isMulticastEnabled();
    }

    public boolean isNackEnabled() {
        PacketPublisher publisher = this.get_Publisher();
        return publisher == null ? false : publisher.isNackEnabled();
    }

    public void readExternal(DataInput in) throws IOException {
        super.readExternal(in);
        Map mapSnapshot = this.get_SnapshotMap();
        mapSnapshot.put("BufferPublishSize", Base.makeInteger(ExternalizableHelper.readInt(in)));
        mapSnapshot.put("BufferReceiveSize", Base.makeInteger(ExternalizableHelper.readInt(in)));
        mapSnapshot.put("CpuCount", Base.makeInteger(ExternalizableHelper.readInt(in)));
        mapSnapshot.put("FlowControlEnabled", in.readBoolean());
        mapSnapshot.put("Id", Base.makeInteger(ExternalizableHelper.readInt(in)));
        mapSnapshot.put("LoggingDestination", ExternalizableHelper.readSafeUTF(in));
        mapSnapshot.put("LoggingFormat", ExternalizableHelper.readSafeUTF(in));
        mapSnapshot.put("LoggingLevel", Base.makeInteger(ExternalizableHelper.readInt(in)));
        mapSnapshot.put("LoggingLimit", Base.makeInteger(ExternalizableHelper.readInt(in)));
        mapSnapshot.put("MachineId", Base.makeInteger(ExternalizableHelper.readInt(in)));
        mapSnapshot.put("MachineName", ExternalizableHelper.readSafeUTF(in));
        mapSnapshot.put("MemberName", ExternalizableHelper.readSafeUTF(in));
        mapSnapshot.put("MemoryAvailableMB", Base.makeInteger(ExternalizableHelper.readInt(in)));
        mapSnapshot.put("MemoryMaxMB", Base.makeInteger(ExternalizableHelper.readInt(in)));
        mapSnapshot.put("MulticastAddress", ExternalizableHelper.readSafeUTF(in));
        mapSnapshot.put("MulticastEnabled", in.readBoolean());
        mapSnapshot.put("MulticastPort", Base.makeInteger(ExternalizableHelper.readInt(in)));
        mapSnapshot.put("MulticastThreshold", Base.makeInteger(ExternalizableHelper.readInt(in)));
        mapSnapshot.put("MulticastTTL", Base.makeInteger(ExternalizableHelper.readInt(in)));
        mapSnapshot.put("NackEnabled", in.readBoolean());
        mapSnapshot.put("NackSent", Base.makeLong(ExternalizableHelper.readLong(in)));
        mapSnapshot.put("PacketDeliveryEfficiency", new Float(in.readFloat()));
        mapSnapshot.put("PacketsBundled", Base.makeLong(ExternalizableHelper.readLong(in)));
        mapSnapshot.put("PacketsReceived", Base.makeLong(ExternalizableHelper.readLong(in)));
        mapSnapshot.put("PacketsRepeated", Base.makeLong(ExternalizableHelper.readLong(in)));
        mapSnapshot.put("PacketsResent", Base.makeLong(ExternalizableHelper.readLong(in)));
        mapSnapshot.put("PacketsResentEarly", Base.makeLong(ExternalizableHelper.readLong(in)));
        mapSnapshot.put("PacketsResentExcess", Base.makeLong(ExternalizableHelper.readLong(in)));
        mapSnapshot.put("PacketsSent", Base.makeLong(ExternalizableHelper.readLong(in)));
        mapSnapshot.put("Priority", Base.makeInteger(ExternalizableHelper.readInt(in)));
        mapSnapshot.put("ProcessName", ExternalizableHelper.readSafeUTF(in));
        mapSnapshot.put("ProductEdition", ExternalizableHelper.readSafeUTF(in));
        mapSnapshot.put("PublisherPacketUtilization", new Float(in.readFloat()));
        mapSnapshot.put("PublisherSuccessRate", new Float(in.readFloat()));
        mapSnapshot.put("QuorumStatus", ExternalizableHelper.readSafeUTF(in));
        mapSnapshot.put("RackName", ExternalizableHelper.readSafeUTF(in));
        mapSnapshot.put("ReceiverPacketUtilization", new Float(in.readFloat()));
        mapSnapshot.put("ReceiverSuccessRate", new Float(in.readFloat()));
        mapSnapshot.put("ResendDelay", Base.makeInteger(ExternalizableHelper.readInt(in)));
        mapSnapshot.put("RoleName", ExternalizableHelper.readSafeUTF(in));
        mapSnapshot.put("SendAckDelay", Base.makeInteger(ExternalizableHelper.readInt(in)));
        mapSnapshot.put("SendQueueSize", Base.makeInteger(ExternalizableHelper.readInt(in)));
        mapSnapshot.put("SiteName", ExternalizableHelper.readSafeUTF(in));
        mapSnapshot.put("SocketCount", Base.makeInteger(ExternalizableHelper.readInt(in)));
        mapSnapshot.put("Statistics", ExternalizableHelper.readSafeUTF(in));
        mapSnapshot.put("TcpRingFailures", Base.makeLong(ExternalizableHelper.readLong(in)));
        mapSnapshot.put("Timestamp", new Date(ExternalizableHelper.readLong(in)));
        mapSnapshot.put("TrafficJamCount", Base.makeInteger(ExternalizableHelper.readInt(in)));
        mapSnapshot.put("TrafficJamDelay", Base.makeInteger(ExternalizableHelper.readInt(in)));
        mapSnapshot.put("UnicastAddress", ExternalizableHelper.readSafeUTF(in));
        mapSnapshot.put("UnicastPort", Base.makeInteger(ExternalizableHelper.readInt(in)));
        mapSnapshot.put("WellKnownAddresses", ExternalizableHelper.readStringArray(in));
        mapSnapshot.put("WeakestChannel", Base.makeInteger(ExternalizableHelper.readInt(in)));
    }

    public void resetStatistics() {
        SafeCluster clusterSafe = (SafeCluster)this.get_Cluster();
        if (clusterSafe.isRunning()) {
            Cluster cluster = (Cluster)clusterSafe.getCluster();
            cluster.resetStats();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBufferPublishSize(int cPackets) {
        this.checkReadOnly("setBufferPublishSize");
        PacketPublisher publisher = this.get_Publisher();
        if (!(publisher != null) ? false : cPackets != this.getBufferPublishSize()) {
            this.checkRange("BufferPublishSize", cPackets, 1, Integer.MAX_VALUE);
            try {
                UnicastUdpSocket socket = publisher.getUdpSocketUnicast();
                Object object = socket.getLock();
                synchronized (object) {
                    socket.close();
                    socket.setBufferSent(cPackets);
                    socket.open();
                }
            }
            catch (Exception e) {
                Component._trace("Buffer resizing failed; stopping cluster service", 1);
                this.get_Cluster().stop();
                throw Base.ensureRuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBufferReceiveSize(int cPackets) {
        this.checkReadOnly("setBufferReceiveSize");
        PacketPublisher publisher = this.get_Publisher();
        if (!(publisher != null) ? false : cPackets != this.getBufferReceiveSize()) {
            this.checkRange("BufferReceiveSize", cPackets, 1, Integer.MAX_VALUE);
            try {
                UnicastUdpSocket socket = publisher.getUdpSocketUnicast();
                Object object = socket.getLock();
                synchronized (object) {
                    socket.close();
                    socket.setBufferReceived(cPackets);
                    socket.open();
                }
            }
            catch (Exception e) {
                Component._trace("Buffer resizing failed; stopping cluster service", 1);
                this.get_Cluster().stop();
                throw Base.ensureRuntimeException(e);
            }
        }
    }

    public void setLoggingFormat(String sFormat) {
        Coherence singleton = (Coherence)Coherence.get_Instance();
        Coherence$Logger logger = singleton.getLogger();
        if (!(logger != null) ? false : Base.equals(sFormat, this.getLoggingFormat()) ^ true) {
            this.checkReadOnly("setLoggerFormat");
            logger.setFormat(sFormat);
        }
    }

    public void setLoggingLevel(int nLevel) {
        Coherence singleton = (Coherence)Coherence.get_Instance();
        Coherence$Logger logger = singleton.getLogger();
        if (!(logger != null) ? false : nLevel != this.getLoggingLevel()) {
            this.checkRange("setLoggerLevel", nLevel, -1, Integer.MAX_VALUE);
            logger.setLevel(nLevel);
        }
    }

    public void setLoggingLimit(int cChars) {
        Coherence singleton = (Coherence)Coherence.get_Instance();
        Coherence$Logger logger = singleton.getLogger();
        if (!(logger != null) ? false : cChars != this.getLoggingLimit()) {
            this.checkRange("setLoggerLimit", cChars, 0, Integer.MAX_VALUE);
            logger.setLimit(cChars);
        }
    }

    public void setMulticastThreshold(int nThreshold) {
        this.checkReadOnly("setMulticastThreshold");
        PacketPublisher publisher = this.get_Publisher();
        if (!(publisher != null) ? false : nThreshold != this.getMulticastThreshold()) {
            this.checkRange("setMulticastThreshold", nThreshold, 0, 100);
            publisher.setMulticastThreshold(0.01 * (double)nThreshold);
        }
    }

    public void setResendDelay(int cMillis) {
        this.checkReadOnly("setResendDelay");
        PacketPublisher publisher = this.get_Publisher();
        if (!(publisher != null) ? false : cMillis != this.getResendDelay()) {
            this.checkRange("setResendDelay", cMillis, 10, 1000);
            publisher.setResendDelay(cMillis);
        }
    }

    public void setSendAckDelay(int cMillis) {
        this.checkReadOnly("setSendAckDelay");
        PacketPublisher publisher = this.get_Publisher();
        if (!(publisher != null) ? false : cMillis != this.getSendAckDelay()) {
            this.checkRange("setSendAckDelay", cMillis, 1, 100);
            publisher.setAckDelay(cMillis);
        }
    }

    public void setTrafficJamCount(int cPackets) {
        this.checkReadOnly("setTrafficJamCount");
        PacketPublisher publisher = this.get_Publisher();
        if (!(publisher != null) ? false : cPackets != this.getTrafficJamCount()) {
            this.checkReadOnly("setTrafficJamCount");
            publisher.setCloggedCount(cPackets);
        }
    }

    public void setTrafficJamDelay(int cMillis) {
        this.checkReadOnly("setTrafficJamDelay");
        PacketPublisher publisher = this.get_Publisher();
        if (!(publisher != null) ? false : cMillis != this.getTrafficJamDelay()) {
            this.checkReadOnly("setTrafficJamDelay");
            publisher.setCloggedDelay(cMillis);
        }
    }

    public void set_Cluster(com.tangosol.net.Cluster member) {
        this.__m__Cluster = member;
    }

    public void set_Member(com.tangosol.net.Member member) {
        this.__m__Member = member;
    }

    public void shutdown() {
        this.checkReadOnly("shutdown");
        this.get_Cluster().shutdown();
    }

    public void writeExternal(DataOutput out) throws IOException {
        super.writeExternal(out);
        ExternalizableHelper.writeInt(out, this.getBufferPublishSize());
        ExternalizableHelper.writeInt(out, this.getBufferReceiveSize());
        ExternalizableHelper.writeInt(out, this.getCpuCount());
        out.writeBoolean(this.isFlowControlEnabled());
        ExternalizableHelper.writeInt(out, this.getId());
        ExternalizableHelper.writeSafeUTF(out, this.getLoggingDestination());
        ExternalizableHelper.writeSafeUTF(out, this.getLoggingFormat());
        ExternalizableHelper.writeInt(out, this.getLoggingLevel());
        ExternalizableHelper.writeInt(out, this.getLoggingLimit());
        ExternalizableHelper.writeInt(out, this.getMachineId());
        ExternalizableHelper.writeSafeUTF(out, this.getMachineName());
        ExternalizableHelper.writeSafeUTF(out, this.getMemberName());
        ExternalizableHelper.writeInt(out, this.getMemoryAvailableMB());
        ExternalizableHelper.writeInt(out, this.getMemoryMaxMB());
        ExternalizableHelper.writeSafeUTF(out, this.getMulticastAddress());
        out.writeBoolean(this.isMulticastEnabled());
        ExternalizableHelper.writeInt(out, this.getMulticastPort());
        ExternalizableHelper.writeInt(out, this.getMulticastThreshold());
        ExternalizableHelper.writeInt(out, this.getMulticastTTL());
        out.writeBoolean(this.isNackEnabled());
        ExternalizableHelper.writeLong(out, this.getNackSent());
        out.writeFloat(this.getPacketDeliveryEfficiency());
        ExternalizableHelper.writeLong(out, this.getPacketsBundled());
        ExternalizableHelper.writeLong(out, this.getPacketsReceived());
        ExternalizableHelper.writeLong(out, this.getPacketsRepeated());
        ExternalizableHelper.writeLong(out, this.getPacketsResent());
        ExternalizableHelper.writeLong(out, this.getPacketsResentEarly());
        ExternalizableHelper.writeLong(out, this.getPacketsResentExcess());
        ExternalizableHelper.writeLong(out, this.getPacketsSent());
        ExternalizableHelper.writeInt(out, this.getPriority());
        ExternalizableHelper.writeSafeUTF(out, this.getProcessName());
        ExternalizableHelper.writeSafeUTF(out, this.getProductEdition());
        out.writeFloat(this.getPublisherPacketUtilization());
        out.writeFloat(this.getPublisherSuccessRate());
        ExternalizableHelper.writeSafeUTF(out, this.getQuorumStatus());
        ExternalizableHelper.writeSafeUTF(out, this.getRackName());
        out.writeFloat(this.getReceiverPacketUtilization());
        out.writeFloat(this.getReceiverSuccessRate());
        ExternalizableHelper.writeInt(out, this.getResendDelay());
        ExternalizableHelper.writeSafeUTF(out, this.getRoleName());
        ExternalizableHelper.writeInt(out, this.getSendAckDelay());
        ExternalizableHelper.writeInt(out, this.getSendQueueSize());
        ExternalizableHelper.writeSafeUTF(out, this.getSiteName());
        ExternalizableHelper.writeInt(out, this.getSocketCount());
        ExternalizableHelper.writeSafeUTF(out, this.getStatistics());
        ExternalizableHelper.writeLong(out, this.getTcpRingFailures());
        ExternalizableHelper.writeLong(out, this.getTimestamp().getTime());
        ExternalizableHelper.writeInt(out, this.getTrafficJamCount());
        ExternalizableHelper.writeInt(out, this.getTrafficJamDelay());
        ExternalizableHelper.writeSafeUTF(out, this.getUnicastAddress());
        ExternalizableHelper.writeInt(out, this.getUnicastPort());
        ExternalizableHelper.writeStringArray(out, this.getWellKnownAddresses());
        ExternalizableHelper.writeInt(out, this.getWeakestChannel());
    }
}

