/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.util.Daemon;
import com.tangosol.coherence.component.util.DaemonPool;
import com.tangosol.coherence.component.util.DaemonPool$Daemon$Guard;
import com.tangosol.coherence.component.util.DaemonPool$Queue;
import com.tangosol.coherence.component.util.DaemonPool$StopTask;
import com.tangosol.coherence.component.util.DaemonPool$WrapperTask;
import com.tangosol.net.GuardSupport;
import com.tangosol.net.PriorityTask;
import com.tangosol.run.component.EventDeathException;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.WrapperException;
import java.util.List;

public class DaemonPool$Daemon
extends Daemon {
    private volatile transient int __m_InterruptCount;
    private DaemonPool$Queue __m_Queue;
    private volatile transient DaemonPool$WrapperTask __m_WrapperTask;

    public DaemonPool$Daemon() {
        this(null, null, true);
    }

    public DaemonPool$Daemon(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setDaemonState(0);
            this.setDefaultGuardRecovery(0.9f);
            this.setDefaultGuardTimeout(60000L);
            this.setThreadName("Worker");
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this._addChild(new DaemonPool$Daemon$Guard("Guard", this, true), "Guard");
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void abandon() {
        Runnable task;
        boolean fAbandon = false;
        Thread thread = null;
        DaemonPool$Daemon daemonPool$Daemon = this;
        synchronized (daemonPool$Daemon) {
            thread = this.getThread();
            if (thread == null) return;
            boolean bl = false;
            if (bl) {
                return;
            }
            if (!this.isStarted() ? false : this.isExiting() ^ true) {
                fAbandon = true;
                this.setExiting(true);
            }
        }
        if (!fAbandon) return;
        DaemonPool pool = (DaemonPool)this.get_Module();
        DaemonPool$WrapperTask wrapper = this.getWrapperTask();
        String sThread = this.getThreadName();
        String sReason = wrapper == null ? ", while waiting" : String.valueOf(" executing task \"") + wrapper.getTaskId() + "\"";
        if (wrapper != null && (task = wrapper.getTask()) instanceof PriorityTask) {
            pool.runCanceled((PriorityTask)((Object)task), true);
        }
        StringBuffer sbMsg = new StringBuffer();
        sbMsg.append("A worker thread \"").append(sThread).append(sReason).append(", did not respond to ").append(Math.abs(pool.getAbandonThreshold())).append(" interrupt requests. The execution was canceled.").append(" The thread ");
        int cAttempts = pool.getAbandonThreshold();
        if (cAttempts < 0) {
            int i = cAttempts;
            while (!(i < 0) ? false : thread.isAlive()) {
                try {
                    ClassHelper.invoke(thread, "stop", ClassHelper.VOID);
                    Thread.sleep(1);
                }
                catch (InterruptedException e) {
                    Thread.currentThread();
                    Thread.interrupted();
                    break;
                }
                catch (Exception e) {
                    break;
                }
                ++i;
            }
            if (thread.isAlive()) {
                sbMsg.append("could not be stopped and ");
            }
        }
        if (thread.isAlive()) {
            sThread = String.valueOf(sThread) + "!abandoned";
            try {
                thread.setName(sThread);
                thread.setPriority(Thread.MIN_PRIORITY);
            }
            catch (RuntimeException e) {
                // empty catch block
            }
            sbMsg.append("is abandoned...");
            try {
                StackTraceElement[] atrace = (StackTraceElement[])ClassHelper.invoke(thread, "getStackTrace", ClassHelper.VOID);
                int i = 0;
                int c = atrace.length;
                while (true) {
                    if (!(i < c)) {
                        sbMsg.append('\n');
                    }
                    sbMsg.append("\n  at ").append(atrace[i]);
                    ++i;
                }
            }
            catch (Throwable e) {}
        } else {
            sbMsg.append("is stopped.");
        }
        Component._trace(sbMsg.toString(), 1);
    }

    public int getInterruptCount() {
        return this.__m_InterruptCount;
    }

    public Object getLock() {
        return this.getQueue();
    }

    public DaemonPool$Queue getQueue() {
        return this.__m_Queue;
    }

    public long getWaitMillis() {
        long cWait = super.getWaitMillis();
        if (this.isGuarded() ? true : this.isGuardian()) {
            long cMaxWait = 1000L;
            cWait = cWait == (long)0 ? cMaxWait : Math.min(cWait, cMaxWait);
        }
        return cWait;
    }

    public DaemonPool$WrapperTask getWrapperTask() {
        return this.__m_WrapperTask;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/DaemonPool$Daemon".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new DaemonPool$Daemon();
    }

    private final Component get_Module() {
        return this.get_Parent();
    }

    public void halt() {
        super.halt();
    }

    public void heartbeat(long cMillis) {
        super.heartbeat(cMillis);
    }

    public boolean isNotification() {
        return this.getQueue().isAvailable() ? true : super.isNotification();
    }

    protected void onEnter() {
        super.onEnter();
        if (this.isGuarded()) {
            GuardSupport.setThreadContext(this.getGuardable().getContext());
        }
    }

    protected void onException(Throwable e) {
        if (this.isExiting()) {
            super.onException(e);
        } else {
            Component._trace(String.valueOf("An unhandled exception occurred on worker thread \"") + this.get_Name() + "\":", 1);
            Component._trace(e);
        }
    }

    protected void onExit() {
        List listDaemons = ((DaemonPool)this.get_Module()).getDaemons();
        if (listDaemons != null) {
            listDaemons.remove(this);
        }
        super.onExit();
    }

    public void onInit() {
        this.setQueue(((DaemonPool)this.get_Module()).getQueue());
        super.onInit();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void onNotify() {
        DaemonPool$WrapperTask wrapper;
        DaemonPool$Queue queue;
        block14: {
            boolean bl;
            block13: {
                DaemonPool pool = (DaemonPool)this.get_Parent();
                queue = this.getQueue();
                long ldtLastHeartbeat = 0L;
                long ldtStart = 0L;
                int cTasks = 0;
                wrapper = this.getWrapperTask();
                boolean fOnce = wrapper != null;
                try {
                    while (this.isExiting() ^ true) {
                        Object var17_14;
                        long ldtNow;
                        if (fOnce ^ true) {
                            if ((wrapper = (DaemonPool$WrapperTask)queue.removeNoWait(wrapper)) == null) {
                                if (cTasks > 0) {
                                    pool.updateStats(cTasks, ldtStart);
                                }
                                Object var11_15 = null;
                                bl = wrapper != null;
                                break block13;
                            }
                            if (((long)cTasks & 0x3FFL) == 0L) {
                                ldtStart = pool.updateStats(cTasks, ldtStart);
                                cTasks = 0;
                            }
                        }
                        long ldtStop = wrapper.getStopTime();
                        long cTimeoutMillis = wrapper.getTimeoutMillis();
                        if (ldtStop > 0L) {
                            cTimeoutMillis = Math.min(cTimeoutMillis, Math.max(1L, ldtStop - Base.getSafeTimeMillis()));
                        }
                        if ((ldtNow = Base.getLastSafeTimeMillis()) - ldtLastHeartbeat > 1000L) {
                            this.heartbeat(cTimeoutMillis);
                            ldtLastHeartbeat = ldtNow;
                        }
                        ++cTasks;
                        this.setWrapperTask(wrapper);
                        try {
                            try {
                                wrapper.run();
                            }
                            catch (EventDeathException e) {
                                if (!(wrapper.getTask() instanceof DaemonPool$StopTask)) throw e;
                                fOnce = true;
                            }
                            var17_14 = null;
                            this.setWrapperTask(null);
                            if (!fOnce) continue;
                            this.setExiting(true);
                        }
                        catch (Throwable throwable) {
                            var17_14 = null;
                            this.setWrapperTask(null);
                            if (!fOnce) throw throwable;
                            this.setExiting(true);
                            throw throwable;
                        }
                    }
                    break block14;
                }
                catch (Throwable throwable) {
                    Object var11_17 = null;
                    if (!(wrapper != null)) throw throwable;
                    queue.release(wrapper);
                    throw throwable;
                }
            }
            if (!bl) return;
            queue.release(wrapper);
            return;
        }
        Object var11_16 = null;
        if (!(wrapper != null)) return;
        queue.release(wrapper);
    }

    protected void onWait() throws InterruptedException {
        if (this.getWrapperTask() == null) {
            if (this.isGuarded()) {
                this.heartbeat();
            }
            super.onWait();
        }
    }

    public void setGuardSupport(GuardSupport guardSupport) {
        super.setGuardSupport(guardSupport);
    }

    public void setInterruptCount(int cInterrupts) {
        this.__m_InterruptCount = cInterrupts;
    }

    public void setLock(Object oLock) {
        throw new UnsupportedOperationException();
    }

    private void setQueue(DaemonPool$Queue queue) {
        this.__m_Queue = queue;
    }

    public void setWrapperTask(DaemonPool$WrapperTask task) {
        Thread thread = this.getThread();
        Component._assert(thread == null ? true : thread == Thread.currentThread());
        this.__m_WrapperTask = task;
        if (this.getInterruptCount() > 0) {
            Thread.interrupted();
            this.setInterruptCount(0);
            this.heartbeat();
        }
    }
}

