/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.message.requestMessage.LeaseRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ReplicatedCache;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.WrapperException;
import java.io.IOException;

public class ReplicatedCache$LeaseLockRequest
extends LeaseRequest {
    private long __m_LeaseMillis;
    private long __m_WaitMillis;
    private transient long __m_WaitTimeout;

    public ReplicatedCache$LeaseLockRequest() {
        this(null, null, true);
    }

    public ReplicatedCache$LeaseLockRequest(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setBufferUsageCounter(1);
            this.setMessageType(36);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public String getDescription() {
        return String.valueOf(super.getDescription()) + "\nWaitTimeout=" + this.getWaitTimeout() + ", LeaseDuration=" + this.getLeaseMillis();
    }

    public long getLeaseMillis() {
        return this.__m_LeaseMillis;
    }

    public long getWaitMillis() {
        return this.__m_WaitMillis;
    }

    public long getWaitTimeout() {
        long ldtTimeout = this.__m_WaitTimeout;
        if (ldtTimeout == 0L) {
            ReplicatedCache service = (ReplicatedCache)this.getService();
            ldtTimeout = service.adjustWaitTime(this.getWaitMillis(), Grid.TIME_CLUSTER);
            this.setWaitTimeout(ldtTimeout);
        }
        return ldtTimeout;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/grid/ReplicatedCache$LeaseLockRequest".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new ReplicatedCache$LeaseLockRequest();
    }

    private final Component get_Module() {
        return ((Component)this).get_Parent();
    }

    public void onReceived() {
        super.onReceived();
        ReplicatedCache service = (ReplicatedCache)this.getService();
        service.onLeaseLockRequest(this);
    }

    public void read(ReadBuffer.BufferInput input) throws IOException {
        super.read(input);
        this.setWaitMillis(ExternalizableHelper.readLong(input));
        this.setLeaseMillis(ExternalizableHelper.readLong(input));
    }

    public void setLeaseMillis(long pLeaseMillis) {
        this.__m_LeaseMillis = pLeaseMillis;
    }

    public void setWaitMillis(long cMillis) {
        this.__m_WaitMillis = cMillis;
        this.setWaitTimeout(0L);
    }

    protected void setWaitTimeout(long ldtTimeout) {
        this.__m_WaitTimeout = ldtTimeout;
    }

    public void write(WriteBuffer.BufferOutput output) throws IOException {
        super.write(output);
        ExternalizableHelper.writeLong(output, this.getWaitMillis());
        ExternalizableHelper.writeLong(output, this.getLeaseMillis());
    }
}

