/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.acceptor;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.extend.Connection;
import com.tangosol.coherence.component.net.extend.util.TcpUtil;
import com.tangosol.coherence.component.util.Daemon$Guard;
import com.tangosol.coherence.component.util.Queue;
import com.tangosol.coherence.component.util.daemon.QueueProcessor$Queue;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$EventDispatcher;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Peer;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Peer$DaemonPool;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Peer$DispatchEvent;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Peer$Protocol;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.Acceptor;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.acceptor.TcpAcceptor$BufferPool;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.acceptor.TcpAcceptor$MessageBuffer;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.acceptor.TcpAcceptor$MessageFactory;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.acceptor.TcpAcceptor$TcpConnection;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.acceptor.TcpAcceptor$TcpProcessor;
import com.tangosol.coherence.component.util.queue.concurrentQueue.DualQueue;
import com.tangosol.io.MultiBufferWriteBuffer;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.net.AddressProvider;
import com.tangosol.net.ConfigurableAddressProvider;
import com.tangosol.net.ConfigurableLocalAddressProvider;
import com.tangosol.net.InetAddressHelper;
import com.tangosol.net.OperationalContext;
import com.tangosol.net.SocketOptions;
import com.tangosol.net.SocketProvider;
import com.tangosol.net.SocketProviderFactory;
import com.tangosol.net.messaging.Message;
import com.tangosol.run.xml.SimpleElement;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.util.Base;
import com.tangosol.util.Filter;
import com.tangosol.util.ListMap;
import com.tangosol.util.SafeHashSet;
import com.tangosol.util.SafeLinkedList;
import com.tangosol.util.WrapperException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class TcpAcceptor
extends Acceptor {
    private Filter __m_AuthorizedHostFilter;
    private List __m_AuthorizedHostList;
    private transient TcpAcceptor$BufferPool __m_BufferPoolIn;
    private transient TcpAcceptor$BufferPool __m_BufferPoolOut;
    private Queue __m_ConnectionFlushQueue;
    private Queue __m_ConnectionReleaseQueue;
    private long __m_DefaultLimitBytes;
    private int __m_DefaultLimitLength;
    private long __m_DefaultNominalBytes;
    private int __m_DefaultNominalLength;
    private long __m_DefaultSuspectBytes;
    private int __m_DefaultSuspectLength;
    private transient long __m_LastThrottleWarningTimestamp;
    private int __m_ListenBacklog;
    private InetSocketAddress __m_LocalAddress;
    private AddressProvider __m_LocalAddressProvider;
    private transient TcpAcceptor$TcpProcessor __m_Processor;
    private transient SocketOptions __m_SocketOptions;
    private SocketProvider __m_SocketProvider;
    private SocketProviderFactory __m_SocketProviderFactory;
    private boolean __m_SuspectProtocolEnabled;
    private static ListMap __mapChildren;
    private static /* synthetic */ Class __sf0;

    static {
        TcpAcceptor.__initStatic();
    }

    public TcpAcceptor() {
        this(null, null, true);
    }

    public TcpAcceptor(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setAuthorizedHostList(new SafeLinkedList());
            this.setConnectionPendingSet(new SafeHashSet());
            this.setConnectionSet(new SafeHashSet());
            this.setDaemonState(0);
            this.setDefaultGuardRecovery(0.9f);
            this.setDefaultGuardTimeout(60000L);
            this.setDefaultLimitBytes(100000000L);
            this.setDefaultLimitLength(60000);
            this.setDefaultNominalBytes(2000000L);
            this.setDefaultNominalLength(2000);
            this.setDefaultSuspectBytes(10000000L);
            this.setDefaultSuspectLength(10000);
            this.setProtocolMap(new HashMap());
            this.setReceiverMap(new HashMap());
            this.setRequestTimeout(30000L);
            this.setSerializerMap(new WeakHashMap());
            this.setSocketOptions(new SocketOptions());
            this.setSuspectProtocolEnabled(true);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this._addChild(new Peer$DaemonPool("DaemonPool", this, true), "DaemonPool");
        this._addChild(new Service$EventDispatcher("EventDispatcher", this, true), "EventDispatcher");
        this._addChild(new Daemon$Guard("Guard", this, true), "Guard");
        this._addChild(new Peer$Protocol("Protocol", this, true), "Protocol");
        this._addChild(new TcpAcceptor$TcpProcessor("TcpProcessor", this, true), "TcpProcessor");
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("BufferPool", TcpAcceptor$BufferPool.get_CLASS());
        Class clazz2 = __mapChildren.put("DispatchEvent", Peer$DispatchEvent.get_CLASS());
        Class clazz3 = __mapChildren.put("MessageBuffer", TcpAcceptor$MessageBuffer.get_CLASS());
        Class clazz4 = __mapChildren.put("MessageFactory", TcpAcceptor$MessageFactory.get_CLASS());
        Class clazz5 = __mapChildren.put("Queue", QueueProcessor$Queue.get_CLASS());
        Class clazz6 = __mapChildren.put("TcpConnection", TcpAcceptor$TcpConnection.get_CLASS());
    }

    private static /* synthetic */ Class __sm0() {
        Class<?> clazz = __sf0;
        if (clazz == null) {
            try {
                clazz = __sf0 = Class.forName("com.tangosol.util.Filter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    protected void addAuthorizedHostString(String sAddrFrom, String sAddrTo) {
        InetAddress addrTo;
        InetAddress addrFrom;
        if (sAddrFrom == null ? true : sAddrFrom.length() == 0) {
            Component._assert(sAddrTo == null ? true : sAddrTo.length() == 0, "Both <from-ip> and <to-ip> elements must be specifeid");
            return;
        }
        try {
            addrFrom = InetAddress.getByName(sAddrFrom);
            addrTo = sAddrTo == null ? addrFrom : InetAddress.getByName(sAddrTo);
        }
        catch (UnknownHostException e) {
            throw new WrapperException(e);
        }
        long lFrom = InetAddressHelper.toLong(addrFrom);
        long lTo = InetAddressHelper.toLong(addrTo);
        if (lFrom > lTo) {
            throw new IllegalArgumentException(String.valueOf("Invalid IP range: [") + sAddrFrom + ", " + sAddrTo + ']');
        }
        this.getAuthorizedHostList().add(new long[]{lFrom, lTo});
    }

    protected WriteBuffer allocateWriteBuffer() {
        return new MultiBufferWriteBuffer(this.getBufferPoolOut());
    }

    public synchronized void configure(XmlElement xml) {
        super.configure(xml);
        if (xml == null) {
            return;
        }
        XmlElement xmlCat = xml.getSafeElement("tcp-acceptor");
        try {
            this.setSocketProvider(this.getSocketProviderFactory().ensureProvider(xmlCat.getSafeElement("socket-provider")));
        }
        catch (IOException e) {
            throw Base.ensureRuntimeException(e, "error configuring socket provider");
        }
        XmlElement xmlLocal = xmlCat.getSafeElement("local-address");
        XmlElement xmlProvider = xmlCat.getSafeElement("address-provider");
        boolean fLocal = XmlHelper.isEmpty(xmlLocal) ^ true;
        boolean fProvider = XmlHelper.isEmpty(xmlProvider) ^ true;
        if (!fLocal ? false : fProvider) {
            throw new IllegalArgumentException(String.valueOf("The \"address-provider\" and ") + "\"local-address\" elements are mutually exclusive");
        }
        if (fLocal) {
            xmlProvider = new SimpleElement("address-provider");
            XmlElement xmlAddr = xmlProvider.addElement("socket-address");
            String sAddr = xmlLocal.getSafeElement("address").getString();
            if (sAddr.length() == 0) {
                sAddr = "localhost";
            }
            xmlAddr.ensureElement("address").setString(sAddr);
            int nPort = xmlLocal.getSafeElement("port").getInt();
            if (nPort <= 0 ? true : nPort > 65535) {
                throw new IllegalArgumentException(String.valueOf("invalid port in local-address:\n") + xmlLocal);
            }
            xmlAddr.ensureElement("port").setInt(nPort);
            this.setLocalAddressProvider(new ConfigurableLocalAddressProvider(xmlProvider));
        } else {
            this.setLocalAddressProvider(ConfigurableAddressProvider.createAddressProvider(xmlCat, this.getContextClassLoader()));
        }
        this.setListenBacklog(xmlCat.getSafeElement("listen-backlog").getInt(this.getListenBacklog()));
        this.getSocketOptions().setConfig(xmlCat);
        XmlElement xmlVal = xmlCat.getSafeElement("incoming-buffer-pool");
        TcpAcceptor$BufferPool pool = this.getBufferPoolIn();
        pool.setBufferSize((int)Peer.parseMemorySize(xmlVal, "buffer-size", pool.getBufferSize()));
        pool.setBufferType(TcpAcceptor$BufferPool.getType(xmlVal.getSafeElement("buffer-type").getString()));
        pool.setCapacity(xmlVal.getSafeElement("capacity").getInt(pool.getCapacity()));
        xmlVal = xmlCat.getSafeElement("outgoing-buffer-pool");
        pool = this.getBufferPoolOut();
        pool.setBufferSize((int)Peer.parseMemorySize(xmlVal, "buffer-size", pool.getBufferSize()));
        pool.setBufferType(TcpAcceptor$BufferPool.getType(xmlVal.getSafeElement("buffer-type").getString()));
        pool.setCapacity(xmlVal.getSafeElement("capacity").getInt(pool.getCapacity()));
        XmlElement xmlSub = xmlCat.getSafeElement("authorized-hosts");
        Iterator iter = xmlSub.getElements("host-address");
        while (iter.hasNext()) {
            xmlVal = (XmlElement)iter.next();
            this.addAuthorizedHostString(xmlVal.getString(), null);
        }
        iter = xmlSub.getElements("host-range");
        while (iter.hasNext()) {
            xmlVal = (XmlElement)iter.next();
            this.addAuthorizedHostString(xmlVal.getSafeElement("from-address").getString(), xmlVal.getSafeElement("to-address").getString());
        }
        xmlVal = xmlSub.getElement("host-filter");
        if (!(xmlVal != null) ? false : XmlHelper.isEmpty(xmlVal) ^ true) {
            this.setAuthorizedHostFilter((Filter)XmlHelper.createInstance(xmlVal, null, null, TcpAcceptor.__sm0()));
        }
        this.setSuspectProtocolEnabled(xmlCat.getSafeElement("suspect-protocol-enabled").getBoolean(this.isSuspectProtocolEnabled()));
        this.setDefaultSuspectBytes(Peer.parseMemorySize(xmlCat, "suspect-buffer-size", this.getDefaultSuspectBytes()));
        this.setDefaultSuspectLength(xmlCat.getSafeElement("suspect-buffer-length").getInt(this.getDefaultSuspectLength()));
        this.setDefaultNominalBytes(Peer.parseMemorySize(xmlCat, "nominal-buffer-size", this.getDefaultNominalBytes()));
        this.setDefaultNominalLength(xmlCat.getSafeElement("nominal-buffer-length").getInt(this.getDefaultNominalLength()));
        this.setDefaultLimitBytes(Peer.parseMemorySize(xmlCat, "limit-buffer-size", this.getDefaultLimitBytes()));
        this.setDefaultLimitLength(xmlCat.getSafeElement("limit-buffer-length").getInt(this.getDefaultLimitLength()));
    }

    public void configureSocket(ServerSocket socket) {
        InetSocketAddress address;
        try {
            this.getSocketOptions().apply(socket);
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e, "error configuring ServerSocket");
        }
        AddressProvider provider = this.getLocalAddressProvider();
        while ((address = provider.getNextAddress()) != null) {
            try {
                TcpAcceptor.validateLocalSocketAddress(address);
                socket.bind(address, this.getListenBacklog());
                this.setLocalAddress(address);
                provider.accept();
                break;
            }
            catch (Exception e) {
                Component._trace(e, String.valueOf("error binding ServerSocket to ") + TcpUtil.toString(address));
                provider.reject(e);
            }
        }
        if (address == null ? true : socket.isBound() ^ true) {
            throw new RuntimeException(String.valueOf("Error binding ServerSocket to any of the supplied ports: ") + provider);
        }
    }

    public void configureSocket(Socket socket) {
        try {
            this.getSocketOptions().apply(socket);
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e, "error configuring Socket");
        }
    }

    protected void encodeMessage(Message message, WriteBuffer.BufferOutput out, boolean fFilter) throws IOException {
        int i = 0;
        while (i < 5) {
            out.write(0);
            ++i;
        }
        super.encodeMessage(message, out, fFilter);
    }

    public Filter getAuthorizedHostFilter() {
        return this.__m_AuthorizedHostFilter;
    }

    public List getAuthorizedHostList() {
        return this.__m_AuthorizedHostList;
    }

    public TcpAcceptor$BufferPool getBufferPoolIn() {
        return this.__m_BufferPoolIn;
    }

    public TcpAcceptor$BufferPool getBufferPoolOut() {
        return this.__m_BufferPoolOut;
    }

    public Queue getConnectionFlushQueue() {
        return this.__m_ConnectionFlushQueue;
    }

    public Queue getConnectionReleaseQueue() {
        return this.__m_ConnectionReleaseQueue;
    }

    public long getDefaultLimitBytes() {
        return this.__m_DefaultLimitBytes;
    }

    public int getDefaultLimitLength() {
        return this.__m_DefaultLimitLength;
    }

    public long getDefaultNominalBytes() {
        return this.__m_DefaultNominalBytes;
    }

    public int getDefaultNominalLength() {
        return this.__m_DefaultNominalLength;
    }

    public long getDefaultSuspectBytes() {
        return this.__m_DefaultSuspectBytes;
    }

    public int getDefaultSuspectLength() {
        return this.__m_DefaultSuspectLength;
    }

    public String getDescription() {
        StringBuffer sb = new StringBuffer(super.getDescription());
        sb.append(", SocketProvider=").append(this.getSocketProvider());
        sb.append(", LocalAddress=").append(this.getLocalAddressProvider());
        SocketOptions options = this.getSocketOptions();
        if (options != null) {
            sb.append(", ").append(options);
        }
        sb.append(", ListenBacklog=").append(this.getListenBacklog()).append(", BufferPoolIn=").append(this.getBufferPoolIn()).append(", BufferPoolOut=").append(this.getBufferPoolOut());
        return sb.toString();
    }

    public long getLastThrottleWarningTimestamp() {
        return this.__m_LastThrottleWarningTimestamp;
    }

    public int getListenBacklog() {
        return this.__m_ListenBacklog;
    }

    public InetSocketAddress getLocalAddress() {
        return this.__m_LocalAddress;
    }

    public AddressProvider getLocalAddressProvider() {
        return this.__m_LocalAddressProvider;
    }

    public TcpAcceptor$TcpProcessor getProcessor() {
        TcpAcceptor$TcpProcessor processor = this.__m_Processor;
        if (processor == null) {
            processor = (TcpAcceptor$TcpProcessor)this._findChild("TcpProcessor");
            this.setProcessor(processor);
        }
        return processor;
    }

    public SocketOptions getSocketOptions() {
        return this.__m_SocketOptions;
    }

    public SocketProvider getSocketProvider() {
        return this.__m_SocketProvider;
    }

    public SocketProviderFactory getSocketProviderFactory() {
        SocketProviderFactory factory = this.__m_SocketProviderFactory;
        if (factory == null) {
            OperationalContext ctx = this.getOperationalContext();
            factory = ctx == null ? new SocketProviderFactory() : ctx.getSocketProviderFactory();
            this.setSocketProviderFactory(factory);
        }
        return factory;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/peer/acceptor/TcpAcceptor".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new TcpAcceptor();
    }

    private final Component get_Module() {
        return this;
    }

    public Connection instantiateConnection() {
        TcpAcceptor$TcpConnection connection = (TcpAcceptor$TcpConnection)this._newChild("TcpConnection");
        connection.setConnectionManager(this);
        return connection;
    }

    public boolean isAcceptingConnections() {
        return !super.isAcceptingConnections() ? false : this.getBufferPoolOut().getOverflow() <= 0;
    }

    public boolean isAuthorizedHost(InetAddress addr) {
        Filter filterHost = this.getAuthorizedHostFilter();
        List listHost = this.getAuthorizedHostList();
        if (!(filterHost == null) ? false : listHost.isEmpty()) {
            return true;
        }
        if (filterHost != null) {
            try {
                if (filterHost.evaluate(addr)) {
                    return true;
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        long lAddr = InetAddressHelper.toLong(addr);
        Iterator iter = listHost.iterator();
        while (iter.hasNext()) {
            long[] alAddr = (long[])iter.next();
            if (!(!(alAddr[0] <= lAddr) ? false : lAddr <= alAddr[1])) continue;
            return true;
        }
        return false;
    }

    public boolean isSuspectProtocolEnabled() {
        return this.__m_SuspectProtocolEnabled;
    }

    public void onConnectionClosed(Connection connection) {
        super.onConnectionClosed(connection);
        if (this.get_Connection() == connection) {
            return;
        }
        this.getConnectionReleaseQueue().add(connection);
        this.getProcessor().wakeup();
    }

    public void onConnectionError(Connection connection, Throwable e) {
        super.onConnectionError(connection, e);
        if (this.get_Connection() == connection) {
            return;
        }
        this.getConnectionReleaseQueue().add(connection);
        this.getProcessor().wakeup();
    }

    public void onInit() {
        this.setBufferPoolIn((TcpAcceptor$BufferPool)this._newChild("BufferPool"));
        this.setBufferPoolOut((TcpAcceptor$BufferPool)this._newChild("BufferPool"));
        this.setConnectionFlushQueue(new DualQueue());
        this.setConnectionReleaseQueue(new DualQueue());
        this.getBufferPoolIn().setName("Incoming");
        this.getBufferPoolOut().setName("Outgoing");
        super.onInit();
        try {
            SocketOptions options = this.getSocketOptions();
            options.setOption(java.net.SocketOptions.SO_KEEPALIVE, Boolean.TRUE);
            options.setOption(java.net.SocketOptions.TCP_NODELAY, Boolean.TRUE);
            options.setOption(java.net.SocketOptions.SO_LINGER, 0);
        }
        catch (SocketException e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    protected void onServiceStarting() {
        super.onServiceStarting();
        TcpAcceptor$TcpProcessor processor = this.getProcessor();
        processor.start();
        InetSocketAddress addr = (InetSocketAddress)processor.getServerSocket().getLocalSocketAddress();
        Component._trace(String.valueOf("TcpAcceptor now listening for connections on ") + TcpUtil.toString(addr), 3);
    }

    protected void onServiceStopped() {
        TcpUtil.cancel(this.getProcessor().getServerSocketKey());
        super.onServiceStopped();
        this.getProcessor().stop();
    }

    protected void onServiceStopping() {
        TcpUtil.cancel(this.getProcessor().getServerSocketKey());
        super.onServiceStopping();
    }

    protected void releaseReadBuffer(ReadBuffer rb) {
        Component._assert(rb instanceof TcpAcceptor$MessageBuffer);
        ((TcpAcceptor$MessageBuffer)rb).release();
    }

    protected void releaseWriteBuffer(WriteBuffer wb, Throwable e) {
        Component._assert(wb instanceof MultiBufferWriteBuffer);
        if (!(e == null)) {
            TcpAcceptor$BufferPool pool = this.getBufferPoolOut();
            MultiBufferWriteBuffer mwb = (MultiBufferWriteBuffer)wb;
            int i = 0;
            int c = mwb.getBufferCount();
            while (i < c) {
                pool.release(mwb.getBuffer(i));
                ++i;
            }
        }
    }

    protected void setAuthorizedHostFilter(Filter filter) {
        this.__m_AuthorizedHostFilter = filter;
    }

    protected void setAuthorizedHostList(List list) {
        this.__m_AuthorizedHostList = list;
    }

    protected void setBufferPoolIn(TcpAcceptor$BufferPool pool) {
        this.__m_BufferPoolIn = pool;
    }

    protected void setBufferPoolOut(TcpAcceptor$BufferPool pool) {
        this.__m_BufferPoolOut = pool;
    }

    protected void setConnectionFlushQueue(Queue queue) {
        this.__m_ConnectionFlushQueue = queue;
    }

    protected void setConnectionReleaseQueue(Queue queue) {
        this.__m_ConnectionReleaseQueue = queue;
    }

    protected void setDefaultLimitBytes(long cb) {
        this.__m_DefaultLimitBytes = cb;
    }

    protected void setDefaultLimitLength(int cMsgs) {
        this.__m_DefaultLimitLength = cMsgs;
    }

    protected void setDefaultNominalBytes(long cb) {
        this.__m_DefaultNominalBytes = cb;
    }

    protected void setDefaultNominalLength(int cMsgs) {
        this.__m_DefaultNominalLength = cMsgs;
    }

    protected void setDefaultSuspectBytes(long cb) {
        this.__m_DefaultSuspectBytes = cb;
    }

    protected void setDefaultSuspectLength(int cMsgs) {
        this.__m_DefaultSuspectLength = cMsgs;
    }

    public void setLastThrottleWarningTimestamp(long ldt) {
        this.__m_LastThrottleWarningTimestamp = ldt;
    }

    protected void setListenBacklog(int cConn) {
        this.__m_ListenBacklog = cConn;
    }

    public void setLocalAddress(InetSocketAddress addr) {
        this.__m_LocalAddress = addr;
    }

    public void setLocalAddressProvider(AddressProvider pLocalAddressProvider) {
        this.__m_LocalAddressProvider = pLocalAddressProvider;
    }

    protected void setProcessor(TcpAcceptor$TcpProcessor processor) {
        this.__m_Processor = processor;
    }

    protected void setSocketOptions(SocketOptions options) {
        Component._assert(options != null);
        Component._assert(this.getSocketOptions() == null);
        this.__m_SocketOptions = options;
    }

    protected void setSocketProvider(SocketProvider provider) {
        this.__m_SocketProvider = provider;
    }

    public void setSocketProviderFactory(SocketProviderFactory factory) {
        this.__m_SocketProviderFactory = factory;
    }

    public void setSuspectProtocolEnabled(boolean pSuspectProtocolEnabled) {
        this.__m_SuspectProtocolEnabled = pSuspectProtocolEnabled;
    }

    protected static void validateLocalSocketAddress(InetSocketAddress socketAddr) {
        InetAddress addr = socketAddr.getAddress();
        if (InetAddressHelper.isLoopbackAddress(addr)) {
            Component._trace(String.valueOf("The specified local address \"") + addr + "\" is a loopback address" + "; clients running on remote machines will not be able to connect" + " to this TcpAcceptor", 3);
        } else {
            byte[] abAddr = addr.getAddress();
            if (abAddr.length == 16) {
                boolean fSuspect = true;
                List listLocal = InetAddressHelper.getAllLocalAddresses();
                Iterator iter = listLocal.iterator();
                while (iter.hasNext()) {
                    InetAddress addrLocal = (InetAddress)iter.next();
                    if (!InetAddressHelper.virtuallyEqual(addrLocal.getAddress(), abAddr)) continue;
                    fSuspect = false;
                    break;
                }
                if (fSuspect) {
                    Component._trace(String.valueOf("The local IPv6 address \"") + InetAddressHelper.toString(addr) + "\" does not correspond to any of the local interface addresses; " + "this address may not be reachable by IPv4-bound nodes", 2);
                }
            }
        }
    }
}

