/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.dsltools.termtrees;

import com.tangosol.coherence.dsltools.termtrees.TermWalker;

public abstract class Term {
    public abstract String getFunctor();

    public abstract Term termAt(int var1);

    public abstract Term[] children();

    public abstract Term withChild(Term var1);

    public abstract boolean termEqual(Term var1);

    public abstract String fullFormString();

    public boolean isLeaf() {
        return true;
    }

    public boolean isAtom() {
        return true;
    }

    public boolean isNumber() {
        return false;
    }

    public int length() {
        return this.children().length;
    }

    public Term findChild(String sFunctor) {
        for (Term t : this.children()) {
            if (!sFunctor.equals(t.getFunctor())) continue;
            return t;
        }
        return null;
    }

    public Term findAttribute(String sFunctor) {
        for (Term t : this.children()) {
            if (!sFunctor.equals(t.getFunctor()) || t.length() != 1) continue;
            return t.termAt(1);
        }
        return null;
    }

    public boolean childrenTermEqual(Term t) {
        Term[] aOtherTerms;
        if (t == null) {
            return false;
        }
        Term[] aMyTerms = this.children();
        int count = aMyTerms.length;
        if (count != (aOtherTerms = t.children()).length) {
            return false;
        }
        if (count == 0) {
            return true;
        }
        for (int i = 0; i < count; ++i) {
            if (aMyTerms[i].termEqual(aOtherTerms[i])) continue;
            return false;
        }
        return true;
    }

    public boolean headChildrenTermEqual(Term t) {
        Term[] aOtherTerms;
        if (t == null) {
            return false;
        }
        if (t.isAtom()) {
            return false;
        }
        Term[] aMyTerms = this.children();
        int count = aMyTerms.length;
        if (count > (aOtherTerms = t.children()).length) {
            return false;
        }
        if (count == 0) {
            return true;
        }
        for (int i = 0; i < count; ++i) {
            if (aMyTerms[i].termEqual(aOtherTerms[i])) continue;
            return false;
        }
        return true;
    }

    public void accept(TermWalker walker) {
        walker.acceptTerm(this.getFunctor(), this);
    }
}

