/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.mvel.ast;

import com.tangosol.coherence.mvel.CompileException;
import com.tangosol.coherence.mvel.MVEL;
import com.tangosol.coherence.mvel.ParserContext;
import com.tangosol.coherence.mvel.ast.ASTNode;
import com.tangosol.coherence.mvel.compiler.ExecutableStatement;
import com.tangosol.coherence.mvel.integration.VariableResolverFactory;
import com.tangosol.coherence.mvel.util.ParseTools;

public class Negation
extends ASTNode {
    private ExecutableStatement stmt;

    public Negation(char[] name, int fields, ParserContext pCtx) {
        this.name = name;
        if ((fields & 0x10) != 0 && (this.stmt = (ExecutableStatement)ParseTools.subCompileExpression(name, pCtx)).getKnownEgressType() != null && !ParseTools.boxPrimitive(this.stmt.getKnownEgressType()).isAssignableFrom(Boolean.class)) {
            throw new CompileException("negation operator cannot be applied to non-boolean type");
        }
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        return (Boolean)this.stmt.getValue(ctx, thisValue, factory) == false;
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        try {
            return (Boolean)MVEL.eval(this.name, ctx, factory) == false;
        }
        catch (NullPointerException e) {
            throw new CompileException("negation operator applied to a null value", e);
        }
        catch (ClassCastException e) {
            throw new CompileException("negation operator applied to non-boolean expression", e);
        }
    }

    public Class getEgressType() {
        return Boolean.class;
    }
}

