/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.reporter.extractor;

import com.tangosol.coherence.reporter.Constants;
import com.tangosol.net.management.MBeanHelper;
import com.tangosol.util.Base;
import com.tangosol.util.ValueExtractor;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;

public class AttributeExtractor
implements ValueExtractor,
Constants {
    protected String m_sJoinTemplate;
    protected String m_sAttribute;
    protected char m_cDelim;
    protected boolean m_fReturnNeg = false;

    public AttributeExtractor(String sAttribute) {
        this(sAttribute, ',');
    }

    public AttributeExtractor(String sAttribute, char cDelim) {
        this(sAttribute, cDelim, false);
    }

    public AttributeExtractor(String sAttribute, char cDelim, boolean fReturnNeg) {
        this.m_sAttribute = sAttribute;
        this.m_cDelim = cDelim;
        this.m_fReturnNeg = fReturnNeg;
    }

    @Override
    public Object extract(Object oTarget) {
        MBeanServer mbs = MBeanHelper.findMBeanServer();
        try {
            Object oReturn;
            ObjectName oJoinName = (ObjectName)oTarget;
            String sAttribName = this.m_sAttribute;
            String sCurrent = AttributeExtractor.currentKey(sAttribName);
            Object oData = mbs.getAttribute(oJoinName, sCurrent);
            if (oData == null) {
                return DEFAULT_VALUE;
            }
            if (!sCurrent.equals(sAttribName)) {
                oData = this.getValue(AttributeExtractor.nextKey(sAttribName), oData);
            }
            if (oData == null) {
                oReturn = DEFAULT_VALUE;
            } else {
                oReturn = this.getValue(sAttribName, oData);
                if (this.m_fReturnNeg) {
                    return oReturn;
                }
                if (oReturn instanceof Number && ((Number)oReturn).doubleValue() < 0.0) {
                    if (oReturn instanceof Long || oReturn instanceof Integer) {
                        return Base.makeLong(0L);
                    }
                    return new Double(0.0);
                }
            }
            return oReturn;
        }
        catch (InstanceNotFoundException e) {
        }
        catch (MBeanException e) {
        }
        catch (AttributeNotFoundException e) {
        }
        catch (ReflectionException reflectionException) {
            // empty catch block
        }
        return DEFAULT_VALUE;
    }

    protected Object getValue(String sKey, Object oData) {
        String sName = AttributeExtractor.currentKey(sKey);
        char cSubDelim = this.m_cDelim;
        if (sName.length() == 0) {
            return oData;
        }
        if (oData instanceof CompositeData) {
            CompositeData oCompData = (CompositeData)oData;
            Object oValue = oCompData.get(sName);
            return this.getValue(AttributeExtractor.nextKey(sKey), oValue);
        }
        if (oData instanceof Attribute) {
            return this.getValue(AttributeExtractor.nextKey(sName), ((Attribute)oData).getValue());
        }
        if (oData instanceof TabularData) {
            TabularDataSupport oTabData = (TabularDataSupport)oData;
            Object[] asKey = new String[]{sName};
            CompositeData cdData = oTabData.get(asKey);
            return this.getValue(AttributeExtractor.nextKey(sKey), cdData);
        }
        if (oData instanceof Object[]) {
            Object[] aoData = (Object[])oData;
            for (int c = 0; c < aoData.length; ++c) {
                Attribute a;
                String sAttribName;
                if (!(aoData[c] instanceof Attribute) || !(sAttribName = (a = (Attribute)aoData[c]).getName()).equals(sName)) continue;
                Object oValue = a.getValue();
                return this.getValue(AttributeExtractor.nextKey(sKey), oValue);
            }
        } else {
            if (oData instanceof Map) {
                Map mapData = (Map)oData;
                Object oValue = mapData.get(sName);
                return this.getValue(AttributeExtractor.nextKey(sKey), oValue);
            }
            if (oData instanceof long[]) {
                long[] anData = (long[])oData;
                int nSize = anData.length;
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < nSize; ++i) {
                    if (i != 0) {
                        sb.append(cSubDelim);
                    }
                    sb.append(anData[i]);
                }
                return sb.toString();
            }
            if (oData instanceof int[]) {
                int[] anData = (int[])oData;
                int nSize = anData.length;
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < nSize; ++i) {
                    if (i != 0) {
                        sb.append(cSubDelim);
                    }
                    sb.append(anData[i]);
                }
                return sb.toString();
            }
            if (oData instanceof double[]) {
                double[] anData = (double[])oData;
                int nSize = anData.length;
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < nSize; ++i) {
                    if (i != 0) {
                        sb.append(cSubDelim);
                    }
                    sb.append(anData[i]);
                }
                return sb.toString();
            }
            if (oData == null) {
                oData = "";
            }
        }
        return oData;
    }

    public static String currentKey(String sKey) {
        if (sKey.length() == 0) {
            return "";
        }
        return Base.parseDelimitedString(sKey, '/')[0];
    }

    public static String nextKey(String sKey) {
        String[] asKey = Base.parseDelimitedString(sKey, '/');
        String sRet = "";
        long lLen = asKey.length;
        int c = 1;
        while ((long)c < lLen) {
            sRet = sRet + asKey[c];
            if ((long)c != lLen - 1L) {
                sRet = sRet + "/";
            }
            ++c;
        }
        return sRet;
    }
}

