/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.transaction.internal.component;

import com.tangosol.coherence.transaction.Isolation;
import com.tangosol.coherence.transaction.exception.ReadTimedOutException;
import com.tangosol.coherence.transaction.internal.Message;
import com.tangosol.coherence.transaction.internal.Transaction;
import com.tangosol.coherence.transaction.internal.component.Component;
import com.tangosol.coherence.transaction.internal.operation.Operation;
import com.tangosol.coherence.transaction.internal.storage.LocalMemberState;
import com.tangosol.net.CacheFactory;

public class ReadVersionFetch
implements Component {
    private static final long MONOTONIC_READ_TIMEOUT = 15000L;

    @Override
    public Message invoke(Message msg) {
        long lVersion;
        Transaction tx = (Transaction)msg.getContext();
        Operation op = msg.getOperation();
        String sService = op.getServiceName();
        Isolation isolation = tx.getIsolation();
        switch (isolation) {
            case READ_COMMITTED: {
                return msg;
            }
            case TX_CONSISTENT_READ: {
                if (tx.isAutoCommit()) {
                    lVersion = this.getCRVersion(sService);
                    break;
                }
                lVersion = this.getTxConsistentReadVesion(tx, sService);
                break;
            }
            case STMT_CONSISTENT_READ: {
                lVersion = this.getCRVersion(sService);
                break;
            }
            case TX_MONOTONIC_CONSISTENT_READ: {
                if (tx.isAutoCommit()) {
                    lVersion = this.getStmtMonotonicConsistentReadVersion(tx, sService);
                    break;
                }
                lVersion = this.getTxMonotonicConsistentReadVersion(tx, sService);
                break;
            }
            case STMT_MONOTONIC_CONSISTENT_READ: {
                lVersion = this.getStmtMonotonicConsistentReadVersion(tx, sService);
                break;
            }
            default: {
                String sMsg = "Invalid isolation level: " + (Object)((Object)isolation);
                CacheFactory.log(sMsg, 2);
                throw new IllegalArgumentException(sMsg);
            }
        }
        msg.bind("version", lVersion);
        return msg;
    }

    private long getTxConsistentReadVesion(Transaction tx, String sService) {
        long lVersion = tx.getSession().getReadVersion();
        if (lVersion == -1L) {
            lVersion = this.getCRVersion(sService);
            tx.getSession().setReadVersion(lVersion);
        }
        return lVersion;
    }

    private long getStmtMonotonicConsistentReadVersion(Transaction tx, String sService) {
        return this.blockUntilVersionIsMonotonic(sService, tx.getSession().getMinimumMonotonicReadVersion());
    }

    private long getTxMonotonicConsistentReadVersion(Transaction tx, String sService) {
        long lVersion = tx.getSession().getReadVersion();
        if (lVersion == -1L) {
            lVersion = this.blockUntilVersionIsMonotonic(sService, tx.getSession().getMinimumMonotonicReadVersion());
            tx.getSession().setReadVersion(lVersion);
        }
        return lVersion;
    }

    long getCRVersion(String sService) {
        return LocalMemberState.getMemberState(sService).getConsistentReadVersion();
    }

    private long blockUntilVersionIsMonotonic(String sService, long lMinVersion) {
        long lVersion = this.getCRVersion(sService);
        long lStartMillis = System.currentTimeMillis();
        while (lVersion < lMinVersion) {
            this.checkForReadTimeout(lStartMillis, lMinVersion, lVersion);
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            lVersion = this.getCRVersion(sService);
        }
        return lVersion;
    }

    private void checkForReadTimeout(long lStartMillis, long lRequiredVersion, long lActualVersion) {
        long lBlocked = System.currentTimeMillis() - lStartMillis;
        if (lBlocked > this.getReadTimeout() && lActualVersion < lRequiredVersion) {
            throw new ReadTimedOutException(lBlocked, lRequiredVersion, lActualVersion);
        }
    }

    long getReadTimeout() {
        return 15000L;
    }
}

