/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.pof;

import com.tangosol.io.Evolvable;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofSerializer;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.annotation.Portable;
import com.tangosol.io.pof.reflect.internal.AnnotationVisitor;
import com.tangosol.io.pof.reflect.internal.ClassMetadataBuilder;
import com.tangosol.io.pof.reflect.internal.TypeMetadata;
import com.tangosol.util.Binary;
import java.io.IOException;
import java.util.Iterator;

public class PofAnnotationSerializer<T>
implements PofSerializer {
    private TypeMetadata<T> m_tmd;

    public PofAnnotationSerializer(int nTypeId, Class<T> clz) {
        this(nTypeId, clz, false);
    }

    public PofAnnotationSerializer(int nTypeId, Class<T> clz, boolean fAutoIndex) {
        if (clz == null) {
            throw new IllegalArgumentException("PofAnnotationSerializer requires a class");
        }
        this.initialize(nTypeId, clz, fAutoIndex);
    }

    @Override
    public void serialize(PofWriter out, Object o) throws IOException {
        boolean fEvolvable = o instanceof Evolvable;
        Evolvable evolvable = null;
        if (fEvolvable) {
            evolvable = (Evolvable)o;
            out.setVersionId(Math.max(evolvable.getDataVersion(), evolvable.getImplVersion()));
        }
        Iterator<TypeMetadata.AttributeMetadata<T>> iter = this.m_tmd.getAttributes();
        while (iter.hasNext()) {
            TypeMetadata.AttributeMetadata<Object> attr = iter.next();
            attr.getCodec().encode(out, attr.getIndex(), attr.get(o));
        }
        Binary binRemainder = null;
        if (fEvolvable) {
            binRemainder = evolvable.getFutureData();
        }
        out.writeRemainder(binRemainder);
    }

    @Override
    public Object deserialize(PofReader in) throws IOException {
        TypeMetadata<T> tmd = this.m_tmd;
        T value = tmd.newInstance();
        boolean fEvolvable = value instanceof Evolvable;
        Evolvable evolvable = null;
        if (fEvolvable) {
            evolvable = (Evolvable)value;
            evolvable.setDataVersion(in.getVersionId());
        }
        Iterator<TypeMetadata.AttributeMetadata<T>> iter = tmd.getAttributes();
        while (iter.hasNext()) {
            TypeMetadata.AttributeMetadata<T> attr = iter.next();
            attr.set(value, attr.getCodec().decode(in, attr.getIndex()));
        }
        Binary binRemainder = in.readRemainder();
        if (fEvolvable) {
            evolvable.setFutureData(binRemainder);
        }
        return value;
    }

    private void initialize(int nTypeId, Class<T> clz, boolean fAutoIndex) {
        Portable portable = clz.getAnnotation(Portable.class);
        if (portable == null) {
            throw new IllegalArgumentException(String.format("Attempting to use %s for a class (%s) that has no %s annotation", this.getClass().getSimpleName(), clz.getName(), Portable.class.getSimpleName()));
        }
        ClassMetadataBuilder builder = new ClassMetadataBuilder().setTypeId(nTypeId);
        builder.accept(new AnnotationVisitor(fAutoIndex), clz);
        this.m_tmd = builder.build();
    }
}

