/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net;

import com.tangosol.net.SocketProvider;
import com.tangosol.net.SocketProviderFactory;
import com.tangosol.net.WrapperSelector;
import com.tangosol.net.WrapperServerSocketChannel;
import com.tangosol.net.WrapperSocketChannel;
import com.tangosol.run.xml.XmlConfigurable;
import com.tangosol.run.xml.XmlElement;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.MulticastSocket;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.Channel;
import java.nio.channels.DatagramChannel;
import java.nio.channels.Pipe;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;

public abstract class WrapperSocketProvider
extends SelectorProvider
implements SocketProvider,
XmlConfigurable {
    protected SocketProviderFactory m_factory;
    private SocketProvider m_delegate;
    protected XmlElement m_xml;

    public WrapperSocketProvider(SocketProvider provider) {
        this.m_delegate = provider;
    }

    protected WrapperSocketProvider() {
    }

    public void setDelegate(SocketProvider provider) {
        if (this.m_delegate != null) {
            throw new IllegalStateException();
        }
        this.m_delegate = provider;
    }

    public SocketProvider getDelegate() {
        return this.m_delegate;
    }

    public SocketProvider ensureDelegate() throws IOException {
        SocketProvider delegate = this.m_delegate;
        if (delegate == null) {
            XmlElement xml = this.m_xml;
            SocketProviderFactory factory = this.m_factory;
            this.m_delegate = factory == null || xml == null ? SocketProviderFactory.DEFAULT_PROVIDER : factory.ensureProvider(xml.getElement("socket-provider"));
            delegate = this.m_delegate;
        }
        return delegate;
    }

    @Override
    public Socket openSocket() throws IOException {
        return this.ensureDelegate().openSocket();
    }

    @Override
    public SocketChannel openSocketChannel() throws IOException {
        return new WrapperSocketChannel(this.ensureDelegate().openSocketChannel(), this);
    }

    @Override
    public ServerSocket openServerSocket() throws IOException {
        return this.ensureDelegate().openServerSocket();
    }

    @Override
    public ServerSocketChannel openServerSocketChannel() throws IOException {
        return new WrapperServerSocketChannel(this.ensureDelegate().openServerSocketChannel(), this);
    }

    @Override
    public DatagramSocket openDatagramSocket() throws IOException {
        return this.ensureDelegate().openDatagramSocket();
    }

    @Override
    public DatagramChannel openDatagramChannel() throws IOException {
        return this.ensureDelegate().openDatagramChannel();
    }

    @Override
    public MulticastSocket openMulticastSocket() throws IOException {
        return this.ensureDelegate().openMulticastSocket();
    }

    @Override
    public void setFactory(SocketProviderFactory factory) {
        this.m_factory = factory;
    }

    @Override
    public SocketProviderFactory getFactory() {
        return this.m_factory;
    }

    @Override
    public AbstractSelector openSelector() throws IOException {
        SocketProvider delegate = this.ensureDelegate();
        if (!(delegate instanceof SelectorProvider)) {
            throw new UnsupportedOperationException();
        }
        return new WrapperSelector(((SelectorProvider)((Object)delegate)).openSelector(), this);
    }

    @Override
    public Pipe openPipe() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Channel inheritedChannel() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public XmlElement getConfig() {
        return this.m_xml;
    }

    @Override
    public void setConfig(XmlElement xml) {
        this.m_xml = xml;
    }
}

