/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.ssl;

import com.tangosol.net.WrapperServerSocketChannel;
import com.tangosol.net.ssl.SSLSocketChannel;
import com.tangosol.net.ssl.SSLSocketProvider;
import java.io.IOException;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;

public class SSLServerSocketChannel
extends WrapperServerSocketChannel {
    protected boolean m_fBlocking;

    protected SSLServerSocketChannel(ServerSocketChannel channel, SSLSocketProvider provider) throws IOException {
        super(channel, provider);
        this.m_fBlocking = channel.isBlocking();
    }

    @Override
    public SocketChannel accept() throws IOException {
        if (this.m_fBlocking) {
            throw new IllegalBlockingModeException();
        }
        SocketChannel chan = this.m_delegate.accept();
        return chan == null ? null : new SSLSocketChannel(chan, (SSLSocketProvider)this.provider());
    }

    @Override
    protected void implConfigureBlocking(boolean block) throws IOException {
        if (block) {
            throw new IllegalBlockingModeException();
        }
        this.m_delegate.configureBlocking(block);
        this.m_fBlocking = block;
    }
}

