package org.gridvise.mgmtcache.coh.entity.events

import org.gridvise.event.Event
import org.gridvise.coherence.cache.entity.AbstractCache
import com.tangosol.net.NamedCache
import com.tangosol.util.extractor.ReflectionExtractor
import com.tangosol.util.MapEvent
import com.tangosol.util.MapListener
import com.tangosol.util.ValueExtractor

object EventCache extends AbstractCache[EventKey, Event] with MapListener {

  val launchableKeyExtractor: ValueExtractor = new ReflectionExtractor("launchableKey")
  val dictionaryEntryExtractor: ValueExtractor = new ReflectionExtractor("dictionaryEntry")

  var listener = List[EventListener]()

  override def getCacheName() = "event"

  override def addIndexes(namedCache: NamedCache) {
  //  namedCache.addIndex(launchableKeyExtractor, false, null)
  //  namedCache.addIndex(dictionaryEntryExtractor, false, null)

    namedCache.addMapListener(this)
    println("registered event listener")
  }

  def store(event: Event) {
    val l = event.launchalbe
    put(event.eventKey(), event)
  }

  def addListener(eventListener: EventListener) {
    //FIXE is this thread safe???
    listener = eventListener :: listener
  }

  def entryDeleted(evt: MapEvent) {
    println("deleted: " + evt)
  }
  
  def entryInserted(evt: MapEvent) {
    println("inserted: " + evt+ " notifying "+listener.size+" listener")
    listener.foreach(l => l.handleEvent(evt.getNewValue().asInstanceOf[Event]))
  }
  
  def entryUpdated(evt: MapEvent) {
    println("updated: " + evt)
  }

}