/*
 * Decompiled with CFR 0.152.
 */
package org.gridvise.util.jmx;

import com.sun.tools.attach.VirtualMachine;
import java.io.File;
import java.util.Set;
import javax.management.AttributeValueExp;
import javax.management.MBeanServerConnection;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.Query;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.gridvise.util.jmx.ValueAddress;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class LocalMBeanServerConnections$ {
    public static final LocalMBeanServerConnections$ MODULE$;
    private final String CONNECTOR_ADDRESS;
    private final Map<String, MBeanServerConnection> pool;

    static {
        new LocalMBeanServerConnections$();
    }

    private String CONNECTOR_ADDRESS() {
        return this.CONNECTOR_ADDRESS;
    }

    public Map<String, MBeanServerConnection> pool() {
        return this.pool;
    }

    public MBeanServerConnection getConnection(String pid) {
        return this.pool().contains((Object)pid) ? (MBeanServerConnection)this.pool().apply((Object)pid) : this.createConnectionForPid(pid);
    }

    public void removeConnection(String pid) {
        this.pool().remove((Object)pid);
    }

    public MBeanServerConnection createConnectionForPid(String pid) {
        JMXServiceURL target = this.getURLForPid(pid);
        JMXConnector connector = JMXConnectorFactory.connect(target);
        MBeanServerConnection c = connector.getMBeanServerConnection();
        this.pool().update((Object)pid, (Object)c);
        return c;
    }

    public JMXServiceURL getURLForPid(String pid) {
        VirtualMachine vm = VirtualMachine.attach(pid);
        String connectorAddress = vm.getAgentProperties().getProperty(this.CONNECTOR_ADDRESS());
        if (connectorAddress == null) {
            String agent = new StringBuilder().append((Object)vm.getSystemProperties().getProperty("java.home")).append((Object)File.separator).append((Object)"lib").append((Object)File.separator).append((Object)"management-agent.jar").toString();
            vm.loadAgent(agent);
            connectorAddress = vm.getAgentProperties().getProperty(this.CONNECTOR_ADDRESS());
        }
        return new JMXServiceURL(connectorAddress);
    }

    public scala.collection.immutable.Map<String, Object> getValues(ValueAddress address, String pid) {
        ObjectName on = new ObjectName(address.addressSpace());
        AttributeValueExp name = Query.attr(address.name());
        MBeanServerConnection c = this.getConnection(pid);
        Set<ObjectInstance> beans = c.queryMBeans(on, null);
        scala.collection.immutable.Map m = ((TraversableOnce)JavaConversions$.MODULE$.asScalaSet(beans).toList().map((Function1)new Serializable(address, c){
            public static final long serialVersionUID = 0L;
            private final ValueAddress address$1;
            private final MBeanServerConnection c$1;

            public final Tuple2<String, Object> apply(ObjectInstance b) {
                return new Tuple2((Object)b.getObjectName().toString(), (Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(this.c$1.getAttribute(b.getObjectName(), this.address$1.name()).toString())).toInt()));
            }
            {
                this.address$1 = address$1;
                this.c$1 = c$1;
            }
        }, List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
        return m;
    }

    private LocalMBeanServerConnections$() {
        MODULE$ = this;
        this.CONNECTOR_ADDRESS = "com.sun.management.jmxremote.localConnectorAddress";
        this.pool = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

