/*
 * Decompiled with CFR 0.152.
 */
package org.gridvise.logical.os;

import org.gridvise.logical.os.OSSupport;
import org.gridvise.logical.os.ProcInfo;
import org.gridvise.logical.os.support.UnixSupport;
import org.gridvise.logical.os.support.WindowsSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.sys.process.Process;

public final class OSOperations$
extends OSSupport {
    public static final OSOperations$ MODULE$;
    private OSSupport osSupportImpl;

    static {
        new OSOperations$();
    }

    public Logger logger() {
        return LoggerFactory.getLogger(this.getClass());
    }

    public OSSupport osSupportImpl() {
        return this.osSupportImpl;
    }

    public void osSupportImpl_$eq(OSSupport x$1) {
        this.osSupportImpl = x$1;
    }

    public void initialize() {
        if (this.is("win")) {
            this.osSupportImpl_$eq(new WindowsSupport());
            return;
        }
        if (this.is("nix")) {
            this.osSupportImpl_$eq(new UnixSupport());
            return;
        }
        if (this.is("mac")) {
            this.osSupportImpl_$eq(new UnixSupport());
            return;
        }
        throw new Exception("Operating system not supported by gridvise");
    }

    public boolean is(String osNameFragment) {
        String os = System.getProperty("os.name").toLowerCase();
        this.logger().info(new StringOps(Predef$.MODULE$.augmentString("os is %s ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{os})));
        return os.indexOf(osNameFragment) >= 0;
    }

    @Override
    public String getClasspathSeparator() {
        return this.osSupportImpl().getClasspathSeparator();
    }

    @Override
    public String getProcessIdentifier(Process process) {
        return this.osSupportImpl().getProcessIdentifier(process);
    }

    @Override
    public void stopProcess(String processIdentifier) {
        this.osSupportImpl().stopProcess(processIdentifier);
    }

    @Override
    public String getJavaCommand() {
        return this.osSupportImpl().getJavaCommand();
    }

    @Override
    public void setSystemPropery(String name, String value) {
        this.osSupportImpl().setSystemPropery(name, value);
    }

    @Override
    public void threadDump(String pid) {
        this.osSupportImpl().threadDump(pid);
    }

    @Override
    public boolean isValidPid(String pid) {
        return this.osSupportImpl().isValidPid(pid);
    }

    @Override
    public List<ProcInfo> getCPUUsage() {
        return this.osSupportImpl().getCPUUsage();
    }

    @Override
    public List<ProcInfo> getCPUUsageHigherThen(int percentage) {
        return this.osSupportImpl().getCPUUsageHigherThen(percentage);
    }

    @Override
    public String getUserName() {
        return this.osSupportImpl().getUserName();
    }

    private OSOperations$() {
        MODULE$ = this;
        this.osSupportImpl = new UnixSupport();
        this.initialize();
    }
}

