/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net;

import com.oracle.common.base.Collector;
import com.oracle.common.io.BufferSequence;
import com.oracle.common.net.exabus.EndPoint;
import com.oracle.common.net.exabus.Event;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Util;
import com.tangosol.coherence.component.net.MessageHandler;

public class MessageHandler$EventCollector
extends Util
implements Collector {
    public static final int ET_BACKLOG_EXCESSIVE = 5;
    public static final int ET_BACKLOG_NORMAL = 6;
    public static final int ET_CLOSE = 1;
    public static final int ET_CONNECT = 2;
    public static final int ET_DISCONNECT = 3;
    public static final int ET_MESSAGE = 9;
    public static final int ET_OPEN = 0;
    public static final int ET_RECEIPT = 7;
    public static final int ET_RELEASE = 4;
    public static final int ET_SIGNAL = 8;

    static {
        MessageHandler$EventCollector._initStatic();
    }

    public MessageHandler$EventCollector() {
        this(null, null, true);
    }

    public MessageHandler$EventCollector(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void _initStatic$Default() {
    }

    protected static void _initStatic() {
        MessageHandler$EventCollector._initStatic$Default();
        Event.Type[] enumType = new Event.Type[]{Event.Type.OPEN, Event.Type.CLOSE, Event.Type.CONNECT, Event.Type.DISCONNECT, Event.Type.RELEASE, Event.Type.BACKLOG_EXCESSIVE, Event.Type.BACKLOG_NORMAL, Event.Type.RECEIPT, Event.Type.SIGNAL, Event.Type.MESSAGE};
        int i = 0;
        int c = enumType.length;
        while (i < c) {
            Event.Type type = enumType[i];
            Component._assert(type.ordinal() == i, String.valueOf("Invalid ordinal value for ") + (Object)((Object)type));
            ++i;
        }
    }

    public void add(Object oEvent) {
        MessageHandler handler = (MessageHandler)this.get_Module();
        Event event = (Event)oEvent;
        EndPoint peer = event.getEndPoint();
        boolean fDispose = true;
        try {
            try {
                switch (event.getType().ordinal()) {
                    case 9: {
                        if (handler.getState() == MessageHandler.STATE_OPEN) {
                            handler.onMessage(peer, (BufferSequence)event.getContent(), event);
                            fDispose = false;
                        }
                        break;
                    }
                    case 7: {
                        handler.onReceipt(peer, event.getContent());
                        break;
                    }
                    case 0: {
                        handler.onOpen();
                        break;
                    }
                    case 1: {
                        handler.onClose(peer);
                        break;
                    }
                    case 2: {
                        handler.onConnect(peer);
                        break;
                    }
                    case 3: {
                        handler.onDisconnect(peer, (Throwable)event.getContent());
                        break;
                    }
                    case 4: {
                        handler.onReleased(peer);
                        break;
                    }
                    case 5: {
                        handler.onBacklog(peer, true);
                        break;
                    }
                    case 6: {
                        handler.onBacklog(peer, false);
                        break;
                    }
                }
            }
            catch (Throwable e) {
                handler.onException(e);
            }
            Object var7_8 = null;
            if (fDispose) {
                event.dispose();
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (fDispose) {
                event.dispose();
            }
            throw throwable;
        }
    }

    public void flush() {
        ((MessageHandler)this.get_Module()).getIncomingQueue().flush();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/MessageHandler$EventCollector".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new MessageHandler$EventCollector();
    }

    private final Component get_Module() {
        return this.get_Parent();
    }
}

