/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Util;
import com.tangosol.coherence.component.util.DaemonPool$Daemon;
import com.tangosol.coherence.component.util.DaemonPool$Queue;
import com.tangosol.coherence.component.util.DaemonPool$StopTask;
import com.tangosol.coherence.component.util.DaemonPool$WrapperTask;
import com.tangosol.net.Guardable;
import com.tangosol.net.Guardian;
import com.tangosol.net.PriorityTask;
import com.tangosol.util.Base;
import com.tangosol.util.ListMap;
import com.tangosol.util.SafeLinkedList;
import com.tangosol.util.WrapperException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DaemonPool
extends Util
implements Guardian {
    private int __m_AbandonThreshold;
    private boolean __m_AutoStart;
    private int __m_DaemonCount;
    private transient List __m_Daemons;
    private long __m_HungThreshold;
    private DaemonPool$Queue __m_Queue;
    private transient boolean __m_Started;
    private transient int __m_StatsAbandonedCount;
    private transient long __m_StatsActiveMillis;
    private transient int __m_StatsHungCount;
    private transient long __m_StatsHungDuration;
    private transient String __m_StatsHungTaskId;
    private transient int __m_StatsMaxBacklog;
    private transient long __m_StatsTaskCount;
    private transient int __m_StatsTimeoutCount;
    private long __m_TaskTimeout;
    private transient ThreadGroup __m_ThreadGroup;
    private static ListMap __mapChildren;

    static {
        DaemonPool.__initStatic();
    }

    public DaemonPool() {
        this(null, null, true);
    }

    public DaemonPool(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setAbandonThreshold(8);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this._addChild(new DaemonPool$Queue("Queue", this, true), "Queue");
        this._addChild(new DaemonPool$StopTask("StopTask", this, true), "StopTask");
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("Daemon", DaemonPool$Daemon.get_CLASS());
        Class clazz2 = __mapChildren.put("WrapperTask", DaemonPool$WrapperTask.get_CLASS());
    }

    public void add(Runnable task) {
        this.add(task, false);
    }

    public void add(Runnable task, boolean fAggressiveTimeout) {
        if (task != null) {
            DaemonPool$Queue queue = this.getQueue();
            DaemonPool$WrapperTask taskWrapper = this.instantiateWrapperTask(task, fAggressiveTimeout);
            queue.add(taskWrapper);
            int cCurBacklog = queue.size();
            int cMaxBacklog = this.getStatsMaxBacklog();
            if (cCurBacklog > cMaxBacklog) {
                this.setStatsMaxBacklog(cCurBacklog);
            }
        }
    }

    public void checkHungTasks() {
        long cHungThreshold = this.getHungThreshold();
        if (cHungThreshold == (long)0) {
            return;
        }
        long ldtNow = Base.getSafeTimeMillis();
        DaemonPool$WrapperTask taskLongest = null;
        long cLongest = -1L;
        int cHung = 0;
        Object[] aDaemon = this.getDaemons().toArray();
        int i = 0;
        int cDaemons = aDaemon.length;
        while (i < cDaemons) {
            long ldtStart;
            long cDuration;
            DaemonPool$Daemon daemon = (DaemonPool$Daemon)aDaemon[i];
            DaemonPool$WrapperTask wrapper = daemon.getWrapperTask();
            if (wrapper != null && (cDuration = ldtNow - (ldtStart = wrapper.getStartTime())) > cHungThreshold) {
                if (cDuration > cLongest) {
                    cLongest = cDuration;
                    taskLongest = wrapper;
                }
                ++cHung;
            }
            ++i;
        }
        if (cHung == 0) {
            this.setStatsHungCount(0);
            this.setStatsHungDuration(0L);
            this.setStatsHungTaskId("");
        } else {
            this.setStatsHungCount(cHung);
            this.setStatsHungDuration(cLongest);
            this.setStatsHungTaskId(taskLongest.getTaskId());
        }
    }

    public int getAbandonThreshold() {
        return this.__m_AbandonThreshold;
    }

    public int getActiveDaemonCount() {
        if (this.getQueue().size() > 0) {
            return this.getDaemonCount();
        }
        Object[] aDaemon = this.getDaemons().toArray();
        int cActive = 0;
        int i = 0;
        int cDaemons = aDaemon.length;
        while (i < cDaemons) {
            DaemonPool$Daemon daemon = (DaemonPool$Daemon)aDaemon[i];
            if (!(daemon != null) ? false : daemon.getWrapperTask() != null) {
                ++cActive;
            }
            ++i;
        }
        return cActive;
    }

    public int getDaemonCount() {
        return this.__m_DaemonCount;
    }

    public List getDaemons() {
        return this.__m_Daemons;
    }

    public long getHungThreshold() {
        return this.__m_HungThreshold;
    }

    public DaemonPool$Queue getQueue() {
        return this.__m_Queue;
    }

    public long getRecoveryDelay() {
        return 50L;
    }

    public int getStatsAbandonedCount() {
        return this.__m_StatsAbandonedCount;
    }

    public long getStatsActiveMillis() {
        return this.__m_StatsActiveMillis;
    }

    public int getStatsHungCount() {
        return this.__m_StatsHungCount;
    }

    public long getStatsHungDuration() {
        return this.__m_StatsHungDuration;
    }

    public String getStatsHungTaskId() {
        return this.__m_StatsHungTaskId;
    }

    public int getStatsMaxBacklog() {
        return this.__m_StatsMaxBacklog;
    }

    public long getStatsTaskCount() {
        return this.__m_StatsTaskCount;
    }

    public int getStatsTimeoutCount() {
        return this.__m_StatsTimeoutCount;
    }

    public long getTaskTimeout() {
        return this.__m_TaskTimeout;
    }

    public ThreadGroup getThreadGroup() {
        return this.__m_ThreadGroup;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/DaemonPool".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new DaemonPool();
    }

    private final Component get_Module() {
        return this;
    }

    public Guardian.GuardContext guard(Guardable guardable) {
        Component service = this.get_Parent();
        if (service instanceof Guardian) {
            return ((Guardian)((Object)service)).guard(guardable);
        }
        throw new UnsupportedOperationException();
    }

    public Guardian.GuardContext guard(Guardable guardable, long cMillis, float flPctRecover) {
        Component service = this.get_Parent();
        if (service instanceof Guardian) {
            return ((Guardian)((Object)service)).guard(guardable, cMillis, flPctRecover);
        }
        throw new UnsupportedOperationException();
    }

    protected void halt() {
        if (this.isStarted()) {
            List listDaemons = this.getDaemons();
            this.setStarted(false);
            Iterator iter = listDaemons.iterator();
            while (iter.hasNext()) {
                ((DaemonPool$Daemon)iter.next()).halt();
            }
        }
    }

    public DaemonPool$Daemon instantiateDaemon(int i) {
        DaemonPool$Daemon daemon = (DaemonPool$Daemon)this._newChild("Daemon");
        String sName = daemon.getThreadName();
        daemon.setThreadName(String.valueOf(sName) + ":" + i);
        daemon.setThreadGroup(this.getThreadGroup());
        this.getDaemons().add(daemon);
        this.guard(daemon.getGuardable());
        return daemon;
    }

    protected DaemonPool$WrapperTask instantiateWrapperTask() {
        DaemonPool$WrapperTask task = new DaemonPool$WrapperTask();
        this._linkChild(task);
        return task;
    }

    protected DaemonPool$WrapperTask instantiateWrapperTask(Runnable task, boolean fAggressiveTimeout) {
        DaemonPool$WrapperTask wrapper = this.instantiateWrapperTask();
        wrapper.setTask(task);
        if (task instanceof PriorityTask) {
            PriorityTask ptask = (PriorityTask)((Object)task);
            int iPriority = ptask.getSchedulingPriority();
            if (iPriority < PriorityTask.SCHEDULE_STANDARD ? true : iPriority > PriorityTask.SCHEDULE_IMMEDIATE) {
                Component._trace(String.valueOf("Invalid scheduling priority value: ") + iPriority + " for " + task.getClass().getName() + "; changing to SCHEDULE_STANDARD", 2);
                iPriority = PriorityTask.SCHEDULE_STANDARD;
            }
            wrapper.setPriority(iPriority);
            long cTimeout = ptask.getExecutionTimeoutMillis();
            if (cTimeout == PriorityTask.TIMEOUT_DEFAULT) {
                cTimeout = this.getTaskTimeout();
            } else if (cTimeout == PriorityTask.TIMEOUT_NONE) {
                cTimeout = 0x7FFFFFFL;
            }
            if (cTimeout > (long)0) {
                long ldtNow = Base.getSafeTimeMillis();
                wrapper.setPostTime(ldtNow);
                wrapper.setTimeoutMillis(cTimeout);
                if (fAggressiveTimeout) {
                    wrapper.setStopTime(ldtNow + cTimeout);
                    this.guard(wrapper, cTimeout, 1.0f);
                }
            }
        }
        return wrapper;
    }

    protected boolean isAutoStart() {
        return this.__m_AutoStart;
    }

    public boolean isStarted() {
        return this.__m_Started;
    }

    public boolean isStuck() {
        return !this.isStarted() ? false : this.getQueue().isStuck();
    }

    public boolean join(long cMillis) {
        List listDaemons = this.getDaemons();
        if (listDaemons != null) {
            long ldtTimeout = cMillis == (long)0 ? Long.MAX_VALUE : Base.getSafeTimeMillis() + cMillis;
            DaemonPool$Daemon[] aDaemon = listDaemons.toArray(new DaemonPool$Daemon[listDaemons.size()]);
            int i = 0;
            int c = aDaemon.length;
            while (i < c) {
                if (cMillis < (long)0 ? true : aDaemon[i].join(cMillis) ^ true) {
                    return false;
                }
                cMillis = Base.computeSafeWaitTime(ldtTimeout);
                ++i;
            }
        }
        return true;
    }

    public void onInit() {
        String sCount = System.getProperty("tangosol.coherence.pool.interruptcount");
        if (sCount != null) {
            this.setAbandonThreshold(Integer.parseInt(sCount));
        }
        this.setQueue((DaemonPool$Queue)this._findChild("Queue"));
        super.onInit();
        if (this.isAutoStart()) {
            this.start();
        }
    }

    public void resetStats() {
        this.setStatsActiveMillis(0L);
        this.setStatsMaxBacklog(0);
        this.setStatsTaskCount(0L);
        this.setStatsTimeoutCount(0);
    }

    public void runCanceled(PriorityTask task, boolean fAbandoned) {
        try {
            task.runCanceled(fAbandoned);
        }
        catch (RuntimeException runtimeException) {}
    }

    public void setAbandonThreshold(int cThreads) {
        this.__m_AbandonThreshold = cThreads;
    }

    protected void setAutoStart(boolean fAutoStart) {
        Component._assert(this.is_Constructed() ^ true);
        this.__m_AutoStart = fAutoStart;
    }

    public synchronized void setDaemonCount(int cThreads) {
        int cOrig = this.getDaemonCount();
        if (cThreads != cOrig) {
            if (cThreads < 0) {
                throw new IllegalArgumentException(String.valueOf("Requested number of threads (") + cThreads + ") is negative");
            }
            if (this.isStarted()) {
                if (cThreads > cOrig) {
                    int i = cOrig;
                    while (i < cThreads) {
                        DaemonPool$Daemon daemon = this.instantiateDaemon(i);
                        daemon.start();
                        ++i;
                    }
                } else {
                    int i = cThreads;
                    while (i < cOrig) {
                        this.add((DaemonPool$StopTask)this._findChild("StopTask"));
                        ++i;
                    }
                }
            }
            this.__m_DaemonCount = cThreads;
        }
    }

    protected void setDaemons(List list) {
        this.__m_Daemons = list;
    }

    public void setHungThreshold(long cMillis) {
        this.__m_HungThreshold = cMillis;
    }

    protected void setQueue(DaemonPool$Queue queue) {
        this.__m_Queue = queue;
    }

    protected void setStarted(boolean fStarted) {
        Component._assert(fStarted ^ true ? true : this.is_Constructed());
        this.__m_Started = fStarted;
    }

    public void setStatsAbandonedCount(int cThreads) {
        this.__m_StatsAbandonedCount = cThreads;
    }

    protected void setStatsActiveMillis(long cMillis) {
        this.__m_StatsActiveMillis = cMillis;
    }

    protected void setStatsHungCount(int cHung) {
        this.__m_StatsHungCount = cHung;
    }

    protected void setStatsHungDuration(long cDuration) {
        this.__m_StatsHungDuration = cDuration;
    }

    protected void setStatsHungTaskId(String sTaskId) {
        this.__m_StatsHungTaskId = sTaskId;
    }

    protected void setStatsMaxBacklog(int cTasks) {
        this.__m_StatsMaxBacklog = cTasks;
    }

    protected void setStatsTaskCount(long cTasks) {
        this.__m_StatsTaskCount = cTasks;
    }

    public void setStatsTimeoutCount(int cTasks) {
        this.__m_StatsTimeoutCount = cTasks;
    }

    public void setTaskTimeout(long cMillis) {
        this.__m_TaskTimeout = cMillis;
    }

    public void setThreadGroup(ThreadGroup group) {
        this.__m_ThreadGroup = group;
    }

    public synchronized void start() {
        Component._assert(this.is_Constructed());
        if (this.isStarted() ^ true) {
            this.setDaemons(new SafeLinkedList());
            int i = 0;
            int cThreads = this.getDaemonCount();
            while (i < cThreads) {
                DaemonPool$Daemon daemon = this.instantiateDaemon(i);
                daemon.start();
                ++i;
            }
            this.setStarted(true);
        }
    }

    public synchronized void stop() {
        Component._assert(this.is_Constructed());
        if (this.isStarted()) {
            List listDaemons = this.getDaemons();
            this.setStarted(false);
            DaemonPool$Daemon[] aDaemon = listDaemons.toArray(new DaemonPool$Daemon[listDaemons.size()]);
            int i = 0;
            int c = aDaemon.length;
            while (i < c) {
                aDaemon[i].stop();
                ++i;
            }
        }
    }

    public synchronized long updateStats(int cTasks, long ldtStart) {
        long ldtNow = Base.getSafeTimeMillis();
        if (cTasks > 0) {
            this.setStatsTaskCount(this.getStatsTaskCount() + (long)cTasks);
            this.setStatsActiveMillis(this.getStatsActiveMillis() + ldtNow - ldtStart);
        }
        return ldtNow;
    }
}

