/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.extend.Channel;
import com.tangosol.coherence.component.net.extend.Connection;
import com.tangosol.coherence.component.util.daemon.QueueProcessor$Queue;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Peer;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Peer$DispatchEvent;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Peer$MessageFactory$OpenConnection;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.Initiator$MessageFactory;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.Initiator$MessageFactory$OpenConnection;
import com.tangosol.net.OperationalContext;
import com.tangosol.net.RequestTimeoutException;
import com.tangosol.net.messaging.ConnectionInitiator;
import com.tangosol.net.messaging.Protocol;
import com.tangosol.net.messaging.Request;
import com.tangosol.net.security.SecurityHelper;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.ListMap;
import java.util.Map;
import javax.security.auth.Subject;

public abstract class Initiator
extends Peer
implements ConnectionInitiator {
    private long __m_ConnectTimeout;
    private Connection __m_Connection;
    private static ListMap __mapChildren;

    static {
        Initiator.__initStatic();
    }

    public Initiator(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("DispatchEvent", Peer$DispatchEvent.get_CLASS());
        Class clazz2 = __mapChildren.put("MessageFactory", Initiator$MessageFactory.get_CLASS());
        Class clazz3 = __mapChildren.put("Queue", QueueProcessor$Queue.get_CLASS());
    }

    protected void checkPingTimeouts() {
        Connection connection = this.getConnection();
        if (connection != null) {
            this.checkPingTimeout(connection);
        }
    }

    public synchronized void configure(XmlElement xml) {
        super.configure(xml);
        this.setConnectTimeout(this.getRequestTimeout());
    }

    public static ConnectionInitiator createInitiator(XmlElement xml, OperationalContext ctx) {
        ConnectionInitiator initiator;
        if (xml.getElement("jms-initiator") != null) {
            initiator = (ConnectionInitiator)((Object)Component._newInstance("Component.Util.Daemon.QueueProcessor.Service.Peer.Initiator.JmsInitiator"));
        } else if (xml.getElement("tcp-initiator") != null) {
            initiator = (ConnectionInitiator)((Object)Component._newInstance("Component.Util.Daemon.QueueProcessor.Service.Peer.Initiator.TcpInitiator"));
        } else {
            throw new IllegalArgumentException(String.valueOf("unsupported \"initiator-config\":\n") + xml);
        }
        initiator.setOperationalContext(ctx);
        initiator.configure(xml);
        return initiator;
    }

    public synchronized com.tangosol.net.messaging.Connection ensureConnection() {
        if (this.isRunning() ^ true) {
            throw new IllegalStateException(String.valueOf(this.getServiceName()) + " is not running");
        }
        Connection connection = this.getConnection();
        if (connection == null ? true : connection.isOpen() ^ true) {
            connection = this.openConnection();
        }
        return connection;
    }

    public static XmlElement findInitiatorConfig(XmlElement xml) {
        XmlElement xmlConfig = xml.getName().equals("initiator-config") ? xml : xml.getSafeElement("initiator-config");
        if (xmlConfig.getElement("jms-initiator") != null ? true : xmlConfig.getElement("tcp-initiator") != null) {
            return (XmlElement)xmlConfig.clone();
        }
        throw new IllegalArgumentException(String.valueOf("the \"initiator-config\" element is either") + " missing, empty, or does not contain a valid transport-specific" + " child element:\n" + xml);
    }

    public long getConnectTimeout() {
        return this.__m_ConnectTimeout;
    }

    public Connection getConnection() {
        return this.__m_Connection;
    }

    public String getDescription() {
        return String.valueOf(super.getDescription()) + ", ConnectTimeout=" + this.getConnectTimeout();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/peer/Initiator".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    private final Component get_Module() {
        return this;
    }

    public void onConnectionClosed(Connection connection) {
        if (this.getConnection() == connection) {
            this.setConnection(null);
            super.onConnectionClosed(connection);
        }
    }

    public void onConnectionError(Connection connection, Throwable e) {
        if (this.getConnection() == connection) {
            this.setConnection(null);
            super.onConnectionError(connection, e);
        }
    }

    public void onConnectionOpened(Connection connection) {
        if (this.get_Connection() == connection) {
            return;
        }
        if (this.getConnection() == null) {
            this.setConnection(connection);
            super.onConnectionOpened(connection);
        }
    }

    protected void onServiceStopped() {
        Connection connection = this.getConnection();
        if (connection != null) {
            connection.closeInternal(true, null, 100L);
            if (connection.isOpen()) {
                this.getDaemonPool().stop();
                connection.closeInternal(true, null, 1000L);
                if (connection.isOpen()) {
                    Component._trace(String.valueOf("Unable to close \"") + connection + "\"; this Connection will be abandoned", 1);
                }
            }
        }
        super.onServiceStopped();
    }

    protected void onServiceStopping() {
        Connection connection = this.getConnection();
        if (connection != null) {
            connection.closeInternal(true, null, 0L);
        }
        super.onServiceStopping();
    }

    protected Connection openConnection() {
        Connection connection = this.instantiateConnection();
        connection.open();
        return connection;
    }

    public void openConnection(Connection connection) {
        Component._assert(connection != null);
        Channel channel0 = this.get_Channel();
        Protocol.MessageFactory factory0 = channel0.getMessageFactory();
        Initiator$MessageFactory$OpenConnection request = (Initiator$MessageFactory$OpenConnection)factory0.createMessage(Peer$MessageFactory$OpenConnection.TYPE_ID);
        Subject subject = SecurityHelper.getCurrentSubject();
        request.setConnectionOpen(connection);
        request.setIdentityToken(this.serializeIdentityToken(this.generateIdentityToken(subject)));
        request.setSubject(subject);
        Request.Status status = (Request.Status)channel0.request(request);
        if (status != null) {
            try {
                status.waitForResponse(this.getConnectTimeout());
            }
            catch (RequestTimeoutException e) {
                connection.close(false, e);
                throw e;
            }
        }
    }

    protected void ping() {
        Connection connection = this.getConnection();
        if (connection != null) {
            connection.ping();
        }
    }

    protected void setConnectTimeout(long cMillis) {
        this.__m_ConnectTimeout = cMillis;
    }

    public void setConnection(Connection connection) {
        this.__m_Connection = connection;
    }
}

