/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.dslquery;

import com.tangosol.coherence.dslquery.CoherenceQuery;
import com.tangosol.coherence.dslquery.CoherenceQueryLanguage;
import com.tangosol.coherence.dslquery.SQLOPParser;
import com.tangosol.coherence.dsltools.precedence.TokenTable;
import com.tangosol.coherence.dsltools.termtrees.NodeTerm;
import com.tangosol.coherence.dsltools.termtrees.Term;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.Cluster;
import com.tangosol.net.DistributedCacheService;
import com.tangosol.net.Service;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.LiteMap;
import com.tangosol.util.LiteSet;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class QueryPlus {
    private boolean m_fsanity = true;
    private boolean m_fValidateCache = false;
    private boolean m_fTraceing = false;
    private boolean m_fWorking = false;
    private CoherenceQuery m_lastQuery;
    private boolean m_fExtendedLanguage = false;
    private String m_sTitle = null;
    private boolean m_fReportBackupCommandWarning = false;

    public void simpleREPL(PrintWriter out, BufferedReader reader) {
        this.m_fWorking = true;
        this.m_fReportBackupCommandWarning = true;
        while (this.m_fWorking) {
            out.println();
            out.flush();
            out.print("CohQL> ");
            out.flush();
            try {
                String line = reader.readLine();
                if (line == null) {
                    this.m_fWorking = false;
                    return;
                }
                this.m_fWorking = this.evalLine(line, out);
            }
            catch (Exception e) {
                out.flush();
                System.err.println("\n" + e);
            }
        }
    }

    public void jlineREPL(PrintWriter out, Object reader) {
        this.m_fWorking = true;
        this.m_fReportBackupCommandWarning = true;
        while (this.m_fWorking) {
            out.println();
            out.flush();
            try {
                String line = (String)ClassHelper.invoke(reader, "readLine", new Object[]{"CohQL> "});
                if (line == null) {
                    this.m_fWorking = false;
                    return;
                }
                this.m_fWorking = this.evalLine(line, out);
            }
            catch (Exception e) {
                out.flush();
                System.err.println("\n" + e);
            }
        }
    }

    public void setExtendedLanguage(boolean fExtendedLanguage) {
        this.m_fExtendedLanguage = fExtendedLanguage;
    }

    public void setTitle(String sTitle) {
        this.m_sTitle = sTitle;
    }

    protected Object query(String q, PrintWriter out, boolean trace, boolean fvalidateName, boolean fsanity) {
        boolean showPlan = false;
        if (q == null || q.length() == 0) {
            return null;
        }
        TokenTable toks = this.m_fExtendedLanguage ? CoherenceQueryLanguage.getSqlTokenTable(true) : CoherenceQueryLanguage.sqlTokenTable();
        SQLOPParser p = new SQLOPParser(q, toks);
        while (p.getScanner().matches("show") || p.getScanner().matches("plan")) {
            p.getScanner().advance();
            showPlan = true;
        }
        Term tn = p.parse();
        if (trace) {
            out.println("parsed: " + tn);
        }
        CoherenceQuery query = new CoherenceQuery(fvalidateName);
        query.setExtendedLanguage(this.m_fExtendedLanguage);
        this.m_lastQuery = query;
        if (query.build((NodeTerm)tn)) {
            if (showPlan) {
                out.print("plan: ");
                query.showPlan(out);
                return null;
            }
            if (trace) {
                out.print("plan: ");
                query.showPlan(out);
            }
            if (query.getFunction() == 11 && this.m_fReportBackupCommandWarning) {
                this.m_fReportBackupCommandWarning = false;
                System.err.println("WARNING: The backup command should not be used on active data set,");
                System.err.println("as it makes no provisions that ensure data consistency during the backup.");
                System.err.println("Please see the documentation for more detailed information.");
            }
            if (!fsanity || query.sanityCheck()) {
                return query.execute(out, trace);
            }
            out.print("Sanity Check Error: " + query.getErrorString());
            return null;
        }
        out.print("Error: " + query.getErrorString());
        return null;
    }

    public void processStdin(PrintWriter out, BufferedReader reader) {
        this.m_sTitle = null;
        try {
            while (true) {
                String line;
                if ((line = reader.readLine()) == null) {
                    out.flush();
                    return;
                }
                this.evalLine(line, out);
            }
        }
        catch (Exception e) {
            out.flush();
            return;
        }
    }

    public void processFile(String sfName, PrintWriter out, boolean trace, boolean fvalidateName, boolean fsanity) {
        String sLine = "@ \"" + sfName.trim() + "\"";
        TokenTable toks = this.m_fExtendedLanguage ? CoherenceQueryLanguage.getSqlTokenTable(true) : CoherenceQueryLanguage.sqlTokenTable();
        SQLOPParser p = new SQLOPParser(sLine, toks);
        Term tn = p.parse();
        if (trace) {
            out.println("parsed: " + tn);
        }
        CoherenceQuery query = new CoherenceQuery(fvalidateName);
        query.setExtendedLanguage(this.m_fExtendedLanguage);
        this.m_lastQuery = query;
        if (query.build((NodeTerm)tn)) {
            if (trace) {
                out.print("plan: ");
                query.showPlan(out);
            }
            if (!fsanity || query.sanityCheck()) {
                query.execute(out, trace);
                String err = query.getErrorString();
                if (err != null) {
                    out.println(err);
                }
            } else {
                out.print("Sanity Check Error: " + query.getErrorString());
            }
        } else {
            out.print("Error: " + query.getErrorString());
        }
    }

    protected void showCommands(PrintWriter out) {
        out.println("java com.tangosol.coherence.dslquery.QueryPlus [-t] [-c] [-s] [-e] [-l cmd]* [-f file]*  ");
        out.println("commands");
        out.println("help");
        out.println("bye |  quit ");
        out.println("trace on | trace off");
        out.println("extended language on | extended language off");
        out.println("show plan 'CohQL command'");
        out.println("(ENSURE | CREATE) CACHE 'cache-name'");
        out.println("(ENSURE | CREATE) INDEX [ON] 'cache-name' value-extractor-list");
        out.println("DROP CACHE 'cache-name'");
        out.println("DROP INDEX [ON] 'cache-name' value-extractor-list");
        out.println("BACKUP CACHE 'cache-name' [TO] [FILE] 'filename'");
        out.println("RESTORE CACHE 'cache-name' [FROM] [FILE] 'filename'");
        out.println("INSERT INTO 'cache-name' [KEY (literal | new java-constructor | static method) ] VALUE (literal |  new java-constructor | static method)");
        out.println("DELETE FROM 'cache-name' [[AS] alias] [WHERE conditional-expression]");
        out.println("UPDATE 'cache-name' [[AS] alias] SET update-statement {, update-statement}* [ WHERE conditional-expression ] ");
        out.println("SELECT (properties* aggregators* | * | alias) FROM 'cache-name' [[AS] alias] [WHERE conditional-expression] [GROUP [BY] properties+]");
        out.println("SOURCE FROM [FILE] 'filename'");
        out.println("@ 'filename'");
        out.println(". filename");
    }

    protected void showHelp(PrintWriter out) {
        out.println("Command line options: [-t] [-c] [-s] [-e] [-l cmd]* [-f file]*");
        out.println("-t      turn on tracing  This shows information useful for debugging");
        out.println("-c      exit when command line processing is finished");
        out.println("-s      silent mode.  Suppress prompts and result headings, read from stdin");
        out.println("        and write to stdout. Useful for use in pipes or filters");
        out.println("-e      extended language mode.  Allows object literals in update and insert commands.");
        out.println("        elements between '[' and']'denote an ArrayList.");
        out.println("        elements between '{' and'}'denote a HashSet.");
        out.println("        elements between '{' and'}'with key/value pairs separated by ':' denotes a HashMap.");
        out.println("        a literal HashMap  preceeded by a classname are procesed by:");
        out.println("          calling a zero argument constructor");
        out.println("          then followed by each pair key being turned into a setter and invoked with the value.");
        out.println("-l cmd  Each instance of -l followed by a command will execute one command");
        out.println("-f file Each instance of -f followed by a filename load one file of commands.");
        out.println();
        out.println();
        out.println("commands");
        out.println("Print a simple list of commands without explanations.");
        out.println();
        out.println("bye |  quit ");
        out.println("Exits the command line tool.");
        out.println();
        out.println("trace on | trace off");
        out.println("Controls tracing mode. This shows information that can help with debugging");
        out.println();
        out.println("extended language on | extended language off");
        out.println("Controls extended language mode.");
        out.println();
        out.println("show plan 'CohQL command'");
        out.println("Shows what the CohQL command would do rather than executing it.");
        out.println();
        out.println("(ENSURE |  CREATE) CACHE 'cache-name'");
        out.println("Make sure the NamedCache 'cache-name' exists.");
        out.println();
        out.println("(ENSURE | CREATE) INDEX [ON] 'cache-name' value-extractor-list");
        out.println("Make sure the Index on 'cache-name' that is made from the value-extractor-list exists.");
        out.println();
        out.println("DROP CACHE 'cache-name'");
        out.println("Remove the cache 'cache-name' from the cluster.");
        out.println();
        out.println("DROP INDEX [ON] 'cache-name' value-extractor-list");
        out.println("Remove the index made from value-extractor-list from cache 'cache-name'.");
        out.println();
        out.println("BACKUP CACHE 'cache-name' [TO] [FILE] 'filename'");
        out.println("Backup the cache named 'cache-name' to the file named 'filename'.");
        out.println("WARNING: This backup command should not be used on active data set,");
        out.println("as it makes no provisions that ensure data consistency during the backup.");
        out.println("Please see the documentation for more detailed information.");
        out.println();
        out.println("RESTORE CACHE 'cache-name' [FROM] [ FILE ] 'filename'");
        out.println("Restore the cache named 'cache-name' from the file named 'filename'.");
        out.println("WARNING: This restore command should not be used on active data set,");
        out.println("as it makes no provisions that ensure data consistency during the restore.");
        out.println("Please see the documentation for more detailed information.");
        out.println();
        out.println("INSERT INTO 'cache-name' [KEY (literal | new java-constructor | static method) ] VALUE (literal |  new java-constructor | static method)");
        out.println("Insert into the cache named 'cache-name a new key value pair.");
        out.println("If the KEY part is ommited then getKey() will be sent to the VALUE object.");
        out.println();
        out.println("DELETE FROM 'cache-name'[[AS] alias] [WHERE conditional-expression]");
        out.println("Delete the entries from the cache 'cache-name' that match the conditional-expression.");
        out.println("If no conditional-expression is given all entries will be deleted! Use with Care!");
        out.println();
        out.println("UPDATE 'cache-name' [[AS] alias] SET update-statement {, update-statement}* [WHERE conditional-expression]");
        out.println("Update the cache named 'cache-name that are selected by the given conditional-expression");
        out.println("If no conditional-expression is given all entries will be updated! Use with Care!");
        out.println("Assignment of both simple values and java constructors and static methods are supported.");
        out.println("Simple addition and multiplication is supported as well.");
        out.println("example: update 'employees' set salary = 1000, vacation = 200 where grade > 7");
        out.println();
        out.println("SELECT result-set | * FROM 'cache-name' [[AS] alias] [WHERE conditional-expression]");
        out.println("Select an ordered list of properties from the cache named 'cache-name' selected by the conditional-expression.");
        out.println("If '*' is used then fetch the entire object.");
        out.println("If no conditional-expression is given all elements are selected so this is not suggested for large data sets!");
        out.println();
        out.println("SELECT aggregators FROM 'cache-name' [[AS] alias] [WHERE conditional-expression]");
        out.println("Select an ordered list of aggregators from the cache named 'cache-name' selected by the conditional-expression.");
        out.println("The aggregators may be MAX, MIN, AVG, SUM, COUNT, LONG_MAX, LONG_MIN, LONG_SUM.");
        out.println("If no conditional-expression is given all elements are selected.");
        out.println();
        out.println("SELECT (properties then aggregators) FROM 'cache-name' [[AS] alias] [WHERE conditional-expression ] GROUP [BY] properties");
        out.println("Select an ordered list of properties aggregators from the cache named 'cache-name' selected by the conditional-expression and");
        out.println("grouped by the set of properties that preceeds the aggregators.");
        out.println("example: select supplier,sum(amount),avg(price) from 'orders' group by supplier");
        out.println("As usual, if no conditional-expression is given all elements are selected.");
        out.println();
        out.println("SOURCE FROM [FILE] 'filename'");
        out.println("Read and process a file of commands form the file named 'file-name. Each statment must end with a ';'.");
        out.println("The characters '@' may be used as an alias for SOURCE FROM [FILE] as in @ 'filename'.");
        out.println("Source files may SOURCE other files.");
        out.println("At the command line only you may also use '.' as an abbreviation for '@' but do not put quotes around the filename since '.' is processed specially before the line executed.");
        out.println();
        out.println();
        out.println("For WHERE clauses the curently Supported conditionals are:\nComparison operators: =, >, >=, <, <=, <>, [ NOT ] BETWEEN, [ NOT ] LIKE,\n[ NOT ] IN, IS [ NOT ] NULL , CONTAINS [ ALL | ANY ]\n*\nLogical operators: (AND, OR, NOT)\nLiteral numbers, and the constants true, false, and null\n\nArguments to operators are properties and converted to Bean style getters and\nthe \".\" operator may be used to make chains of calls. The optional alias may be prependedonto the beginning of these path expressions.The Pseudo functions\n key(), and value() may be used to specify the use of a key as in\n\"key() between 10 and 50\".  The value() pseudo function is shorthand for the entire elementas is the alias. The key() pseudo function my be specified as key(alias) for compatibility with JPQL");
    }

    protected boolean evalLine(String line, PrintWriter out) {
        block18: {
            if (line == null || line.length() == 0) {
                return true;
            }
            try {
                if (line.equals("quit") || line.equals("bye")) {
                    return false;
                }
                if (line.equals("help")) {
                    this.showHelp(out);
                    return true;
                }
                if (line.equals("commands")) {
                    this.showCommands(out);
                    return true;
                }
                if (line.equals("services info")) {
                    Cluster cluster = CacheFactory.ensureCluster();
                    Enumeration e = cluster.getServiceNames();
                    while (e.hasMoreElements()) {
                        String serviceName = (String)e.nextElement();
                        Service serv = cluster.getService(serviceName);
                        if (!(serv instanceof DistributedCacheService)) continue;
                        DistributedCacheService dcs = (DistributedCacheService)serv;
                        Enumeration e2 = dcs.getCacheNames();
                        out.println(serviceName);
                        while (e2.hasMoreElements()) {
                            String cacheName = (String)e2.nextElement();
                            out.println("\t" + cacheName);
                        }
                    }
                    return true;
                }
                if (line.equals("trace on")) {
                    this.m_fTraceing = true;
                    return true;
                }
                if (line.equals("trace off")) {
                    this.m_fTraceing = false;
                    return true;
                }
                if (line.equals("validate name on")) {
                    this.m_fValidateCache = true;
                    return true;
                }
                if (line.equals("validate name off")) {
                    this.m_fValidateCache = false;
                    return true;
                }
                if (line.equals("sanity check on")) {
                    this.m_fsanity = true;
                    return true;
                }
                if (line.equals("sanity check off")) {
                    this.m_fsanity = false;
                    return true;
                }
                if (line.equals("extended language on")) {
                    this.m_fExtendedLanguage = true;
                    return true;
                }
                if (line.equals("extended language off")) {
                    this.m_fExtendedLanguage = false;
                    return true;
                }
                if (line.startsWith(".")) {
                    String ln = line.substring(1).trim();
                    line = "@ \"" + ln + "\"";
                }
                Object results = this.query(line, out, this.m_fTraceing, this.m_fValidateCache, this.m_fsanity);
                this.printResults(out, results);
                out.flush();
            }
            catch (Exception e) {
                out.flush();
                System.err.println("\n" + e);
                if (!this.m_fTraceing) break block18;
                e.printStackTrace();
            }
        }
        return true;
    }

    public static void printObject(PrintWriter out, Object o, boolean printNewLine) {
        QueryPlus.printObject(out, o, printNewLine, false);
    }

    public static void printObject(PrintWriter out, Object o, boolean printNewLine, boolean topObject) {
        out.flush();
        if (o instanceof Object[]) {
            Object[] tuple = (Object[])o;
            out.print("[");
            for (int i = 0; i < tuple.length; ++i) {
                QueryPlus.printStringOrObject(out, tuple[i]);
                if (i >= tuple.length - 1) continue;
                out.print(", ");
            }
            out.print("]");
        } else if (o instanceof List) {
            List tuple = (List)o;
            if (!topObject) {
                out.print("[");
            }
            for (int i = 0; i < tuple.size(); ++i) {
                QueryPlus.printStringOrObject(out, tuple.get(i));
                if (i >= tuple.size() - 1) continue;
                out.print(", ");
            }
            if (!topObject) {
                out.print("]");
            }
        } else if (o instanceof Map) {
            Set s = ((Map)o).entrySet();
            boolean first = true;
            out.print("{");
            Iterator iter = s.iterator();
            while (iter.hasNext()) {
                if (!first) {
                    out.print(", ");
                }
                first = false;
                Map.Entry me = iter.next();
                QueryPlus.printObject(out, me.getKey(), false);
                out.print(": ");
                QueryPlus.printStringOrObject(out, me.getValue());
            }
            out.print("}");
        } else if (o instanceof Set) {
            Set s = (Set)o;
            boolean first = true;
            out.print("{");
            Iterator iter = s.iterator();
            while (iter.hasNext()) {
                if (!first) {
                    out.print(", ");
                }
                first = false;
                QueryPlus.printStringOrObject(out, iter.next());
            }
            out.print("}");
        } else {
            out.print(o);
        }
        if (printNewLine) {
            out.println();
        }
    }

    public static void printStringOrObject(PrintWriter out, Object o) {
        if (o instanceof String) {
            out.print("\"" + o + "\"");
        } else {
            QueryPlus.printObject(out, o, false, false);
        }
    }

    public static void printResultsList(PrintWriter out, List setResults) {
        if (setResults == null) {
            return;
        }
        Iterator iter = setResults.iterator();
        while (iter.hasNext()) {
            QueryPlus.printObject(out, iter.next(), true, false);
        }
    }

    public static void printResultsLiteSet(PrintWriter out, LiteSet setResults) {
        if (setResults == null) {
            return;
        }
        Iterator iter = setResults.iterator();
        while (iter.hasNext()) {
            QueryPlus.printObject(out, iter.next(), true, false);
        }
    }

    public static void printResultsSet(PrintWriter out, Set setResults, boolean showkey) {
        for (Map.Entry me : setResults) {
            if (showkey) {
                QueryPlus.printObject(out, me.getKey(), false);
                out.print(": ");
            }
            QueryPlus.printObject(out, me.getValue(), true, false);
        }
    }

    public static void printResultsLiteMap(PrintWriter out, Set setResults, boolean showkey) {
        for (Map.Entry me : setResults) {
            if (showkey) {
                QueryPlus.printObject(out, me.getKey(), false);
                out.print(": ");
            }
            QueryPlus.printObject(out, me.getValue(), true, true);
        }
    }

    public void printResults(PrintWriter out, Object result) {
        boolean fShowKeys;
        if (result == null) {
            return;
        }
        boolean bl = fShowKeys = this.m_lastQuery.getFunction() != 2;
        if (this.m_sTitle != null) {
            out.println(this.m_sTitle);
        }
        if (result instanceof List) {
            QueryPlus.printResultsList(out, (List)result);
            return;
        }
        if (result instanceof LiteMap) {
            QueryPlus.printResultsLiteMap(out, ((Map)result).entrySet(), fShowKeys);
            return;
        }
        if (result instanceof Map) {
            QueryPlus.printResultsSet(out, ((Map)result).entrySet(), fShowKeys);
            return;
        }
        if (result instanceof LiteSet) {
            QueryPlus.printResultsLiteSet(out, (LiteSet)result);
            return;
        }
        if (result instanceof Set) {
            QueryPlus.printResultsSet(out, (Set)result, false);
            return;
        }
        out.println(result);
    }

    public static Object getJlineReader() {
        try {
            Class<?> clzJLine = Class.forName("jline.ConsoleReader");
            Object reader = clzJLine.newInstance();
            try {
                File fileHistory = new File(".cohql-history");
                Class<?> clzHistory = Class.forName("jline.History");
                Object history = ClassHelper.newInstance(clzHistory, new Object[]{fileHistory});
                ClassHelper.invoke(reader, "setHistory", new Object[]{history});
            }
            catch (Exception exception) {
                // empty catch block
            }
            return reader;
        }
        catch (Exception e) {
            System.out.println("jline library cannot be loaded, so you cannot use the arrow keys for line editing and history.");
            return null;
        }
    }

    public static void main(String[] args) {
        PrintWriter out = new PrintWriter(System.out);
        QueryPlus commandProcessor = new QueryPlus();
        commandProcessor.setTitle("Results");
        boolean fTrace = false;
        boolean fCmds = false;
        boolean fsilent = false;
        if (args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                if (arg.equals("-e") || arg.equals("-extended")) {
                    boolean fExtendedLanguage = true;
                    commandProcessor.setExtendedLanguage(fExtendedLanguage);
                    continue;
                }
                if (arg.equals("-t") || arg.equals("-trace")) {
                    fTrace = true;
                    continue;
                }
                if (arg.equals("-c")) {
                    fCmds = true;
                    continue;
                }
                if (arg.equals("-l")) {
                    if (i + 1 >= args.length) continue;
                    String line = args[++i];
                    commandProcessor.evalLine(line, out);
                    out.flush();
                    continue;
                }
                if (arg.equals("-s")) {
                    commandProcessor.setTitle(null);
                    fsilent = true;
                    continue;
                }
                if (!arg.equals("-f") || i + 1 >= args.length) continue;
                String fName = args[++i];
                if (fTrace) {
                    out.println("processing: " + arg);
                }
                try {
                    if (arg.length() <= 0) continue;
                    commandProcessor.processFile(fName, out, fTrace, false, false);
                    continue;
                }
                catch (Exception e) {
                    out.flush();
                    System.err.println("\n" + e + "\n");
                    if (!fTrace) break;
                    e.printStackTrace();
                    break;
                }
            }
            out.flush();
            if (fCmds) {
                return;
            }
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        if (fsilent) {
            commandProcessor.processStdin(out, in);
            return;
        }
        System.out.println("Coherence Command Line Tool");
        commandProcessor.setTitle("Results");
        Object reader = QueryPlus.getJlineReader();
        if (reader == null) {
            commandProcessor.simpleREPL(out, in);
        } else {
            commandProcessor.jlineREPL(out, reader);
        }
    }
}

