/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.transaction.internal.component;

import com.tangosol.coherence.transaction.internal.Message;
import com.tangosol.coherence.transaction.internal.component.AbstractStorageCommit;
import com.tangosol.coherence.transaction.internal.operation.Operation;
import com.tangosol.coherence.transaction.internal.storage.LocalMemberState;
import com.tangosol.coherence.transaction.internal.storage.LocalPartitionState;
import com.tangosol.coherence.transaction.internal.storage.SyntheticKey;
import com.tangosol.coherence.transaction.internal.storage.TableInfoImpl;
import com.tangosol.coherence.transaction.internal.storage.VersionDependencyManager;
import com.tangosol.coherence.transaction.internal.storage.XidSyntheticKey;
import java.util.Map;
import java.util.Set;

public class StorageCommit
extends AbstractStorageCommit {
    @Override
    public Message invoke(Message msg) {
        Operation op = msg.getOperation();
        Set entries = (Set)msg.getContext();
        Long ver = (Long)msg.getBinding("partition-commit-version");
        LocalMemberState lms = LocalMemberState.getMemberState(op.getServiceName());
        VersionDependencyManager dependencyManager = null;
        for (Object oEntry : entries) {
            Map.Entry entry = (Map.Entry)oEntry;
            XidSyntheticKey key = (XidSyntheticKey)entry.getKey();
            if (dependencyManager == null) {
                LocalPartitionState lps = lms.getLocalPartitionState(SyntheticKey.getPartition(key.getKey()));
                dependencyManager = lps.getDependencyManager();
            }
            TableInfoImpl tableInfo = new TableInfoImpl(op.getTableName(), op.getServiceName());
            this.commit(tableInfo, key, ver);
            entry.setValue(ver);
        }
        if (dependencyManager != null) {
            dependencyManager.commitVersionDependency(op.getXid(), ver);
        }
        return msg;
    }
}

