/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.transaction.internal.component;

import com.tangosol.coherence.transaction.TransactionId;
import com.tangosol.coherence.transaction.internal.Message;
import com.tangosol.coherence.transaction.internal.Results;
import com.tangosol.coherence.transaction.internal.component.Component;
import com.tangosol.coherence.transaction.internal.operation.Operation;
import com.tangosol.coherence.transaction.internal.storage.LocalMemberState;
import com.tangosol.coherence.transaction.internal.storage.LocalPartitionState;
import com.tangosol.coherence.transaction.internal.storage.Storage;
import com.tangosol.coherence.transaction.internal.storage.StorageImpl;
import com.tangosol.coherence.transaction.internal.storage.SyntheticKey;
import com.tangosol.coherence.transaction.internal.storage.TableInfo;
import com.tangosol.coherence.transaction.internal.storage.TableInfoImpl;
import com.tangosol.coherence.transaction.internal.storage.XidSyntheticKey;
import com.tangosol.util.InvocableMap;
import java.util.Map;
import java.util.Set;

public class StorageFetch
implements Component {
    private Storage m_storage = new StorageImpl();
    private static final long DEFAULT_READ_VERSION = Long.MAX_VALUE;

    @Override
    public Message invoke(Message msg) {
        Operation op = msg.getOperation();
        String sService = op.getServiceName();
        TransactionId xid = op.getXid();
        Set entries = (Set)msg.getContext();
        Results results = msg.getResults();
        Object version = msg.getBinding("version");
        TableInfoImpl tableInfo = new TableInfoImpl(op.getTableName(), sService);
        long lVersion = version == null ? Long.MAX_VALUE : (Long)version;
        for (InvocableMap.Entry entry : entries) {
            Results res = (Results)this.read(tableInfo, entry, xid, lVersion);
            results = res.combine(results);
        }
        msg.setResults(results);
        return msg;
    }

    private Object read(TableInfo tableInfo, Map.Entry entry, TransactionId xid, long lVersion) {
        Object value;
        SyntheticKey syntheticKey = (SyntheticKey)entry.getValue();
        Results results = new Results();
        if (syntheticKey != null && !Storage.NIL.equals(value = this.getValue(tableInfo, xid, syntheticKey, lVersion))) {
            results.addClientData(entry.getKey(), value);
        }
        return results;
    }

    private Object getValue(TableInfo tableInfo, TransactionId xid, SyntheticKey syntheticKey, long lVersion) {
        XidSyntheticKey versionedKey = this.getVersionedKey(xid, syntheticKey);
        Object value = this.m_storage.read(tableInfo, versionedKey);
        if (value == null && !this.m_storage.contains(tableInfo, versionedKey)) {
            value = Storage.NIL;
            TransactionId currentXid = this.getXid(tableInfo, syntheticKey, lVersion);
            if (currentXid != null) {
                versionedKey = this.getVersionedKey(currentXid, syntheticKey);
                value = this.m_storage.read(tableInfo, versionedKey);
            }
        }
        return value;
    }

    protected XidSyntheticKey getVersionedKey(TransactionId xid, SyntheticKey syntheticKey) {
        return new XidSyntheticKey(syntheticKey, xid);
    }

    protected TransactionId getXid(TableInfo tableInfo, SyntheticKey syntheticKey, long lVersion) {
        int iPartition = syntheticKey.getPartition();
        LocalPartitionState lps = LocalMemberState.getMemberState(tableInfo.getServiceName()).getLocalPartitionState(iPartition);
        return lps.ensureVersionIndex(tableInfo.getTableName()).getXid(syntheticKey, lVersion);
    }
}

