/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io;

import com.oracle.common.io.BufferManager;
import com.oracle.common.io.BufferSequence;
import com.oracle.common.io.Buffers;
import com.oracle.common.io.MultiBufferSequence;
import com.oracle.common.io.SingleBufferSequence;
import com.tangosol.io.MultiBufferWriteBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.io.nio.ByteBufferWriteBuffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class BufferManagerAdapter
implements MultiBufferWriteBuffer.WriteBufferPool {
    private BufferManager m_mgr;
    protected ByteBuffer m_buffer;
    private List<ByteBuffer> m_listBuffers = null;

    public BufferManagerAdapter(BufferManager mgr) {
        this.m_mgr = mgr;
    }

    @Override
    public int getMaximumCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public WriteBuffer allocate(int cbPreviousTotal) {
        ByteBuffer bufNew = this.m_mgr.acquireSum(cbPreviousTotal);
        ByteBuffer bufLast = this.m_buffer;
        if (bufLast != null) {
            List<ByteBuffer> listBuffers = this.m_listBuffers;
            if (listBuffers == null) {
                listBuffers = this.m_listBuffers = new ArrayList<ByteBuffer>();
            }
            bufLast.flip();
            listBuffers.add(bufLast);
        }
        this.m_buffer = bufNew;
        return new ByteBufferWriteBuffer(bufNew);
    }

    @Override
    public void release(WriteBuffer buffer) {
        throw new IllegalStateException();
    }

    public BufferSequence toBufferSequence() {
        List<ByteBuffer> listBuffers = this.m_listBuffers;
        BufferManager manager = this.m_mgr;
        ByteBuffer bufLast = this.m_buffer;
        if (listBuffers == null) {
            if (bufLast == null || bufLast.position() == 0) {
                if (bufLast != null) {
                    manager.release(bufLast);
                }
                return Buffers.getEmptyBufferSequence();
            }
            bufLast.flip();
            return new SingleBufferSequence(manager, manager.truncate(bufLast));
        }
        bufLast.flip();
        listBuffers.add(manager.truncate(bufLast));
        return new MultiBufferSequence(manager, listBuffers.toArray(new ByteBuffer[listBuffers.size()]));
    }
}

