/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.journal;

import com.tangosol.io.BinaryStore;
import com.tangosol.io.journal.Journal;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryRadixTree;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class JournalBinaryStore
implements BinaryStore.SizeAware,
Journal.JournalConsumer {
    protected Journal m_journal;
    protected BinaryRadixTree m_treeTickets = new BinaryRadixTree();
    protected final AtomicLong m_cbTotal = new AtomicLong();
    protected final ReentrantReadWriteLock m_lock = new ReentrantReadWriteLock();
    protected final Lock m_lockShared = this.m_lock.readLock();
    protected final Lock m_lockExclusive = this.m_lock.writeLock();

    public JournalBinaryStore(Journal journal) {
        assert (journal != null);
        this.m_journal = journal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Binary load(Binary binKey) {
        int cTries = 0;
        while (true) {
            long lTicket;
            BinaryRadixTree tree = this.getTicketTree();
            Lock lock = this.m_lockShared;
            lock.lock();
            try {
                lTicket = tree.get(binKey);
            }
            finally {
                lock.unlock();
            }
            if (lTicket == 0L) {
                return null;
            }
            try {
                return this.m_journal.read(lTicket);
            }
            catch (IllegalStateException e) {
                if (++cTries < 2) continue;
                throw e;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(Binary binKey, Binary binValue) {
        long lTicketOld;
        assert (binKey != null);
        assert (binValue != null);
        Journal journal = this.m_journal;
        BinaryRadixTree tree = this.getTicketTree();
        long lTicketNew = journal.write(binValue);
        Lock lock = this.m_lockExclusive;
        lock.lock();
        try {
            lTicketOld = tree.get(binKey);
            tree.put(binKey, lTicketNew);
        }
        finally {
            lock.unlock();
        }
        int cb = binValue.length();
        if (lTicketOld != 0L) {
            cb -= journal.release(lTicketOld);
        }
        if (cb != 0) {
            this.m_cbTotal.getAndAdd(cb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void erase(Binary binKey) {
        boolean fRemoved;
        long lTicket;
        Journal journal = this.m_journal;
        BinaryRadixTree tree = this.getTicketTree();
        Lock lock = this.m_lockExclusive;
        lock.lock();
        try {
            lTicket = tree.get(binKey);
            fRemoved = lTicket != 0L;
            if (fRemoved) {
                tree.remove(binKey);
            }
        }
        finally {
            lock.unlock();
        }
        if (fRemoved) {
            this.m_cbTotal.getAndAdd(-journal.release(lTicket));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void eraseAll() {
        Journal journal = this.m_journal;
        BinaryRadixTree tree = this.getTicketTree();
        long cbErased = 0L;
        Lock lock = this.m_lockExclusive;
        lock.lock();
        try {
            Iterator<Binary> iter = tree.keys();
            while (iter.hasNext()) {
                cbErased += (long)journal.release(tree.get(iter.next()));
            }
            tree.clear();
        }
        finally {
            lock.unlock();
        }
        this.m_cbTotal.getAndAdd(-cbErased);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator keys() {
        BinaryRadixTree tree = this.getTicketTree();
        Lock lock = this.m_lockShared;
        lock.lock();
        try {
            Iterator<Binary> iterator = tree.keys();
            return iterator;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        BinaryRadixTree tree = this.getTicketTree();
        Lock lock = this.m_lockShared;
        lock.lock();
        try {
            int n = tree.size();
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evacuate(long lTicketMask, long lTicketValue) {
        long lTicketOld;
        Iterator<Binary> iter;
        Journal journal = this.m_journal;
        BinaryRadixTree tree = this.m_treeTickets;
        if (tree == null) {
            return;
        }
        Lock lock = this.m_lockShared;
        lock.lock();
        try {
            iter = tree.findAll(lTicketMask, lTicketValue);
        }
        finally {
            lock.unlock();
        }
        if (!iter.hasNext()) {
            return;
        }
        Binary binKey = iter.next();
        long lTicketNew = 0L;
        lock.lock();
        try {
            lTicketOld = tree.get(binKey);
        }
        finally {
            lock.unlock();
        }
        boolean fMore = true;
        do {
            boolean fReplace;
            if (fReplace = lTicketOld != 0L && (lTicketOld & lTicketMask) == lTicketValue) {
                lTicketNew = journal.write(journal.read(lTicketOld));
            }
            lock.lock();
            try {
                if (fReplace) {
                    if (tree.replace(binKey, lTicketOld, lTicketNew)) {
                        journal.release(lTicketOld);
                    } else {
                        journal.release(lTicketNew);
                    }
                }
                if (iter.hasNext()) {
                    binKey = iter.next();
                    lTicketOld = tree.get(binKey);
                    continue;
                }
                fMore = false;
            }
            finally {
                lock.unlock();
            }
        } while (fMore);
    }

    @Override
    public void dedupe(byte[][] aab) {
        BinaryRadixTree tree = this.m_treeTickets;
        if (tree != null) {
            tree.internKeys(aab);
        }
    }

    @Override
    public String getDescription() {
        return "KeyCount=" + this.getKeyCount() + ", ByteCount=" + this.getByteCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        BinaryRadixTree tree = this.m_treeTickets;
        if (tree != null) {
            Journal journal;
            Lock lock = this.m_lockExclusive;
            lock.lock();
            try {
                journal = this.m_journal;
                if (journal != null) {
                    this.m_journal = null;
                    this.m_treeTickets = null;
                    Iterator<Binary> iter = tree.keys();
                    while (iter.hasNext()) {
                        journal.release(tree.get(iter.next()));
                    }
                    tree.clear();
                }
            }
            finally {
                lock.unlock();
            }
            if (journal != null) {
                journal.dispose();
            }
        }
    }

    public void close() {
        this.dispose();
    }

    public String toString() {
        return "JournalBinaryStore{" + this.getDescription() + ", Journal=" + this.m_journal + "}";
    }

    public Journal getJournal() {
        return this.m_journal;
    }

    public int getKeyCount() {
        return this.size();
    }

    public long getByteCount() {
        return this.m_cbTotal.longValue();
    }

    protected BinaryRadixTree getTicketTree() {
        BinaryRadixTree tree = this.m_treeTickets;
        if (tree == null) {
            throw new IllegalStateException("JournalBinaryStore has been disposed");
        }
        return tree;
    }
}

