/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net;

import com.tangosol.net.AddressProvider;
import com.tangosol.net.InetAddressHelper;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.util.Base;
import com.tangosol.util.HashHelper;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ConfigurableAddressProvider
extends AbstractSet
implements AddressProvider {
    protected List m_listHolders;
    protected int m_iLast = -1;
    protected boolean m_fSafe;

    public ConfigurableAddressProvider(XmlElement xmlConfig) {
        this(xmlConfig, true);
    }

    public ConfigurableAddressProvider(XmlElement xmlConfig, boolean fSafe) {
        this.configure(xmlConfig);
        this.m_fSafe = fSafe;
    }

    @Override
    public InetSocketAddress getNextAddress() {
        int iLast;
        List list = this.m_listHolders;
        int cItems = list.size();
        boolean fSafe = this.m_fSafe;
        if (cItems == 0) {
            return null;
        }
        int iStart = iLast = (this.m_iLast + 1) % cItems;
        AddressHolder holder = (AddressHolder)list.get(iLast);
        if (holder.isPending()) {
            this.reset();
            return null;
        }
        InetSocketAddress address = holder.getAddress();
        while (fSafe && address.isUnresolved()) {
            if (!holder.isReported()) {
                holder.setReported(true);
                Base.log("The ConfigurableAddressProvider is skipping the unresolveable address \"" + address + "\".");
            }
            iLast = (iLast + 1) % cItems;
            holder = (AddressHolder)list.get(iLast);
            address = holder.getAddress();
            if (iLast != iStart && !holder.isPending()) continue;
            this.reset();
            return null;
        }
        this.m_iLast = iLast;
        holder.setPending(true);
        return address;
    }

    @Override
    public void accept() {
        this.reset(this.m_iLast);
    }

    @Override
    public void reject(Throwable eCause) {
    }

    @Override
    public int size() {
        return this.m_listHolders.size();
    }

    @Override
    public Iterator iterator() {
        return new Iterator(){
            private Iterator m_iterHolder;
            {
                this.m_iterHolder = ConfigurableAddressProvider.this.m_listHolders.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.m_iterHolder.hasNext();
            }

            public Object next() {
                return ((AddressHolder)this.m_iterHolder.next()).getAddress();
            }

            @Override
            public void remove() {
                this.m_iterHolder.remove();
            }
        };
    }

    protected void reset() {
        this.reset(-1);
    }

    protected void reset(int iLast) {
        List list = this.m_listHolders;
        int c = list.size();
        for (int i = 0; i < c; ++i) {
            ((AddressHolder)list.get(i)).setPending(false);
        }
        this.m_iLast = iLast;
    }

    protected void configure(XmlElement xmlConfig) {
        ArrayList<AddressHolder> list = new ArrayList<AddressHolder>();
        Iterator iter = xmlConfig.getElements("socket-address");
        while (iter.hasNext()) {
            XmlElement xmlTuple = (XmlElement)iter.next();
            XmlElement xmlAddr = xmlTuple.getElement("address");
            XmlElement xmlPort = xmlTuple.getElement("port");
            if (xmlAddr == null || xmlPort == null) continue;
            String sAddr = xmlAddr.getString();
            int nPort = xmlPort.getInt();
            if (sAddr.length() == 0 || nPort == 0) continue;
            try {
                list.add(new AddressHolder(sAddr, nPort));
            }
            catch (RuntimeException e) {
                throw Base.ensureRuntimeException(e, "Invalid configuration element: " + xmlTuple);
            }
        }
        this.m_listHolders = this.sortHolders(list);
    }

    protected List sortHolders(List list) {
        return Base.randomize(list);
    }

    public static AddressProvider createAddressProvider(XmlElement xmlConfig, ClassLoader loader) {
        XmlElement xmlProvider = xmlConfig.getElement("address-provider");
        if (xmlProvider == null) {
            return new ConfigurableAddressProvider(xmlConfig);
        }
        return (AddressProvider)XmlHelper.createInstance(xmlProvider, loader, null);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ConfigurableAddressProvider)) {
            return false;
        }
        ConfigurableAddressProvider that = (ConfigurableAddressProvider)o;
        List listThis = this.m_listHolders;
        List listThat = that.m_listHolders;
        if (listThat.size() != listThis.size()) {
            return false;
        }
        Iterator iter = listThis.iterator();
        while (iter.hasNext()) {
            if (listThat.contains(iter.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return HashHelper.hash(this.m_listHolders, 0);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer().append('[');
        Iterator iter = this.m_listHolders.iterator();
        while (iter.hasNext()) {
            AddressHolder holder = (AddressHolder)iter.next();
            InetSocketAddress addr = holder.getAddress();
            sb.append(addr.getAddress()).append(':').append(addr.getPort());
            if (!iter.hasNext()) continue;
            sb.append(',');
        }
        sb.append(']');
        return sb.toString();
    }

    protected InetSocketAddress resolveAddress(String sHost, int nPort) {
        if (sHost.equals("localhost")) {
            try {
                return new InetSocketAddress(InetAddressHelper.getLocalAddress(sHost), nPort);
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return new InetSocketAddress(sHost, nPort);
    }

    protected class AddressHolder {
        protected String m_sHost;
        protected int m_nPort;
        private boolean m_fPending;
        private boolean m_fReported;

        protected AddressHolder(String sHost, int nPort) {
            if (sHost == null) {
                throw new IllegalArgumentException("host may not be null");
            }
            if (nPort < 0 || nPort > 65535) {
                throw new IllegalArgumentException("port " + nPort + " out of range");
            }
            this.m_sHost = sHost;
            this.m_nPort = nPort;
        }

        public InetSocketAddress getAddress() {
            return ConfigurableAddressProvider.this.resolveAddress(this.m_sHost, this.m_nPort);
        }

        protected boolean isPending() {
            return this.m_fPending;
        }

        protected void setPending(boolean fPending) {
            this.m_fPending = fPending;
        }

        protected boolean isReported() {
            return this.m_fReported;
        }

        protected void setReported(boolean fReported) {
            this.m_fReported = fReported;
        }

        public boolean equals(Object o) {
            if (o instanceof AddressHolder) {
                AddressHolder that = (AddressHolder)o;
                return this.m_nPort == that.m_nPort && Base.equals(this.m_sHost, that.m_sHost);
            }
            return false;
        }

        public int hashCode() {
            return Base.hashCode(this.m_sHost) ^ this.m_nPort;
        }
    }
}

