/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net;

import com.tangosol.net.CacheFactory;
import com.tangosol.net.CacheFactoryBuilder;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.net.DefaultConfigurableCacheFactory;
import com.tangosol.net.ScopeResolver;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.LiteMap;
import com.tangosol.util.Resources;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;

public class ScopedCacheFactoryBuilder
extends Base
implements CacheFactoryBuilder {
    protected ScopeResolver m_scopeResolver;
    protected Map m_mapByLoader = new WeakHashMap();
    protected Map m_mapInternedConfig = new LiteMap();
    protected static final String URI_DEFAULT = "$Default$";

    public ScopedCacheFactoryBuilder() {
        XmlElement xmlConfig = CacheFactory.getCacheFactoryBuilderConfig();
        XmlElement xmlResolver = xmlConfig.getElement("scope-resolver");
        if (xmlResolver != null) {
            try {
                this.m_scopeResolver = (ScopeResolver)XmlHelper.createInstance(xmlResolver, this.getClass().getClassLoader(), null);
            }
            catch (Exception e) {
                throw ScopedCacheFactoryBuilder.ensureRuntimeException(e, "Could not create scope resolver");
            }
        }
    }

    public ScopedCacheFactoryBuilder(ScopeResolver resolver) {
        this.m_scopeResolver = resolver;
    }

    public ScopeResolver getScopeResolver() {
        return this.m_scopeResolver;
    }

    public void setScopeResolver(ScopeResolver scopeResolver) {
        this.m_scopeResolver = scopeResolver;
    }

    @Override
    public ConfigurableCacheFactory getConfigurableCacheFactory(ClassLoader loader) {
        return this.getFactory(URI_DEFAULT, loader);
    }

    @Override
    public ConfigurableCacheFactory getConfigurableCacheFactory(String sConfigURI, ClassLoader loader) {
        return this.getFactory(sConfigURI, loader);
    }

    @Override
    public void setCacheConfiguration(ClassLoader loader, XmlElement xmlConfig) {
        this.setCacheConfiguration(URI_DEFAULT, loader, xmlConfig);
    }

    @Override
    public synchronized void setCacheConfiguration(String sConfigURI, ClassLoader loader, XmlElement xmlConfig) {
        loader = ScopedCacheFactoryBuilder.ensureClassLoader(loader);
        ConfigurableCacheFactory ccf = this.buildFactory(xmlConfig, loader);
        this.configureScope(sConfigURI, loader, xmlConfig, ccf);
        this.ensureConfigCCFMap(loader).put(sConfigURI, ccf);
    }

    @Override
    public synchronized void releaseAll(ClassLoader loader) {
        this.m_mapByLoader.remove(ScopedCacheFactoryBuilder.ensureClassLoader(loader));
    }

    @Override
    public synchronized void release(ConfigurableCacheFactory factory) {
        Map mapByLoader = this.m_mapByLoader;
        Iterator iterMap = mapByLoader.values().iterator();
        while (iterMap.hasNext()) {
            Map mapCCF = (Map)iterMap.next();
            Iterator iterCCF = mapCCF.values().iterator();
            while (iterCCF.hasNext()) {
                if (!factory.equals(iterCCF.next())) continue;
                iterCCF.remove();
            }
            if (!mapCCF.isEmpty()) continue;
            iterMap.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ConfigurableCacheFactory getFactory(String sConfigURI, ClassLoader loader) {
        Map mapCCF = this.ensureConfigCCFMap(loader = ScopedCacheFactoryBuilder.ensureClassLoader(loader));
        ConfigurableCacheFactory ccf = (ConfigurableCacheFactory)mapCCF.get(sConfigURI);
        if (ccf == null) {
            ScopedCacheFactoryBuilder scopedCacheFactoryBuilder = this;
            synchronized (scopedCacheFactoryBuilder) {
                mapCCF = this.ensureConfigCCFMap(loader);
                ccf = (ConfigurableCacheFactory)mapCCF.get(sConfigURI);
                if (ccf == null) {
                    if (URI_DEFAULT.equals(sConfigURI)) {
                        ccf = this.getDefaultFactory(loader);
                        this.configureScope(sConfigURI, loader, ccf.getConfig(), ccf);
                    } else {
                        XmlElement xmlConfig = this.loadConfigFromURI(sConfigURI, loader);
                        if (xmlConfig != null) {
                            ccf = this.buildFactory(xmlConfig, loader);
                            this.configureScope(sConfigURI, loader, xmlConfig, ccf);
                        }
                    }
                    if (ccf == null) {
                        throw new IllegalArgumentException("Unable to create a configurable cache factory for " + sConfigURI);
                    }
                    mapCCF.put(sConfigURI, ccf);
                }
            }
        }
        return ccf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map ensureConfigCCFMap(ClassLoader loader) {
        Map mapByLoader = this.m_mapByLoader;
        Map mapCCF = (Map)mapByLoader.get(loader);
        if (mapCCF == null) {
            ScopedCacheFactoryBuilder scopedCacheFactoryBuilder = this;
            synchronized (scopedCacheFactoryBuilder) {
                mapCCF = (Map)mapByLoader.get(loader);
                if (mapCCF == null) {
                    mapCCF = new LiteMap();
                    mapByLoader.put(loader, mapCCF);
                }
            }
        }
        return mapCCF;
    }

    protected ConfigurableCacheFactory getDefaultFactory(ClassLoader loader) {
        XmlElement xmlFactory = CacheFactory.getConfigurableCacheFactoryConfig();
        try {
            ConfigurableCacheFactory ccf = (ConfigurableCacheFactory)XmlHelper.createInstance(xmlFactory, loader, null);
            if (ccf instanceof DefaultConfigurableCacheFactory) {
                DefaultConfigurableCacheFactory dccf = (DefaultConfigurableCacheFactory)ccf;
                XmlElement xml = dccf.getConfigUnsafe();
                for (Map mapCCF : this.m_mapByLoader.values()) {
                    DefaultConfigurableCacheFactory dccfOther;
                    Object ccfOther = mapCCF.get(URI_DEFAULT);
                    if (ccfOther == null || ccfOther.getClass() != ccf.getClass() || !((Object)(dccfOther = (DefaultConfigurableCacheFactory)ccfOther).getConfigUnsafe()).equals(xml)) continue;
                    return dccfOther;
                }
            }
            return ccf;
        }
        catch (Exception e) {
            throw ScopedCacheFactoryBuilder.ensureRuntimeException(e, "Failed to load the factory");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected XmlElement loadConfigFromURI(String sConfigURI, ClassLoader loader) {
        Map mapIntern = this.m_mapInternedConfig;
        URL url = Resources.findFileOrResource(sConfigURI, loader);
        XmlElement xmlConfig = (XmlElement)mapIntern.get(url);
        if (xmlConfig == null) {
            Map map = mapIntern;
            synchronized (map) {
                xmlConfig = (XmlElement)mapIntern.get(url);
                if (xmlConfig == null) {
                    xmlConfig = XmlHelper.loadXml(url);
                    mapIntern.put(url, xmlConfig);
                }
            }
        }
        return xmlConfig;
    }

    protected ConfigurableCacheFactory buildFactory(XmlElement xmlConfig, ClassLoader loader) {
        XmlElement xmlFactory = CacheFactory.getConfigurableCacheFactoryConfig();
        String sDCCF = DefaultConfigurableCacheFactory.class.getName();
        String sClass = xmlFactory.getSafeElement("class-name").getString(sDCCF);
        try {
            if (sClass.equals(sDCCF)) {
                return new DefaultConfigurableCacheFactory(xmlConfig);
            }
            ConfigurableCacheFactory ccf = (ConfigurableCacheFactory)XmlHelper.createInstance(xmlFactory, loader, null);
            ccf.setConfig(xmlConfig);
            return ccf;
        }
        catch (Exception e) {
            throw ScopedCacheFactoryBuilder.ensureRuntimeException(e, "Failed to load the factory");
        }
    }

    protected void configureScope(String sConfigURI, ClassLoader loader, XmlElement xmlConfig, ConfigurableCacheFactory ccf) {
        String sScopeName = xmlConfig.getSafeElement("scope-name").getString();
        ScopeResolver resolver = this.getScopeResolver();
        if (resolver != null) {
            sScopeName = resolver.resolveScopeName(sConfigURI, loader, sScopeName);
        }
        if (sScopeName == null || sScopeName.length() == 0) {
            return;
        }
        if (DefaultConfigurableCacheFactory.class.isAssignableFrom(ccf.getClass())) {
            ((DefaultConfigurableCacheFactory)ccf).setScopeName(sScopeName);
        } else {
            try {
                ClassHelper.invoke(ccf, "setScopeName", new Object[]{sScopeName});
            }
            catch (Exception e) {
                StringBuilder sbMsg = new StringBuilder();
                sbMsg.append("A scope name '").append(sScopeName).append("' was requested, but ").append(ccf.getClass().getName()).append(" does not extend DefaultConfigurableCacheFactory ").append(" nor does it contain setter setScopeName; ").append(" therefore the scope cannot be set");
                CacheFactory.log(sbMsg.toString(), 2);
            }
        }
    }
}

