/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.util.Base;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.SimpleEnumerator;
import com.tangosol.util.WrapperCollections;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;

public class ImmutableArrayList
extends AbstractList
implements Collection,
List,
Set,
SortedSet,
Comparable,
Cloneable,
ExternalizableLite {
    private Object[] m_ao;
    private int m_of;
    private int m_c;
    private transient Map m_mapValueIndex;

    public ImmutableArrayList(Object[] ao, int of, int c) {
        Base.azzert(ao != null);
        Base.azzert(ao.length >= of + c);
        this.m_ao = ao;
        this.m_of = of;
        this.m_c = c;
    }

    public ImmutableArrayList(Object[] ao) {
        this(ao, 0, ao == null ? 0 : ao.length);
    }

    public ImmutableArrayList(Collection collection) {
        this(collection.toArray());
    }

    public ImmutableArrayList() {
    }

    public List getList() {
        return new ListView();
    }

    public Set getSet() {
        return new SetView();
    }

    public SortedSet getSortedSet() {
        return new SortedSetView();
    }

    @Override
    public int size() {
        return this.m_c;
    }

    public Object get(int i) {
        int of = this.m_of + i;
        if (of >= this.m_c) {
            throw new IndexOutOfBoundsException(this.m_of + "+" + i + ">=" + this.m_c);
        }
        return this.m_ao[of];
    }

    @Override
    public int indexOf(Object o) {
        Map map = this.getValueIndex();
        if (map != null) {
            Integer I = (Integer)map.get(o);
            return I == null ? -1 : I;
        }
        Object[] ao = this.m_ao;
        int of = this.m_of;
        int c = this.m_c;
        for (int i = 0; i < c; ++i) {
            if (!Base.equals(ao[of + i], o)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        Map map = this.getValueIndex();
        if (map != null) {
            Integer I = (Integer)map.get(o);
            if (I == null) {
                return -1;
            }
            if (this.size() == map.size()) {
                return I;
            }
        }
        Object[] ao = this.m_ao;
        int of = this.m_of;
        for (int i = this.m_c - 1; i >= 0; --i) {
            if (!Base.equals(ao[of + i], o)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }

    @Override
    public Object[] toArray() {
        int c = this.m_c;
        Object[] ao = this.m_ao;
        if (c == ao.length) {
            return (Object[])ao.clone();
        }
        Object[] aoTemp = new Object[c];
        System.arraycopy(ao, this.m_of, aoTemp, 0, c);
        return aoTemp;
    }

    @Override
    public Object[] toArray(Object[] ao) {
        int c = this.m_c;
        if (ao == null) {
            ao = new Object[c];
        } else if (ao.length < c) {
            ao = (Object[])Array.newInstance(ao.getClass().getComponentType(), c);
        } else if (ao.length > c) {
            ao[c] = null;
        }
        System.arraycopy(this.m_ao, this.m_of, ao, 0, c);
        return ao;
    }

    @Override
    public Iterator iterator() {
        return new SimpleEnumerator(this.m_ao, this.m_of, this.m_c);
    }

    public Comparator comparator() {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                int iPos1 = ImmutableArrayList.this.indexOf(o1);
                if (iPos1 == -1) {
                    throw new IllegalArgumentException("missing element: " + o1);
                }
                int iPos2 = ImmutableArrayList.this.indexOf(o2);
                if (iPos2 == -1) {
                    throw new IllegalArgumentException("missing element: " + o2);
                }
                return iPos1 - iPos2;
            }
        };
    }

    public Object first() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.get(0);
    }

    public Object last() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.get(this.size() - 1);
    }

    public SortedSet headSet(Object toElement) {
        int iPos = this.indexOf(toElement);
        if (iPos < 0) {
            throw new IllegalArgumentException("no such element: " + toElement);
        }
        return new ImmutableArrayList(this.m_ao, this.m_of, iPos);
    }

    public SortedSet tailSet(Object fromElement) {
        int iPos = this.lastIndexOf(fromElement);
        if (iPos < 0) {
            throw new IllegalArgumentException("no such element: " + fromElement);
        }
        return new ImmutableArrayList(this.m_ao, this.m_of + iPos, this.m_c - iPos);
    }

    public SortedSet subSet(Object fromElement, Object toElement) {
        int iPosBegin = this.lastIndexOf(fromElement);
        if (iPosBegin < 0) {
            throw new IllegalArgumentException("no such element: " + fromElement);
        }
        int iPosEnd = this.indexOf(toElement);
        if (iPosEnd < 0) {
            throw new IllegalArgumentException("no such element: " + toElement);
        }
        return iPosBegin < iPosEnd ? new ImmutableArrayList(this.m_ao, this.m_of + iPosBegin, iPosEnd - iPosBegin) : new ImmutableArrayList(this.m_ao, 0, 0);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        if (this.m_c > 0) {
            throw new NotActiveException();
        }
        this.m_c = ExternalizableHelper.readInt(in);
        int c = this.m_c;
        if (c == 0) {
            this.m_ao = new Object[0];
        } else if (in.readBoolean()) {
            this.m_ao = new Object[c];
            Object[] ao = this.m_ao;
            for (int i = 0; i < c; ++i) {
                ao[i] = ExternalizableHelper.readObject(in);
            }
        } else {
            try {
                this.m_ao = (Object[])ExternalizableHelper.getObjectInput(in, null).readObject();
            }
            catch (ClassNotFoundException e) {
                throw new IOException("readObject failed: " + e + "\n" + Base.getStackTrace(e));
            }
        }
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        int i;
        int c = this.m_c;
        Object[] ao = this.m_ao;
        ExternalizableHelper.writeInt(out, c);
        if (c == 0) {
            return;
        }
        boolean fLite = true;
        int FMT_OBJ_SER = 11;
        for (i = 0; i < c; ++i) {
            if (ExternalizableHelper.getStreamFormat(ao[i]) != 11) continue;
            fLite = false;
            break;
        }
        out.writeBoolean(fLite);
        if (fLite) {
            for (i = 0; i < c; ++i) {
                ExternalizableHelper.writeObject(out, ao[i]);
            }
        } else {
            ObjectOutput outObj = ExternalizableHelper.getObjectOutput(out);
            outObj.writeObject(ao);
            outObj.close();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.m_of);
        out.writeInt(this.m_c);
        out.writeObject(this.m_ao);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.m_of = in.readInt();
        this.m_c = in.readInt();
        this.m_ao = (Object[])in.readObject();
    }

    public int compareTo(Object o) {
        int cThat;
        int ofThat;
        Object[] aoThat;
        Object[] aoThis = this.m_ao;
        int ofThis = this.m_of;
        int cThis = this.m_c;
        if (o instanceof ImmutableArrayList) {
            ImmutableArrayList that = (ImmutableArrayList)o;
            aoThat = that.m_ao;
            ofThat = that.m_of;
            cThat = that.m_c;
        } else {
            aoThat = ((Collection)o).toArray();
            ofThat = 0;
            cThat = aoThat.length;
        }
        int c = Math.min(cThis, cThat);
        for (int i = 0; i < c; ++i) {
            Object oThis = aoThis[ofThis + i];
            Object oThat = aoThat[ofThat + i];
            int iResult = oThis == null || oThat == null ? (oThis == null ? (oThat == null ? 0 : -1) : 1) : ((Comparable)oThis).compareTo(oThat);
            if (iResult == 0) continue;
            return iResult;
        }
        return cThis - cThat;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof List) {
            return super.equals(o);
        }
        if (o instanceof Collection) {
            Collection that = (Collection)o;
            return this.size() == that.size() && this.containsAll(that);
        }
        return false;
    }

    protected Map getValueIndex() {
        HashMap<Object, Integer> map = this.m_mapValueIndex;
        if (map == null) {
            Object[] ao = this.m_ao;
            int c = this.m_c;
            if (c > 32) {
                map = new HashMap<Object, Integer>(c + (c >>> 2), 1.0f);
                int of = this.m_of;
                for (int i = c - 1; i >= 0; --i) {
                    map.put(ao[of + i], Base.makeInteger(i));
                }
                this.m_mapValueIndex = map;
            }
        }
        return map;
    }

    protected class SortedSetView
    extends WrapperCollections.AbstractWrapperSortedSet {
        protected SortedSetView() {
            super(ImmutableArrayList.this);
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Set)) {
                return false;
            }
            Set setOther = (Set)o;
            return setOther.size() == this.size() && setOther.containsAll(this);
        }

        @Override
        public int hashCode() {
            int nHash = 0;
            Iterator iter = this.iterator();
            while (iter.hasNext()) {
                nHash += Base.hashCode(iter.next());
            }
            return nHash;
        }

        @Override
        public String toString() {
            return ImmutableArrayList.this.toString();
        }
    }

    protected class SetView
    extends WrapperCollections.AbstractWrapperSet {
        protected SetView() {
            super(ImmutableArrayList.this);
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Set)) {
                return false;
            }
            Set setOther = (Set)o;
            return setOther.size() == this.size() && setOther.containsAll(this);
        }

        @Override
        public int hashCode() {
            int nHash = 0;
            Iterator iter = this.iterator();
            while (iter.hasNext()) {
                nHash += Base.hashCode(iter.next());
            }
            return nHash;
        }

        @Override
        public String toString() {
            return ImmutableArrayList.this.toString();
        }
    }

    protected class ListView
    extends WrapperCollections.AbstractWrapperList {
        protected ListView() {
            super(ImmutableArrayList.this);
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof List)) {
                return false;
            }
            Iterator iterThis = this.iterator();
            Iterator iterThat = ((List)o).iterator();
            while (iterThis.hasNext() && iterThat.hasNext()) {
                if (Base.equals(iterThis.next(), iterThat.next())) continue;
                return false;
            }
            return !iterThis.hasNext() && !iterThat.hasNext();
        }

        @Override
        public int hashCode() {
            int nHash = 1;
            Iterator iter = this.iterator();
            while (iter.hasNext()) {
                nHash = 31 * nHash + Base.hashCode(iter.next());
            }
            return nHash;
        }

        @Override
        public String toString() {
            return ImmutableArrayList.this.toString();
        }
    }
}

