/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.common.internal.net.ssl;

import com.oracle.common.internal.net.WrapperSocket;
import com.oracle.common.net.SSLSocketProvider;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;

public class SSLSocket
extends WrapperSocket {
    protected final SSLSocketProvider m_provider;

    public SSLSocket(Socket socket, SSLSocketProvider provider) throws IOException {
        super(socket);
        if (provider == null) {
            throw new IllegalArgumentException();
        }
        this.m_provider = provider;
        if (socket.isConnected()) {
            this.m_delegate = this.wrapSocket(socket, false);
        }
    }

    @Override
    public synchronized void connect(SocketAddress addr, int cMillis) throws IOException {
        Socket delegate = this.m_delegate;
        delegate.connect(addr, cMillis);
        this.m_delegate = this.wrapSocket(delegate, true);
    }

    @Override
    public String toString() {
        return "SSLSocket{" + this.m_delegate + "}";
    }

    public javax.net.ssl.SSLSocket wrapSocket(Socket delegate, boolean fClientMode) throws IOException {
        try {
            String[] asCiphers;
            SSLSocketProvider provider = this.m_provider;
            SSLSocketProvider.Dependencies deps = provider.getDependencies();
            InetAddress addrConnected = delegate.getInetAddress();
            javax.net.ssl.SSLSocket sslDelegate = (javax.net.ssl.SSLSocket)deps.getSSLContext().getSocketFactory().createSocket(delegate, addrConnected.getHostName(), delegate.getPort(), true);
            sslDelegate.setUseClientMode(fClientMode);
            if (!fClientMode) {
                sslDelegate.setNeedClientAuth(deps.isClientAuthenticationRequired());
            }
            if ((asCiphers = deps.getEnabledCipherSuites()) != null) {
                sslDelegate.setEnabledCipherSuites(asCiphers);
            }
            provider.ensureSessionValidity(sslDelegate.getSession(), delegate);
            return sslDelegate;
        }
        catch (Exception e) {
            try {
                delegate.close();
            }
            catch (IOException ee) {
                // empty catch block
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new RuntimeException(e);
        }
    }
}

