/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net;

import com.oracle.common.net.exabus.Depot;
import com.oracle.common.net.exabus.MessageBus;
import com.oracle.common.net.exabus.util.SimpleDepot;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Net;
import com.tangosol.coherence.component.net.Cluster$ClusterService;
import com.tangosol.coherence.component.net.Cluster$IpMonitor;
import com.tangosol.coherence.component.net.Cluster$PacketListener1;
import com.tangosol.coherence.component.net.Cluster$PacketListener1P;
import com.tangosol.coherence.component.net.Cluster$PacketListenerN;
import com.tangosol.coherence.component.net.Cluster$PacketPublisher;
import com.tangosol.coherence.component.net.Cluster$PacketReceiver;
import com.tangosol.coherence.component.net.Cluster$PacketSpeaker;
import com.tangosol.coherence.component.net.Cluster$ShutdownHook;
import com.tangosol.coherence.component.net.Cluster$SocketManager;
import com.tangosol.coherence.component.net.Cluster$SocketManager$AcceptorChannel;
import com.tangosol.coherence.component.net.Cluster$SocketManager$MulticastUdpSocket;
import com.tangosol.coherence.component.net.Cluster$SocketManager$PreferredUnicastUdpSocket;
import com.tangosol.coherence.component.net.Cluster$SocketManager$UnicastUdpSocket;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.Member$FlowControl;
import com.tangosol.coherence.component.net.Packet;
import com.tangosol.coherence.component.net.PacketBufferPool;
import com.tangosol.coherence.component.net.Security;
import com.tangosol.coherence.component.net.ServiceInfo;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.serviceMemberSet.MasterMemberSet;
import com.tangosol.coherence.component.net.packetBufferPool.FixedPacketBufferPool;
import com.tangosol.coherence.component.net.packetBufferPool.SplitPacketBufferPool;
import com.tangosol.coherence.component.util.Queue;
import com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor.PacketPublisher$ResendQueue;
import com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor.PacketSpeaker$BundlingQueue;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$TcpRing;
import com.tangosol.internal.net.cluster.ClusterDependencies;
import com.tangosol.internal.net.cluster.DefaultClusterDependencies;
import com.tangosol.internal.net.cluster.DefaultServiceFailurePolicy;
import com.tangosol.io.MultiplexingWriteBufferPool;
import com.tangosol.io.WrapperStreamFactory;
import com.tangosol.license.LicensedObject;
import com.tangosol.license.ProcessorInfo;
import com.tangosol.net.AddressProvider;
import com.tangosol.net.CompositeAddressProvider;
import com.tangosol.net.InetAddressHelper;
import com.tangosol.net.RequestTimeoutException;
import com.tangosol.net.Service;
import com.tangosol.net.ServiceFailurePolicy;
import com.tangosol.net.SocketProvider;
import com.tangosol.net.TcpSocketProvider;
import com.tangosol.net.internal.PacketIdentifier;
import com.tangosol.net.management.Registry;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.util.Base;
import com.tangosol.util.Disposable;
import com.tangosol.util.Filter;
import com.tangosol.util.ImmutableArrayList;
import com.tangosol.util.SimpleEnumerator;
import com.tangosol.util.WrapperException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class Cluster
extends Net
implements com.tangosol.net.Cluster {
    public static final int POOL_RX_PACKETS = 8192;
    public static final int POOL_TX_PACKETS = 2048;
    public static final int STATE_EXITED = 6;
    public static final int STATE_INITIAL = 0;
    public static final int STATE_JOINING = 2;
    public static final int STATE_LEAVING = 4;
    public static final int STATE_RUNNING = 3;
    public static final int STATE_STARTING = 1;
    public static final int STATE_STOPPING = 5;
    public static final String TRANSPORT_DATAGRAM = "datagram";
    private String __m_ClusterName;
    private Cluster$ClusterService __m_ClusterService;
    private ClusterDependencies __m_Dependencies;
    private Cluster$IpMonitor __m_IpMonitor;
    private transient ConcurrentMap __m_ManagedResourceMap;
    private transient Registry __m_Management;
    private Cluster$PacketListenerN __m_MultiListener;
    private Cluster$PacketListener1 __m_PointListener;
    private Cluster$PacketListener1P __m_PreferredListener;
    private Cluster$PacketPublisher __m_Publisher;
    private Cluster$PacketReceiver __m_Receiver;
    private Cluster$PacketSpeaker __m_Speaker;
    private Throwable __m_StartException;
    private volatile int __m_State;
    private ThreadGroup __m_ThreadGroup;
    private List __m_WrapperStreamFactoryList;

    public Cluster() {
        this(null, null, true);
    }

    public Cluster(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setManagedResourceMap(new ConcurrentHashMap());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this._addChild(new Cluster$ClusterService("ClusterService", this, true), "ClusterService");
        this._addChild(new Cluster$IpMonitor("IpMonitor", this, true), "IpMonitor");
        this._addChild(new Cluster$PacketListener1("PacketListener1", this, true), "PacketListener1");
        this._addChild(new Cluster$PacketListener1P("PacketListener1P", this, true), "PacketListener1P");
        this._addChild(new Cluster$PacketListenerN("PacketListenerN", this, true), "PacketListenerN");
        this._addChild(new Cluster$PacketPublisher("PacketPublisher", this, true), "PacketPublisher");
        this._addChild(new Cluster$PacketReceiver("PacketReceiver", this, true), "PacketReceiver");
        this._addChild(new Cluster$PacketSpeaker("PacketSpeaker", this, true), "PacketSpeaker");
        this._addChild(new Cluster$ShutdownHook("ShutdownHook", this, true), "ShutdownHook");
        this._addChild(new Cluster$SocketManager("SocketManager", this, true), "SocketManager");
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    protected void applyWrapperStreamFactories(Grid service, List listNames) {
        List listFilter;
        if ((!(listNames != null) ? false : listNames.isEmpty() ^ true) && (listFilter = this.instantiateWrapperStreamFactoryList(listNames)).isEmpty() ^ true) {
            service.setWrapperStreamFactoryList(new ImmutableArrayList(listFilter));
        }
        service.setWrapperStreamFactoryAllList(this.getWrapperStreamFactoryList());
    }

    protected void bindService(Grid service) {
        String sServiceType;
        ClusterDependencies config = this.getDependencies();
        service.setCluster(this);
        service.setThreadGroup(this.getThreadGroup());
        service.setDefaultGuardTimeout(config.getGuardTimeoutMillis());
        service.setServiceFailurePolicy(config.getServiceFailurePolicy());
        service.setPacketAllocator(this.getReceiver().getPacketAllocator());
        Queue queueDatagramOut = this.getPublisher().getQueue();
        if (service instanceof Cluster$ClusterService) {
            sServiceType = "ClusterService";
            service.setSendQueue(queueDatagramOut);
        } else {
            this.getClusterService().guard(service.getGuardable());
            sServiceType = service.getServiceType();
            MessageBus bus = this.createMessageBus();
            if (bus == null) {
                service.setSendQueue(queueDatagramOut);
            } else {
                service.bindMessageBus(bus, queueDatagramOut);
                Component._trace(String.valueOf("Service ") + service.getServiceName() + " is bound to " + bus.getLocalEndPoint(), 5);
            }
        }
        this.applyWrapperStreamFactories(service, config.getServiceFilterMap().get(sServiceType));
    }

    public synchronized void configure(XmlElement xml) {
        throw new UnsupportedOperationException();
    }

    protected void configureBroadcast() {
        ClusterDependencies config = this.getDependencies();
        AddressProvider provider = config.getWellKnownAddresses();
        if (provider == null) {
            Cluster$SocketManager manager = this.getSocketManager();
            Cluster$SocketManager$UnicastUdpSocket udpsocketUnicast = manager.getUnicastUdpSocket();
            InetAddress addrInterface = config.getGroupInterface();
            if (addrInterface == null) {
                addrInterface = udpsocketUnicast.getInetAddress();
            }
            Cluster$SocketManager$MulticastUdpSocket udpsocketMulticast = manager.getMulticastUdpSocket();
            udpsocketMulticast.setInterfaceInetAddress(addrInterface);
            udpsocketMulticast.setInetAddress(config.getGroupAddress());
            udpsocketMulticast.setPort(config.getGroupPort());
            udpsocketMulticast.setTimeToLive(config.getGroupTimeToLive());
            udpsocketMulticast.setPacketLength(udpsocketUnicast.getPacketLength());
            udpsocketMulticast.setBufferSent(udpsocketUnicast.getBufferSent());
            udpsocketMulticast.setBufferReceived(udpsocketUnicast.getBufferReceived());
        } else {
            CompositeAddressProvider setBroadcast = new CompositeAddressProvider(provider);
            Cluster$ClusterService service = this.getClusterService();
            service.setBroadcastAddresses(setBroadcast);
            service.setWellKnownAddresses(provider instanceof Set ? (Set)((Object)provider) : new CompositeAddressProvider(provider));
            Cluster$PacketPublisher publisher = this.getPublisher();
            publisher.setBroadcastAddresses(setBroadcast);
            publisher.setMulticastEnabled(false);
        }
    }

    protected void configureDaemons() {
        List listFilter;
        PacketBufferPool poolRx;
        PacketBufferPool poolTx;
        ClusterDependencies config = this.getDependencies();
        Cluster$SocketManager manager = this.getSocketManager();
        ThreadGroup group = this.getThreadGroup();
        if (group == null) {
            group = new ThreadGroup(this.get_Name());
            group.setDaemon(true);
            this.setThreadGroup(group);
        }
        Cluster$ClusterService daemonClusterService = this.getClusterService();
        Cluster$IpMonitor daemonIpMonitor = this.getIpMonitor();
        daemonClusterService.setThreadGroup(group);
        daemonIpMonitor.setThreadGroup(group);
        Cluster$SocketManager$UnicastUdpSocket udpsocketUnicast = manager.getUnicastUdpSocket();
        Cluster$SocketManager$PreferredUnicastUdpSocket udpsocketUnicastPref = manager.getPreferredUnicastUdpSocket();
        Member member = daemonClusterService.instantiateMember();
        member.configure(config, udpsocketUnicast.getInetAddress(), udpsocketUnicast.getPort(), this.getCounters());
        daemonClusterService.setAnnounceMember(member);
        int cbPacket = udpsocketUnicast.getPacketLength();
        int cbPacketPref = udpsocketUnicastPref.getPacketLength();
        MasterMemberSet setMember = daemonClusterService.getClusterMemberSet();
        setMember.setMaximumPacketLength(cbPacket);
        int cHeartbeatMillis = config.getClusterHeartbeatDelayMillis();
        int cTimeoutMillis = config.getPublisherResendTimeoutMillis();
        daemonClusterService.setBroadcastRepeatMillis(config.getPublisherResendDelayMillis());
        daemonClusterService.setDeliveryTimeoutMillis(cTimeoutMillis);
        daemonClusterService.setMaximumPacketLength(cbPacket);
        daemonClusterService.setTimestampMaxVariance(config.getClusterTimestampMaxVarianceMillis());
        setMember.setRecycleMillis(cTimeoutMillis * 4);
        try {
            ClusterService$TcpRing ring = daemonClusterService.getTcpRing();
            if (config.isTcpRingEnabled()) {
                SocketProvider socketProvider = manager.getSocketProvider();
                ring.setEnabled(true);
                ring.setSocketProvider(socketProvider);
                if (socketProvider instanceof TcpSocketProvider) {
                    ring.setSelector(((TcpSocketProvider)socketProvider).openSelector());
                } else {
                    ring.setServerSocketChannel(manager.getAcceptorChannel().getChannel());
                }
            } else {
                ring.setEnabled(false);
                Component._trace(String.valueOf("TcpRing has been explicitly disabled, this is not a recommended ") + "practice and will result in a minimum death detection time of " + (long)cTimeoutMillis / 1000L + " seconds for failed processes.", 2);
                ring.setSelector(Selector.open());
            }
        }
        catch (IOException e) {
            throw Base.ensureRuntimeException(e);
        }
        boolean fIpMonitorEnabled = config.isIpMonitorEnabled();
        if (fIpMonitorEnabled) {
            daemonIpMonitor.configure(config, daemonClusterService);
            daemonIpMonitor.setWaitMillis(cHeartbeatMillis);
        } else {
            Component._trace(String.valueOf("IPMonitor has been explicitly disabled, this is not a recommended ") + "practice and will result in a minimum death detection time of " + (long)cTimeoutMillis / 1000L + " seconds for failed machines or networks.", 2);
        }
        daemonClusterService.setActionPolicy(config.getClusterActionPolicy());
        daemonClusterService.setBroadcastTimeoutMillis(config.getClusterAnnounceTimeoutMillis());
        daemonClusterService.setHeartbeatDelay(cHeartbeatMillis);
        daemonClusterService.setServiceFailurePolicy(config.getServiceFailurePolicy());
        long cGuardMillis = config.getGuardTimeoutMillis();
        daemonClusterService.setDefaultGuardTimeout(cGuardMillis);
        daemonIpMonitor.setDefaultGuardTimeout(cGuardMillis);
        if (!(cGuardMillis > (long)0) ? false : fIpMonitorEnabled) {
            daemonClusterService.guard(daemonIpMonitor.getGuardable());
            daemonIpMonitor.guard(daemonClusterService.getGuardable());
        }
        Cluster$PacketListener1 daemonPointListener = this.getPointListener();
        Cluster$PacketListener1P daemonPreferredListener = this.getPreferredListener();
        Cluster$PacketListenerN daemonMultiListener = this.getMultiListener();
        Cluster$PacketReceiver daemonReceiver = this.getReceiver();
        Cluster$PacketSpeaker daemonSpeaker = this.getSpeaker();
        Cluster$PacketPublisher daemonPublisher = this.getPublisher();
        daemonPointListener.setThreadGroup(group);
        daemonPreferredListener.setThreadGroup(group);
        daemonMultiListener.setThreadGroup(group);
        daemonReceiver.setThreadGroup(group);
        daemonSpeaker.setThreadGroup(group);
        daemonPublisher.setThreadGroup(group);
        daemonPointListener.setPriority(config.getLocalListenerPriority());
        daemonPreferredListener.setPriority(config.getLocalListenerPriority());
        daemonMultiListener.setPriority(config.getGroupListenerPriority());
        daemonReceiver.setPriority(config.getReceiverPriority());
        daemonSpeaker.setPriority(config.getSpeakerPriority());
        daemonPublisher.setPriority(config.getPublisherPriority());
        daemonIpMonitor.setPriority(config.getIpMonitorPriority());
        daemonPointListener.setMemberSet(setMember);
        daemonPreferredListener.setMemberSet(setMember);
        daemonMultiListener.setMemberSet(setMember);
        daemonReceiver.setMemberSet(setMember);
        daemonSpeaker.setMemberSet(setMember);
        daemonPublisher.setMemberSet(setMember);
        Cluster$SocketManager$MulticastUdpSocket udpsocketMulticast = manager.getMulticastUdpSocket();
        if (udpsocketMulticast.getInetAddress() == null) {
            udpsocketMulticast = null;
        }
        int cbTxBuff = config.getPublisherPacketAllocatorSize();
        int cbRxBuff = config.getReceiverPacketAllocatorSize();
        if (cbTxBuff == 0) {
            cbTxBuff = cbPacketPref * POOL_TX_PACKETS;
        }
        if (cbRxBuff == 0) {
            cbRxBuff = cbPacketPref * POOL_RX_PACKETS;
        }
        if (MultiplexingWriteBufferPool.getMaximumSegmentBufferSize(0, cbPacketPref, 0) < cbPacket) {
            SplitPacketBufferPool pool = new SplitPacketBufferPool();
            pool.setPreferredPool(new MultiplexingWriteBufferPool(1, Math.max(cbPacketPref, (cbTxBuff /= 8) * 7), cbPacketPref, 0));
            pool.setPreferredPacketLength(cbPacketPref);
            pool.setMaximumPool(new MultiplexingWriteBufferPool(1, Math.max(cbPacket, cbTxBuff), cbPacket, 0));
            pool.setMaximumPacketLength(cbPacket);
            poolTx = pool;
            pool = new SplitPacketBufferPool();
            pool.setPreferredPool(new MultiplexingWriteBufferPool(1, Math.max(cbPacketPref, (cbRxBuff /= 8) * 7), cbPacketPref, 0));
            pool.setPreferredPacketLength(cbPacketPref);
            pool.setMaximumPool(new MultiplexingWriteBufferPool(1, Math.max(cbPacket, cbRxBuff), cbPacket, 0));
            pool.setMaximumPacketLength(cbPacket);
            poolRx = pool;
        } else {
            int cbAlloc = Math.max(cbPacketPref, cbPacket);
            FixedPacketBufferPool pool = new FixedPacketBufferPool();
            pool.setPool(new MultiplexingWriteBufferPool(1, Math.max(cbAlloc, cbTxBuff), cbAlloc, 0));
            poolTx = pool;
            pool = new FixedPacketBufferPool();
            pool.setPool(new MultiplexingWriteBufferPool(1, Math.max(cbAlloc, cbRxBuff), cbAlloc, 0));
            poolRx = pool;
        }
        daemonPointListener.setUdpSocket(udpsocketUnicast);
        daemonPointListener.setReceiveQueue(daemonReceiver.getQueue());
        daemonPointListener.setPacketAllocator(poolRx);
        daemonPointListener.setPacketLength(cbPacket);
        daemonPreferredListener.setUdpSocket(udpsocketUnicastPref);
        daemonPreferredListener.setReceiveQueue(daemonReceiver.getQueue());
        daemonPreferredListener.setPacketAllocator(poolRx);
        daemonPreferredListener.setPacketLength(cbPacketPref);
        daemonMultiListener.setUdpSocket(udpsocketMulticast);
        daemonMultiListener.setReceiveQueue(daemonReceiver.getQueue());
        daemonMultiListener.setPacketAllocator(poolRx);
        daemonMultiListener.setPacketLength(cbPacket);
        daemonReceiver.setAckSendQueue(daemonPublisher.getAckQueue());
        daemonReceiver.setConfirmationQueue(daemonPublisher.getConfirmationQueue());
        daemonReceiver.setService(0, daemonClusterService);
        daemonReceiver.setPacketAllocator(poolRx);
        daemonReceiver.setMaximumPacketLength(cbPacket);
        daemonReceiver.setPreferredPacketLength(cbPacketPref);
        daemonReceiver.setNackEnabled(config.isReceiverNackEnabled());
        daemonReceiver.setPublisher(daemonPublisher);
        PacketSpeaker$BundlingQueue queueSpeaker = (PacketSpeaker$BundlingQueue)daemonSpeaker.getQueue();
        int nVolume = config.getSpeakerVolumeMinimum();
        daemonSpeaker.setPacketAllocator(poolTx);
        queueSpeaker.setVolumeTunable(nVolume < 0);
        queueSpeaker.setVolumeThreshold(nVolume < 0 ? udpsocketUnicast.getActualBufferSent() : nVolume);
        if (queueSpeaker.isBundlingEnabled()) {
            queueSpeaker.setDeferralThresholdNanos(config.getPacketBundlingThresholdNanos());
            queueSpeaker.setBundlingAggression(config.getPacketBundlingAggression());
        }
        daemonPublisher.setUdpSocketUnicast(udpsocketUnicast);
        daemonPublisher.setUdpSocketMulticast(udpsocketMulticast);
        daemonPublisher.setSendQueue(daemonSpeaker.getQueue());
        daemonPublisher.setMaximumPacketLength(cbPacket);
        daemonPublisher.setPreferredPacketLength(cbPacketPref);
        daemonPublisher.setPacketAllocator(poolTx);
        daemonPublisher.setNackEnabled(config.isReceiverNackEnabled());
        daemonPublisher.setNackDelayMillis(config.getPublisherNackDelayMillis());
        daemonPublisher.setMessageBufferAllocator(new MultiplexingWriteBufferPool(config.getMessageAllocatorSegments(), config.getMessageAllocatorSegmentSize(), config.getMessageAllocatorMinBufferSize(), config.getMessageAllocatorGrowthFactor()));
        if (config.isFlowControlEnabled()) {
            daemonPublisher.setDeferredReadyQueue(new Queue());
            Member$FlowControl.setEnabled(true);
            int iMax = config.getOutstandingPacketMaximum();
            int iMin = config.getOutstandingPacketMinimum();
            Member$FlowControl.setOutstandingPacketMaximum(iMax);
            Member$FlowControl.setOutstandingPacketMinimum(iMin);
            Member$FlowControl.setLostPacketThreshold(config.getLostPacketThreshold());
        }
        daemonPublisher.setResendDelay(config.getPublisherResendDelayMillis());
        daemonPublisher.setResendTimeout(cTimeoutMillis);
        daemonPublisher.setAckDelay(config.getPublisherAckDelayMillis());
        daemonPublisher.setCloggedCount(config.getPublisherCloggedCount());
        daemonPublisher.setCloggedDelay(config.getPublisherCloggedDelayMillis());
        daemonPublisher.setMulticastThreshold((double)config.getPublisherGroupThreshold() / 100.0);
        List<String> listFilterNames = config.getFilterList();
        if ((!(listFilterNames != null) ? false : listFilterNames.isEmpty() ^ true) && (listFilter = this.instantiateWrapperStreamFactoryList(listFilterNames)).isEmpty() ^ true) {
            this.setWrapperStreamFactoryList(new ImmutableArrayList(listFilter));
        }
    }

    protected void configureSockets() {
        int cbBufferSent;
        boolean fTcpBased;
        ClusterDependencies config = this.getDependencies();
        InetAddress addrLocal = config.getLocalAddress();
        if (InetAddressHelper.isLoopbackAddress(addrLocal)) {
            Component._trace(String.valueOf("Local address \"") + InetAddressHelper.toString(addrLocal) + "\" is a loopback address; this cluster node will not connect" + " to nodes located on different machines", 2);
        }
        Cluster$SocketManager manager = this.getSocketManager();
        try {
            SocketProvider socketProvider = config.getSocketProviderFactory().ensureProvider(config.getUnicastSocketProviderXml());
            manager.setSocketProvider(socketProvider);
            fTcpBased = socketProvider instanceof TcpSocketProvider;
        }
        catch (IOException e) {
            throw Base.ensureRuntimeException(e);
        }
        manager.setDepot(new SimpleDepot());
        int cbPacket = config.getPacketMaxLength();
        int cbPacketPref = config.getPacketPreferredLength();
        int cbHeaderSize = fTcpBased ? 68 : 48;
        if (cbPacket == 0) {
            cbPacket = 65535;
        }
        if (cbPacketPref == 0) {
            int nMTU = Math.min(65535, InetAddressHelper.getLocalMTU(addrLocal));
            if (nMTU == 0) {
                nMTU = 1500;
            }
            cbPacketPref = nMTU - cbHeaderSize;
        }
        if ((cbBufferSent = config.getPublisherSocketBufferSize()) == 0) {
            cbBufferSent = cbPacketPref < 1500 ? 32 * 1024 : (cbPacketPref < 9000 ? 256 * 1024 : 512 * 1024);
        } else if (cbBufferSent < 0) {
            cbBufferSent = -cbBufferSent * cbPacketPref;
        }
        int cBufferSentPackets = Math.max(1, cbBufferSent / cbPacket);
        int cbBufferPref = config.getLocalBufferSize();
        if (cbBufferPref == 0) {
            cbBufferPref = cbPacketPref < 1500 ? 2 * 1024 * 1024 : (cbPacketPref < 9000 ? 4 * 1024 * 1024 : 8 * 1024 * 1024);
        } else if (cbBufferPref < 0) {
            cbBufferPref = -cbBufferPref * cbPacketPref;
        }
        int cBufferPrefPackets = Math.max(1, cbBufferPref / cbPacketPref);
        int cbBufferGroup = config.getGroupBufferSize();
        if (cbBufferGroup == 0) {
            cbBufferGroup = cbPacketPref < 1500 ? 1 * 1024 * 1024 : (cbPacketPref < 9000 ? 2 * 1024 * 1024 : 4 * 1024 * 1024);
        } else if (cbBufferSent < 0) {
            cbBufferGroup = -cbBufferGroup * cbPacketPref;
        }
        int cBufferGroupPackets = Math.max(1, cbBufferGroup / cbPacket);
        Cluster$SocketManager$UnicastUdpSocket udpsocketUnicast = manager.getUnicastUdpSocket();
        Cluster$SocketManager$PreferredUnicastUdpSocket udpsocketUnicastPref = manager.getPreferredUnicastUdpSocket();
        udpsocketUnicast.setBufferSent(cBufferSentPackets);
        udpsocketUnicast.setBufferReceived(cBufferGroupPackets);
        udpsocketUnicast.setInetAddress(addrLocal);
        udpsocketUnicast.setPacketLength(cbPacket);
        udpsocketUnicastPref.setBufferReceived(cBufferPrefPackets);
        udpsocketUnicastPref.setInetAddress(addrLocal);
        udpsocketUnicastPref.setPacketLength(cbPacketPref);
        if (config.isTcpRingEnabled()) {
            Cluster$SocketManager$AcceptorChannel acceptorChannel = manager.getAcceptorChannel();
            acceptorChannel.setInetAddress(addrLocal);
            acceptorChannel.setBacklog(config.getTcpBacklog());
            try {
                this.getClusterService().getTcpRing().getSocketOptions().copyOptions(config.getTcpRingSocketOptions());
            }
            catch (IOException e) {
                throw Base.ensureRuntimeException(e);
            }
        }
    }

    protected MessageBus createMessageBus() {
        String sTransport = this.getDependencies().getReliableTransport();
        Depot depot = this.getSocketManager().getDepot();
        Member member = this.getClusterService().getThisMember();
        String sAddr = member.getAddress().getHostAddress();
        String sPort = Integer.toString(member.getPort());
        while (!((sTransport == null ? true : sTransport.isEmpty()) ? true : sTransport.equals(TRANSPORT_DATAGRAM))) {
            if (((sTransport.equals("tmb") ? true : sTransport.equals("tmbs")) ? true : sTransport.equals("sdmb")) ? true : sTransport.equals("sdmbs")) {
                sTransport = String.valueOf(sTransport) + "://{member-ip}:-1";
            } else if (sTransport.equals("imb")) {
                sTransport = String.valueOf(sTransport) + "://{member-ip}:0";
            }
            sTransport = sTransport.replace("{member-ip}", sAddr);
            sTransport = sTransport.replace("{member-port}", sPort);
            try {
                return depot.createMessageBus(depot.resolveEndPoint(sTransport));
            }
            catch (IllegalArgumentException e) {
                if (this.getDependencies().getReliableTransport() == null) {
                    if (sTransport.startsWith("imb")) {
                        sTransport = "sdmb";
                        continue;
                    }
                    if (sTransport.startsWith("sdmb")) {
                        sTransport = "tmb";
                        continue;
                    }
                    Component._trace(String.valueOf("Unable to use transport of ") + sTransport + " (" + e.getMessage() + "); falling back on default cluster transport", 5);
                    sTransport = null;
                    continue;
                }
                throw e;
            }
            break;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Service ensureService(String sName, String sType) {
        if (sName == null ? true : sName.length() == 0) {
            throw new IllegalArgumentException(String.valueOf("Invalid service name: ") + sName);
        }
        Grid service = (Grid)this.getService(sName);
        if (service == null ? true : service.isRunning() ^ true) {
            Cluster cluster = this;
            // MONITORENTER : cluster
            if (service == null) {
                service = (Grid)this.getService(sName);
            } else {
                int cTries = 10;
                while (true) {
                    Grid grid = service;
                    // MONITORENTER : grid
                    service = (Grid)this.getService(sName);
                    if (service == null ? true : service.isRunning()) {
                        Object var7_9 = null;
                        // MONITOREXIT : grid
                        break;
                    }
                    // MONITOREXIT : grid
                    if (--cTries == 0) {
                        throw new IllegalStateException(String.valueOf("Failed to unregister: ") + service);
                    }
                    Thread.yield();
                }
            }
            if (service == null) {
                String sComponent = this.getDependencies().getServiceMap().get(sType);
                if (sComponent != null) {
                    try {
                        service = (Grid)Component._newInstance(String.valueOf("Component.Util.Daemon.QueueProcessor.Service.Grid.") + sComponent);
                    }
                    catch (SecurityException e) {
                        throw Base.ensureRuntimeException(null, String.valueOf(sType) + " service: " + e.getMessage());
                    }
                }
                if (service == null) {
                    throw new IllegalArgumentException(String.valueOf("Unknown service type: ") + sType + ":" + sComponent);
                }
                service.setServiceName(sName);
                this.bindService(service);
            }
            // MONITOREXIT : cluster
        }
        if (!(service.getServiceType().equals(sType) ^ true)) return service;
        throw new IllegalArgumentException(String.valueOf("Requested service type \"") + sType + "\", but the existing service has type \"" + service.getServiceType() + '\"');
    }

    public void ensureStopped() {
        if (this.getState() != STATE_EXITED) {
            long ldtTimeout = Base.getSafeTimeMillis() + (long)(4 * this.getDependencies().getClusterHeartbeatDelayMillis());
            do {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw Base.ensureRuntimeException(e);
                }
                if (!(this.getState() == STATE_EXITED)) continue;
                return;
            } while (!(Base.getSafeTimeMillis() >= ldtTimeout));
            throw new RequestTimeoutException("Timeout while waiting for cluster to stop.");
        }
    }

    public String formatPointToPointStats() {
        MasterMemberSet members = this.getClusterService().getClusterMemberSet();
        Member memberThis = members.getThisMember();
        StringBuffer sb = new StringBuffer();
        try {
            Iterator iter = members.iterator();
            while (iter.hasNext()) {
                Member member = (Member)iter.next();
                if (!(!(member != null) ? false : member != memberThis)) continue;
                sb.append("\nMember=").append(member.getId()).append(", ").append(member.formatStats());
            }
        }
        catch (ConcurrentModificationException e) {}
        return sb.toString();
    }

    public String formatStats() {
        Cluster$IpMonitor ipMonitor;
        StringBuffer sb = new StringBuffer();
        sb.append("\nPacketPublisher: ").append(this.getPublisher().formatStats()).append("\nPacketSpeaker  : ").append(this.getSpeaker().formatStats()).append("\nPacketReceiver : ").append(this.getReceiver().formatStats());
        if (this.getDependencies().isTcpRingEnabled()) {
            sb.append("\nTcpRing        : ").append(this.getClusterService().getTcpRing().formatStats());
        }
        if ((ipMonitor = this.getIpMonitor()).isStarted()) {
            sb.append("\nIpMonitor      : ").append(ipMonitor.formatStats());
        }
        return sb.toString();
    }

    public String getClusterName() {
        return this.__m_ClusterName;
    }

    public Cluster$ClusterService getClusterService() {
        return this.__m_ClusterService;
    }

    public ClassLoader getContextClassLoader() {
        return null;
    }

    public int[] getCounters() {
        ClusterDependencies config = this.getDependencies();
        int nMachineId = config.getMemberIdentity().getMachineId();
        if (nMachineId == 0) {
            try {
                InetAddress addr = InetAddressHelper.getLocalHost();
                long lAddr = InetAddressHelper.toLong(addr);
                nMachineId = (int)((lAddr & 0xFF000000L) >>> 24 & (long)255 ^ (lAddr & 0xFF0000L) >>> 16 & (long)255 ^ (lAddr & 0xFF00L) >>> 8 & (long)255) << 8 | (int)(lAddr & 0xFFL) & 0xFF;
            }
            catch (Throwable e) {
                // empty catch block
            }
            if (nMachineId == 0) {
                nMachineId = 1;
            }
        }
        int nCpu = Runtime.getRuntime().availableProcessors();
        int[] ac = new int[]{nCpu, nCpu, nMachineId};
        LicensedObject.LicenseData[] aLicense = (LicensedObject.LicenseData[])((Cluster)this.get_Module()).getClusterService().get_Feed();
        if (!(aLicense != null) ? false : aLicense.length > 0) {
            ProcessorInfo procinfo = new ProcessorInfo(aLicense[0].uid);
            ac[0] = procinfo.getCpuCount();
            ac[1] = procinfo.getSocketCount();
        }
        return ac;
    }

    public ClusterDependencies getDependencies() {
        return this.__m_Dependencies;
    }

    public Cluster$IpMonitor getIpMonitor() {
        return this.__m_IpMonitor;
    }

    public com.tangosol.net.Member getLocalMember() {
        return this.getClusterService().getClusterMemberSet().getThisMember();
    }

    public ConcurrentMap getManagedResourceMap() {
        return this.__m_ManagedResourceMap;
    }

    public Registry getManagement() {
        return this.__m_Management;
    }

    public Set getMemberSet() {
        return this.getClusterService().getClusterMemberSet();
    }

    public Cluster$PacketListenerN getMultiListener() {
        return this.__m_MultiListener;
    }

    public com.tangosol.net.Member getOldestMember() {
        return this.getClusterService().getClusterOldestMember();
    }

    public Cluster$PacketListener1 getPointListener() {
        return this.__m_PointListener;
    }

    public Cluster$PacketListener1P getPreferredListener() {
        return this.__m_PreferredListener;
    }

    public Cluster$PacketPublisher getPublisher() {
        return this.__m_Publisher;
    }

    public Cluster$PacketReceiver getReceiver() {
        return this.__m_Receiver;
    }

    public Disposable getResource(String sName) {
        return (Disposable)this.getManagedResourceMap().get(sName);
    }

    public Service getService(String sName) {
        return this.getClusterService().getService(sName);
    }

    public com.tangosol.net.ServiceInfo getServiceInfo(String sName) {
        return this.getClusterService().getServiceInfo(sName);
    }

    public Enumeration getServiceNames() {
        ArrayList<String> list = new ArrayList<String>();
        Cluster$ClusterService service = this.getClusterService();
        int cServices = service.getServiceInfoCount();
        int i = 0;
        while (i < cServices) {
            ServiceInfo info = service.getServiceInfo(i);
            if (info != null) {
                list.add(info.getServiceName());
            }
            ++i;
        }
        return new SimpleEnumerator(list.toArray(new String[list.size()]));
    }

    public Cluster$SocketManager getSocketManager() {
        return (Cluster$SocketManager)this._findChild("SocketManager");
    }

    public Cluster$PacketSpeaker getSpeaker() {
        return this.__m_Speaker;
    }

    public Throwable getStartException() {
        return this.__m_StartException;
    }

    public int getState() {
        return this.__m_State;
    }

    public ThreadGroup getThreadGroup() {
        return this.__m_ThreadGroup;
    }

    public long getTimeMillis() {
        return this.getClusterService().getTimestamp();
    }

    public List getWrapperStreamFactoryList() {
        return this.__m_WrapperStreamFactoryList;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/Cluster".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new Cluster();
    }

    private final Component get_Module() {
        return this;
    }

    public void halt() {
        this.getPublisher().halt();
        this.getSocketManager().releaseSockets();
        this.getClusterService().getTcpRing().close();
        this.setState(STATE_STOPPING);
    }

    public ServiceFailurePolicy instantiateServiceFailurePolicy(XmlElement xmlConfig) {
        ServiceFailurePolicy policy = null;
        String sPolicy = xmlConfig.getString();
        if (sPolicy.length() != 0) {
            int nPolicyType = -1;
            if (sPolicy.equals("exit-cluster")) {
                nPolicyType = DefaultServiceFailurePolicy.POLICY_EXIT_CLUSTER;
            } else if (sPolicy.equals("exit-process")) {
                nPolicyType = DefaultServiceFailurePolicy.POLICY_EXIT_PROCESS;
            } else if (sPolicy.equals("logging")) {
                nPolicyType = DefaultServiceFailurePolicy.POLICY_LOGGING;
            } else {
                Component._trace(String.valueOf("Unknown service-failure-policy \"") + sPolicy + "\"", 3);
            }
            if (nPolicyType != -1) {
                policy = new DefaultServiceFailurePolicy(nPolicyType);
            }
        } else if (xmlConfig.getElementList().isEmpty() ^ true) {
            try {
                policy = (ServiceFailurePolicy)XmlHelper.createInstance(xmlConfig, Base.getContextClassLoader(), null);
            }
            catch (Exception e) {
                Component._trace(String.valueOf("Failed to instantiate custom ServiceFailurePolicy:") + e, 3);
            }
        }
        if (policy == null) {
            policy = this.getDependencies().getServiceFailurePolicy();
        }
        return policy;
    }

    protected List instantiateWrapperStreamFactoryList(List listNames) {
        ClusterDependencies config = this.getDependencies();
        ArrayList<WrapperStreamFactory> listFilter = new ArrayList<WrapperStreamFactory>();
        Map<String, WrapperStreamFactory> mapFilter = config.getFilterMap();
        Iterator iter = listNames.iterator();
        while (iter.hasNext()) {
            String sName = (String)iter.next();
            WrapperStreamFactory factory = mapFilter.get(sName);
            if (factory == null) {
                Component._trace(String.valueOf("Cannot find WrapperStreamFactory for filter-name: ") + sName, 1);
                continue;
            }
            listFilter.add(factory);
        }
        return listFilter;
    }

    public boolean isAuthorizedHost(InetAddress addr) {
        Filter filterHost = this.getDependencies().getAuthorizedHostFilter();
        if (filterHost == null) {
            return true;
        }
        try {
            if (filterHost.evaluate(addr)) {
                return true;
            }
        }
        catch (Throwable throwable) {}
        return false;
    }

    public boolean isCommEndangered(Member member) {
        long lTrintCutoff = this.getPublisher().getMessageOutgoing().getLastIndex() - (long)(Packet.TRINT_MAX_VARIANCE >>> 3);
        PacketIdentifier packetidTo = member.getContiguousToPacketId();
        return packetidTo == null ? true : packetidTo.getFromMessageId() < lTrintCutoff;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        while (true) {
            switch (this.getState()) {
                case 3: {
                    return true;
                }
                case 0: 
                case 4: 
                case 5: 
                case 6: {
                    return false;
                }
            }
            Cluster cluster = this;
            synchronized (cluster) {
                try {
                    this.wait(1000);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    boolean bl = this.getState() == STATE_RUNNING;
                    Object var4_5 = null;
                    return bl;
                }
            }
        }
    }

    public synchronized void onException(Throwable e) {
        int nState = this.getState();
        if (nState < STATE_RUNNING) {
            this.setStartException(e);
        }
        if (nState < STATE_STOPPING) {
            Component._trace(e, "Stopping cluster due to unhandled exception");
            this.stop();
        }
    }

    public void onInit() {
        super.onInit();
        this.setPointListener((Cluster$PacketListener1)this._findName("PacketListener1"));
        this.setPreferredListener((Cluster$PacketListener1P)this._findName("PacketListener1P"));
        this.setMultiListener((Cluster$PacketListenerN)this._findName("PacketListenerN"));
        this.setReceiver((Cluster$PacketReceiver)this._findName("PacketReceiver"));
        this.setPublisher((Cluster$PacketPublisher)this._findName("PacketPublisher"));
        this.setSpeaker((Cluster$PacketSpeaker)this._findName("PacketSpeaker"));
        this.setClusterService((Cluster$ClusterService)this._findName("ClusterService"));
        this.setIpMonitor((Cluster$IpMonitor)this._findName("IpMonitor"));
    }

    public void onMemberJoined(Member member) {
        Cluster$IpMonitor monitor = this.getIpMonitor();
        if (monitor.isStarted()) {
            monitor.onMemberJoined(member);
        }
    }

    public void onMemberLeft(Member member) {
        this.getPublisher().onMemberLeft(member);
        this.getReceiver().onMemberLeft(member);
        Cluster$IpMonitor monitor = this.getIpMonitor();
        if (monitor.isStarted()) {
            monitor.onMemberLeft(member);
        }
    }

    protected void onStart() {
        block7: {
            ClusterDependencies config = this.getDependencies();
            if (config == null) {
                throw new IllegalArgumentException("Cluster dependencies must be set!");
            }
            if (config.isTcmpEnabled() ^ true) {
                throw new UnsupportedOperationException(String.valueOf("TCMP clustering has been disabled;") + " this configuration may only access clustered services via Extend" + " proxies.");
            }
            Security.getInstance();
            this.setClusterName(config.getMemberIdentity().getClusterName());
            this.configureSockets();
            this.configureBroadcast();
            try {
                this.getSocketManager().bindSockets();
            }
            catch (IOException e) {
                throw Base.ensureRuntimeException(e);
            }
            this.configureDaemons();
            this.startDaemons();
            this.setState(STATE_JOINING);
            Cluster$ClusterService daemonClusterService = this.getClusterService();
            this.bindService(daemonClusterService);
            daemonClusterService.start();
            if (config.isIpMonitorEnabled()) {
                this.getIpMonitor().start();
            }
            this.setState(STATE_RUNNING);
            int nShutdownOption = config.getShutdownHookOption();
            if (!(nShutdownOption != ClusterDependencies.SHUTDOWN_NONE)) break block7;
            try {
                Cluster$ShutdownHook hook = (Cluster$ShutdownHook)this._findName("ShutdownHook");
                hook.setGraceful(nShutdownOption == ClusterDependencies.SHUTDOWN_GRACEFUL);
                hook.register();
            }
            catch (Throwable e) {}
        }
    }

    public void recordCommPreferences(Member member, int nPort, int cbPacket) {
        Cluster$PacketPublisher publisher = this.getPublisher();
        member.setPreferredPort(nPort);
        int cbPrefLocal = publisher.getPreferredPacketLength();
        if (cbPacket < cbPrefLocal) {
            member.setPreferredPacketLength(cbPacket);
            publisher.setHeterogeneousPacketLengths(true);
        } else {
            member.setPreferredPacketLength(cbPrefLocal);
        }
    }

    public void registerResource(String sName, Disposable disposable) {
        if (disposable == null) {
            throw new IllegalStateException("Registering a null resource is not allowed.");
        }
        Disposable disp = this.getManagedResourceMap().putIfAbsent(sName, disposable);
        if (!(disp != null) ? false : disp != disposable) {
            throw new IllegalStateException(String.valueOf("A resource for the name ") + sName + " is already registered.");
        }
    }

    public void resetPointToPointStats() {
        try {
            Iterator iter = this.getClusterService().getClusterMemberSet().iterator();
            while (iter.hasNext()) {
                Member member = (Member)iter.next();
                if (!(member != null)) continue;
                member.resetStats();
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {}
    }

    public void resetStats() {
        this.getPointListener().resetStats();
        this.getMultiListener().resetStats();
        this.getSpeaker().resetStats();
        this.getPublisher().resetStats();
        this.getReceiver().resetStats();
        this.getClusterService().getTcpRing().resetStats();
    }

    protected void setClusterName(String sClusterName) {
        Component._assert(sClusterName != null);
        if (this.getClusterService().isStarted()) {
            throw new IllegalStateException("Cluster name cannot be changed.");
        }
        this.__m_ClusterName = sClusterName;
    }

    protected void setClusterService(Cluster$ClusterService daemon) {
        this.__m_ClusterService = daemon;
    }

    public void setContextClassLoader(ClassLoader loader) {
    }

    public void setDependencies(ClusterDependencies deps) {
        if (!(this.getDependencies() == null)) {
            throw new IllegalStateException("Cluster dependencies cannot be reset");
        }
        this.__m_Dependencies = new DefaultClusterDependencies(deps).validate();
    }

    protected void setIpMonitor(Cluster$IpMonitor daemon) {
        this.__m_IpMonitor = daemon;
    }

    protected void setManagedResourceMap(ConcurrentMap map) {
        this.__m_ManagedResourceMap = map;
    }

    public void setManagement(Registry registry) {
        this.__m_Management = registry;
    }

    protected void setMultiListener(Cluster$PacketListenerN daemon) {
        this.__m_MultiListener = daemon;
    }

    protected void setPointListener(Cluster$PacketListener1 daemon) {
        this.__m_PointListener = daemon;
    }

    protected void setPreferredListener(Cluster$PacketListener1P daemon) {
        this.__m_PreferredListener = daemon;
    }

    protected void setPublisher(Cluster$PacketPublisher daemon) {
        this.__m_Publisher = daemon;
    }

    protected void setReceiver(Cluster$PacketReceiver daemon) {
        this.__m_Receiver = daemon;
    }

    protected void setSpeaker(Cluster$PacketSpeaker daemon) {
        this.__m_Speaker = daemon;
    }

    public void setStartException(Throwable e) {
        if (this.getStartException() == null) {
            this.__m_StartException = e;
        }
    }

    protected synchronized void setState(int nState) {
        this.__m_State = nState;
        this.notifyAll();
    }

    protected void setThreadGroup(ThreadGroup threadgroup) {
        Component._assert(this.getState() < STATE_RUNNING);
        this.__m_ThreadGroup = threadgroup;
    }

    protected void setWrapperStreamFactoryList(List list) {
        this.__m_WrapperStreamFactoryList = list;
    }

    public synchronized void shutdown() {
        switch (this.getState()) {
            case 0: {
                this.setState(STATE_EXITED);
                break;
            }
            case 1: 
            case 2: {
                this.start();
            }
            case 3: {
                try {
                    this.setState(STATE_LEAVING);
                    Cluster$ClusterService daemonClusterService = this.getClusterService();
                    int i = 1;
                    int c = daemonClusterService.getServiceCount();
                    while (i < c) {
                        Grid service = daemonClusterService.getService(i);
                        if (service != null) {
                            service.shutdown();
                        }
                        ++i;
                    }
                    daemonClusterService.shutdown();
                }
                finally {
                    Object var2_5 = null;
                    this.stop();
                }
            }
            case 4: 
            case 5: {
                while (this.getState() != STATE_EXITED) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw Base.ensureRuntimeException(e);
                    }
                }
            }
            case 6: {
                break;
            }
            default: {
                throw new IllegalStateException(String.valueOf("Unknown State=") + this.getState());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public synchronized void start() {
        try {
            switch (this.getState()) {
                case 0: {
                    this.setState(STATE_STARTING);
                    try {
                        this.onStart();
                    }
                    catch (RuntimeException e) {
                        this.setStartException(e);
                        throw e;
                    }
                }
                case 1: 
                case 2: {
                    Throwable e;
                    do {
                        if (!(this.getState() < STATE_RUNNING)) return;
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e2) {
                            Thread.currentThread().interrupt();
                            if (!(this.getStartException() == null)) continue;
                            throw Base.ensureRuntimeException(e2, "Interrupted while waiting for Cluster start");
                        }
                    } while (!((e = this.getStartException()) != null));
                    throw Base.ensureRuntimeException(e);
                }
                case 3: {
                    return;
                }
                case 4: 
                case 5: {
                    throw new IllegalStateException("Cluster is shutting down!");
                }
                case 6: {
                    throw new IllegalStateException("Cluster is dead!");
                }
            }
            throw new IllegalStateException(String.valueOf("Unknown State=") + this.getState());
        }
        catch (Throwable e) {
            try {
                this.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!(e instanceof Error)) throw (RuntimeException)e;
            throw (Error)e;
        }
    }

    protected void startDaemons() {
        this.getPointListener().start();
        this.getPreferredListener().start();
        this.getReceiver().start();
        this.getPublisher().start();
        this.getSpeaker().start();
        if (this.getDependencies().getWellKnownAddresses() == null) {
            Cluster$PacketListenerN daemonMultiListener = this.getMultiListener();
            Cluster$SocketManager$MulticastUdpSocket udpsocketMulticast = this.getSocketManager().getMulticastUdpSocket();
            udpsocketMulticast.setSoTimeout(this.getDependencies().getPublisherResendTimeoutMillis() >> 2);
            daemonMultiListener.start();
        }
    }

    public void startService(Grid service) {
        String sName = service.getServiceName();
        Component._assert(this.getService(sName) == null, String.valueOf("Service \"") + sName + "\" is already started!");
        Component._assert(service.getCluster() == null, String.valueOf("Service \"") + sName + "\" is already tied to a cluster object!");
        service.setCluster(this);
        service.start();
    }

    public synchronized void stop() {
        if (this.getState() != STATE_EXITED) {
            this.setState(STATE_STOPPING);
            try {
                Cluster$ShutdownHook hook = (Cluster$ShutdownHook)this._findName("ShutdownHook");
                hook.unregister();
                Cluster$ClusterService daemonClusterService = this.getClusterService();
                daemonClusterService.stop();
                this.stopDaemons();
                int cServices = daemonClusterService.getServiceCount();
                LinkedList<Thread> listThreads = new LinkedList<Thread>();
                int i = cServices - 1;
                while (i > 0) {
                    Grid service = daemonClusterService.getService(i);
                    if (service != null) {
                        service.stop();
                        Thread thread = service.getThread();
                        if (thread != null) {
                            listThreads.add(thread);
                        }
                    }
                    --i;
                }
                long cMillisMax = 2 * this.getDependencies().getClusterHeartbeatDelayMillis();
                boolean fInterrupted = false;
                Iterator iter = listThreads.iterator();
                while (!(cMillisMax > (long)0) ? false : iter.hasNext()) {
                    Thread thread = (Thread)iter.next();
                    long lStart = Base.getSafeTimeMillis();
                    try {
                        thread.join(cMillisMax);
                    }
                    catch (InterruptedException e) {
                        fInterrupted = true;
                    }
                    cMillisMax -= Base.getSafeTimeMillis() - lStart;
                }
                if (fInterrupted) {
                    Thread.currentThread().interrupt();
                }
                this.getSocketManager().releaseSockets();
                iter = this.getManagedResourceMap().entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = (Map.Entry)iter.next();
                    Disposable disp = (Disposable)entry.getValue();
                    if (disp != null) {
                        try {
                            disp.dispose();
                        }
                        catch (RuntimeException e) {
                            Component._trace(String.valueOf("Exception while disposing the \"") + entry.getKey() + "\" resource: " + e, 1);
                        }
                    }
                    iter.remove();
                }
            }
            finally {
                Object var2_3 = null;
                this.setState(STATE_EXITED);
            }
        }
    }

    protected void stopDaemons() {
        this.getPointListener().stop();
        this.getPreferredListener().stop();
        this.getMultiListener().stop();
        this.getReceiver().stop();
        this.getPublisher().stop();
        this.getSpeaker().stop();
        this.getIpMonitor().stop();
    }

    public String toString() {
        if (this.getState() == STATE_RUNNING) {
            StringBuffer sb = new StringBuffer();
            String sClusterName = this.getClusterName();
            sb.append("Name=").append(sClusterName.length() == 0 ? "n/a" : sClusterName).append("\n\n");
            AddressProvider providerWka = this.getDependencies().getWellKnownAddresses();
            if (providerWka == null) {
                Cluster$SocketManager$MulticastUdpSocket socket = this.getSocketManager().getMulticastUdpSocket();
                sb.append("Group{Address=").append(InetAddressHelper.toString(socket.getInetAddress())).append(", Port=").append(socket.getPort()).append(", TTL=").append(socket.getTimeToLive()).append('}');
            } else if (providerWka instanceof Set) {
                Set setWka = (Set)((Object)providerWka);
                sb.append("WellKnownAddressList(Size=").append(setWka.size()).append(',');
                Iterator iterWka = setWka.iterator();
                while (iterWka.hasNext()) {
                    InetSocketAddress addr = (InetSocketAddress)iterWka.next();
                    sb.append("\n  WKA{Address=").append(InetAddressHelper.toString(addr.getAddress())).append(", Port=").append(addr.getPort()).append('}');
                }
                sb.append("\n  )");
            } else {
                sb.append("WellKnownAddressProvider(").append(providerWka).append(")");
            }
            Cluster$ClusterService service = this.getClusterService();
            sb.append("\n\n").append(service.getClusterMemberSet()).append("\n\n").append(service.getTcpRing()).append("\n").append(this.getIpMonitor()).append("\n");
            return sb.toString();
        }
        return String.valueOf("Cluster is not running: State=") + this.getState();
    }

    public Disposable unregisterResource(String sName) {
        return (Disposable)this.getManagedResourceMap().remove(sName);
    }

    public void waitHeuristicDelivery(int cMillis) {
        Cluster$PacketPublisher publisher = this.getPublisher();
        Queue queueSend = publisher.getQueue();
        PacketPublisher$ResendQueue queueResend = publisher.getResendQueue();
        Thread.yield();
        int i = 0;
        int c = cMillis / 10;
        while (!(i < c) ? false : (!queueSend.isEmpty() ? false : queueResend.isEmpty()) ^ true) {
            try {
                Thread.sleep(10);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
            ++i;
        }
        if (queueSend.isEmpty() ^ true ? true : queueResend.isEmpty() ^ true) {
            Component._trace(String.valueOf("Shutdown send queue size=") + queueSend.size() + " resend queue size=" + queueResend.size(), 5);
        }
    }

    public void warnDisabledGuardian(String sContext) {
        Component._trace(String.valueOf("Disabling the service-guardian by setting a timeout of 0 has ") + "been deprecated. Instead, please configure a " + "\"service-failure-policy\" of \"logging\" which will perform " + "non-invasive monitoring of Coherence services.\n Configuring " + "the " + sContext + " with a \"logging\" policy with a timeout of " + DefaultServiceFailurePolicy.DEFAULT_LOGGING_INTERVAL + "ms", 2);
    }
}

