/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.management;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.application.console.Coherence;
import com.tangosol.coherence.component.net.Management;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.management.Connector;
import com.tangosol.coherence.component.net.management.gateway.Local;
import com.tangosol.coherence.component.net.management.gateway.Mock;
import com.tangosol.coherence.component.net.management.gateway.Remote;
import com.tangosol.coherence.component.net.management.model.LocalModel;
import com.tangosol.coherence.component.net.management.model.localModel.CacheModel;
import com.tangosol.coherence.component.net.management.model.localModel.ClusterModel;
import com.tangosol.coherence.component.net.management.model.localModel.ClusterNodeModel;
import com.tangosol.coherence.component.net.management.model.localModel.ConnectionManagerModel;
import com.tangosol.coherence.component.net.management.model.localModel.ConnectionModel;
import com.tangosol.coherence.component.net.management.model.localModel.ManagementModel;
import com.tangosol.coherence.component.net.management.model.localModel.PointToPointModel;
import com.tangosol.coherence.component.net.management.model.localModel.ReporterModel;
import com.tangosol.coherence.component.net.management.model.localModel.ServiceModel;
import com.tangosol.coherence.component.net.management.model.localModel.StorageManagerModel;
import com.tangosol.coherence.component.net.management.model.localModel.TransactionManagerModel;
import com.tangosol.coherence.component.net.management.model.localModel.WrapperModel;
import com.tangosol.coherence.component.net.management.model.localModel.wrapperModel.WrapperJmxModel;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.serviceMemberSet.MasterMemberSet;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.partitionedService.PartitionedCache$Storage;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.acceptor.TcpAcceptor;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.acceptor.TcpAcceptor$TcpConnection;
import com.tangosol.coherence.reporter.ReportBatch;
import com.tangosol.coherence.reporter.ReportControl;
import com.tangosol.coherence.transaction.internal.storage.JmxStats;
import com.tangosol.net.Cluster;
import com.tangosol.net.Service;
import com.tangosol.net.management.MBeanHelper;
import com.tangosol.net.management.MBeanReference;
import com.tangosol.net.management.NotificationManager;
import com.tangosol.net.management.Registry;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.ImmutableArrayList;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.WrapperException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.management.Notification;

public class Gateway
extends Management
implements NotificationManager,
Registry {
    private Cluster __m_Cluster;
    private XmlElement __m_Config;
    private transient Map __m_CustomBeans;
    private String __m_DomainName;
    private Filter __m_Filter;
    private Map __m_LocalModels;
    private transient boolean __m_Primary;
    private boolean __m_ReadOnly;
    private transient ReportControl __m_ReportControl;
    private String __m_ServiceName;

    public Gateway() {
        this(null, null, true);
    }

    public Gateway(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setCustomBeans(new SafeHashMap());
            this.setDomainName("");
            this.setLocalModels(new SafeHashMap());
            this.setReadOnly(false);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public void configure(XmlElement xmlConfig) {
        boolean fReadOnly = xmlConfig.getSafeElement("read-only").getBoolean();
        this.setReadOnly(fReadOnly);
        String sServiceName = xmlConfig.getSafeElement("service-name").getString("Management");
        this.setServiceName(sServiceName);
        this.setConfig(xmlConfig);
    }

    protected String convertSpecialCharacters(String s) {
        return s.replace(':', '_');
    }

    public static Gateway createGateway(XmlElement xmlConfig, Cluster cluster) {
        String sManage = xmlConfig.getSafeElement("managed-nodes").getString("none");
        boolean fRemoteMgmt = xmlConfig.getSafeElement("allow-remote-management").getBoolean();
        int nEdition = ((Coherence)Coherence.get_Instance()).getEdition();
        if (nEdition == 3) {
            String sAction = null;
            if (sManage.equals("all")) {
                sManage = "local-only";
                sAction = String.valueOf("switching to the \"") + sManage + "\" mode";
            } else if (sManage.equals("remote-only")) {
                sManage = "none";
                sAction = "disabling management";
            }
            if (fRemoteMgmt) {
                fRemoteMgmt = false;
                if (sAction == null) {
                    sAction = "disabling remote management";
                }
            }
            if (sAction != null) {
                Component._trace(String.valueOf("Remote management is not supported for ") + Member.EDITION_NAME[nEdition] + "; " + sAction, 3);
            }
        }
        if (!sManage.equals("none") ? false : fRemoteMgmt ^ true) {
            return null;
        }
        Local gatewayLocal = null;
        Remote gatewayRemote = null;
        Mock gatewayMock = null;
        Connector connector = new Connector();
        boolean fManaging = sManage.equals("all") ? true : sManage.equals("remote-only");
        connector.setManagingNode(fManaging);
        connector.configure(xmlConfig);
        if (fRemoteMgmt) {
            gatewayRemote = new Remote();
            gatewayRemote.setConnector(connector);
            gatewayRemote.configure(xmlConfig);
            gatewayRemote.setCluster(cluster);
            if (sManage.equals("none")) {
                gatewayRemote.makePrimary();
                return gatewayRemote;
            }
        }
        try {
            gatewayLocal = new Local();
            gatewayLocal.configure(xmlConfig);
            gatewayLocal.setCluster(cluster);
            gatewayLocal.register(Registry.MANAGEMENT_TYPE, connector);
        }
        catch (Throwable e) {
            String sMsg = String.valueOf("This node is not configured for local management; ") + (fRemoteMgmt ? "it can only be managed remotely." : "it will not be managed");
            Component._trace(sMsg, 2);
            if (e instanceof NoClassDefFoundError ^ true) {
                Component._trace(e);
            }
            gatewayRemote.makePrimary();
            return gatewayRemote;
        }
        if (fRemoteMgmt) {
            gatewayLocal.setRemoteGateway(gatewayRemote);
        }
        if (sManage.equals("local-only")) {
            gatewayLocal.makePrimary();
            return gatewayLocal;
        }
        boolean fRemoteOnly = sManage.equals("remote-only");
        if (fRemoteOnly ^ true) {
            Component._assert(sManage.equals("all"), String.valueOf("Unsupported \"managed-nodes\" value: ") + sManage);
        }
        connector.setLocalGateway(gatewayLocal);
        if (fRemoteMgmt) {
            if (fRemoteOnly) {
                Component._trace(String.valueOf("The 'managed-nodes' value of 'remote-only' is incompatible ") + "with 'allow-remote-management' value of 'true'; " + "using the 'managed-nodes' value of 'all' instead", 2);
            }
            gatewayLocal.makePrimary();
            return gatewayLocal;
        }
        gatewayMock = new Mock();
        gatewayMock.setConnector(connector);
        gatewayMock.configure(xmlConfig);
        gatewayMock.setCluster(cluster);
        if (fRemoteOnly) {
            gatewayMock.makePrimary();
            return gatewayMock;
        }
        gatewayLocal.setRemoteGateway(gatewayMock);
        gatewayLocal.makePrimary();
        return gatewayLocal;
    }

    public String ensureGlobalName(String sName) {
        com.tangosol.net.Member member = this.getCluster().getLocalMember();
        if (member == null) {
            return sName;
        }
        StringBuilder sb = new StringBuilder();
        if (sName != null) {
            sb.append(sName);
            int cch = sName.length();
            if (!(cch > 0) ? false : sName.charAt(cch - 1) != ',') {
                sb.append(',');
            }
        }
        return sb.append("nodeId=").append(member.getId()).toString();
    }

    protected LocalModel ensureLocalModel(String sName) {
        LocalModel model = (LocalModel)this.getLocalModels().get(MBeanHelper.stripDomain(sName));
        if (model == null) {
            throw new IllegalStateException(String.valueOf("Model not found: ") + sName);
        }
        return model;
    }

    public Cluster getCluster() {
        return this.__m_Cluster;
    }

    public XmlElement getConfig() {
        return this.__m_Config;
    }

    public Map getCustomBeans() {
        return this.__m_CustomBeans;
    }

    public String getDomainName() {
        return this.__m_DomainName;
    }

    public Filter getFilter() {
        return this.__m_Filter;
    }

    public Map getLocalModels() {
        return this.__m_LocalModels;
    }

    public NotificationManager getNotificationManager() {
        if (this.isPrimary() ^ true) {
            throw new IllegalStateException();
        }
        return this;
    }

    public synchronized ReportControl getReportControl() {
        ReportControl reporter = this.__m_ReportControl;
        if (reporter == null) {
            reporter = new ReportBatch();
            this.setReportControl(reporter);
        }
        return reporter;
    }

    public String getServiceName() {
        return this.__m_ServiceName;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/management/Gateway".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new Gateway();
    }

    private final Component get_Module() {
        return this;
    }

    protected CacheModel instantiateCacheModel(Map map) {
        CacheModel model = new CacheModel();
        model.set_Map(map);
        return model;
    }

    protected ClusterModel instantiateClusterModel() {
        ClusterModel model = new ClusterModel();
        model.set_Cluster(this.getCluster());
        return model;
    }

    protected ClusterNodeModel instantiateClusterNodeModel(com.tangosol.net.Member member) {
        ClusterNodeModel model = new ClusterNodeModel();
        model.set_Cluster(this.getCluster());
        model.set_Member(member);
        return model;
    }

    protected ConnectionManagerModel instantiateConnectionManagerModel(TcpAcceptor acceptor) {
        ConnectionManagerModel model = new ConnectionManagerModel();
        model.set_TcpAcceptor(acceptor);
        return model;
    }

    protected ConnectionModel instantiateConnectionModel(TcpAcceptor$TcpConnection connection) {
        ConnectionModel model = new ConnectionModel();
        model.set_TcpConnection(connection);
        return model;
    }

    protected LocalModel instantiateLocalModel(Object oBean) {
        LocalModel model;
        Component._assert(oBean != null);
        if (oBean instanceof Cluster) {
            Component._assert(oBean == this.getCluster());
            model = this.instantiateClusterModel();
        } else {
            model = oBean instanceof ReportControl ? this.instantiateReporterModel((ReportControl)oBean) : (oBean instanceof Connector ? this.instantiateManagementModel((Connector)oBean) : (oBean instanceof com.tangosol.net.Member ? this.instantiateClusterNodeModel((com.tangosol.net.Member)oBean) : (oBean instanceof TcpAcceptor ? this.instantiateConnectionManagerModel((TcpAcceptor)oBean) : (oBean instanceof TcpAcceptor$TcpConnection ? this.instantiateConnectionModel((TcpAcceptor$TcpConnection)oBean) : (oBean instanceof Service ? this.instantiateServiceModel((Service)oBean) : (oBean instanceof Map ? this.instantiateCacheModel((Map)oBean) : (oBean instanceof PartitionedCache$Storage ? this.instantiateStorageManagerModel((PartitionedCache$Storage)oBean) : (oBean instanceof MasterMemberSet ? this.instantiatePointToPointModel((MasterMemberSet)oBean) : (oBean instanceof MBeanReference ? this.instantiateWrapperJmxModel((MBeanReference)oBean) : (oBean instanceof JmxStats ? this.instantiateTransactionManagerModel((JmxStats)oBean) : this.instantiateWrapperModel(oBean)))))))))));
        }
        if (this.isReadOnly()) {
            model.set_ReadOnly(true);
        }
        return model;
    }

    protected ManagementModel instantiateManagementModel(Connector conn) {
        ManagementModel model = new ManagementModel();
        model.set_Connector(conn);
        return model;
    }

    protected PointToPointModel instantiatePointToPointModel(MasterMemberSet memberset) {
        PointToPointModel model = new PointToPointModel();
        model.set_MemberSet(memberset);
        return model;
    }

    protected ReporterModel instantiateReporterModel(ReportControl control) {
        ReporterModel model = new ReporterModel();
        model.set_ReportControl(control);
        return model;
    }

    protected ServiceModel instantiateServiceModel(Service service) {
        ServiceModel model = new ServiceModel();
        model.set_Service(service);
        if (this.getServiceName().equals(service.getInfo().getServiceName())) {
            model.set_ReadOnly(true);
        }
        return model;
    }

    protected StorageManagerModel instantiateStorageManagerModel(PartitionedCache$Storage storage) {
        StorageManagerModel model = new StorageManagerModel();
        model.set_Storage(storage);
        return model;
    }

    protected TransactionManagerModel instantiateTransactionManagerModel(JmxStats stats) {
        TransactionManagerModel model = new TransactionManagerModel();
        model.set_JmxStats(stats);
        return model;
    }

    protected WrapperJmxModel instantiateWrapperJmxModel(MBeanReference ref) {
        WrapperJmxModel model = new WrapperJmxModel();
        model.initialize(ref);
        return model;
    }

    protected WrapperModel instantiateWrapperModel(Object oBean) {
        WrapperModel model = new WrapperModel();
        model.setMBean(oBean);
        return model;
    }

    public static boolean isGlobal(String sCanonicalName) {
        return sCanonicalName.indexOf("nodeId=") >= 0;
    }

    public boolean isPrimary() {
        return this.__m_Primary;
    }

    public boolean isReadOnly() {
        return this.__m_ReadOnly;
    }

    public boolean isRegistered(String sCanonicalName) {
        throw new UnsupportedOperationException();
    }

    public boolean isSubscribedTo(String sName) {
        LocalModel model = (LocalModel)this.getLocalModels().get(MBeanHelper.stripDomain(sName));
        return !(model != null) ? false : model.is_SubscribedTo();
    }

    public void makePrimary() {
        Component._assert(this.isPrimary() ^ true);
        this.setPrimary(true);
        XmlElement xmlFilter = this.getConfig().getSafeElement("mbean-filter");
        if (XmlHelper.isEmpty(xmlFilter) ^ true) {
            try {
                this.setFilter((Filter)XmlHelper.createInstance(xmlFilter, null, null));
            }
            catch (Throwable e) {
                Component._trace(String.valueOf("Ignoring the mbean-filter element:\n") + Component.getStackTrace(e), 1);
            }
        }
        this.register(Registry.CLUSTER_TYPE, this.getCluster());
    }

    public void register(String sCanonicalName, Object oBean) {
        Filter filter = this.getFilter();
        if (filter == null ? true : filter.evaluate(sCanonicalName)) {
            this.registerLocalModel(sCanonicalName, this.instantiateLocalModel(oBean));
        }
    }

    public void registerCustomBeans() {
        Map mapBeans = this.getCustomBeans();
        XmlElement xmlConfig = this.getConfig().getSafeElement("mbeans");
        Iterator iterBeans = xmlConfig.getElements("mbean");
        while (iterBeans.hasNext()) {
            XmlElement xmlBean = (XmlElement)iterBeans.next();
            String sFactory = xmlBean.getSafeElement("mbean-factory").getString();
            String sServerDomain = xmlBean.getSafeElement("mbean-server-domain").getString();
            String sQuery = xmlBean.getSafeElement("mbean-query").getString();
            String sClass = xmlBean.getSafeElement("mbean-class").getString();
            String sAccessor = xmlBean.getSafeElement("mbean-accessor").getString();
            String sMBeanName = xmlBean.getSafeElement("mbean-name").getString();
            boolean fLocal = xmlBean.getSafeElement("local-only").getBoolean();
            try {
                boolean fEnabled = xmlBean.getSafeElement("enabled").getBoolean();
                boolean fKeep = xmlBean.getSafeElement("extend-lifecycle").getBoolean();
                if (!fEnabled) continue;
                if (sQuery.length() == 0) {
                    Object oMBean = fKeep ? (Object)mapBeans.get(sMBeanName) : null;
                    if (oMBean == null) {
                        Class<?> clzMF;
                        if (sClass.length() == 0) {
                            clzMF = Class.forName(sFactory);
                            oMBean = ClassHelper.invokeStatic(clzMF, sAccessor, null);
                        } else {
                            clzMF = Class.forName(sClass);
                            oMBean = ClassHelper.newInstance(clzMF, null);
                        }
                        if (fKeep) {
                            mapBeans.put(sMBeanName, oMBean);
                        }
                    }
                    if (oMBean instanceof Collection) {
                        Collection colSubBeans = (Collection)oMBean;
                        Iterator iterSubBeans = colSubBeans.iterator();
                        while (iterSubBeans.hasNext()) {
                            Object oSubMBean = iterSubBeans.next();
                            try {
                                String sName = (String)ClassHelper.invoke(oSubMBean, "getName", ClassHelper.VOID);
                                String sLocalName = String.valueOf(sMBeanName) + ",Name=" + sName;
                                this.register(fLocal ? sLocalName : this.ensureGlobalName(sLocalName), oSubMBean);
                            }
                            catch (Exception e) {
                                Component._trace(String.valueOf("Unable to call \"getName()\" for MBean \"") + oSubMBean + "\". The MBean is not registered.", 2);
                            }
                        }
                        continue;
                    }
                    if (!(oMBean != null)) continue;
                    this.register(fLocal ? sMBeanName : this.ensureGlobalName(sMBeanName), oMBean);
                    continue;
                }
                this.registerQueryMBeans(sServerDomain, sQuery, sMBeanName);
            }
            catch (Exception e) {
                Component._trace(String.valueOf("Unable to register MBean \"") + sMBeanName + "\" from factory \"" + sFactory + "\"." + Component.getStackTrace(e), 2);
            }
        }
    }

    public void registerLocalModel(String sCanonicalName, LocalModel model) {
        if (this.isPrimary()) {
            String sName = MBeanHelper.stripDomain(sCanonicalName);
            model.set_ModelName(sName);
            this.getLocalModels().put(sName, model);
        }
    }

    protected void registerQueryMBeans(String sMBeanServerDomain, String sQuery, String sPrefix) {
        try {
            Class<?> clzHelper = Class.forName("com.tangosol.net.management.MBeanHelper");
            ClassHelper.invokeStatic(clzHelper, "registerQueryMBeans", new Object[]{sMBeanServerDomain, sQuery, sPrefix, this});
        }
        catch (InvocationTargetException e) {
            Component._trace(e.getTargetException());
        }
        catch (Throwable e) {
            int nLevel;
            String sMsg = String.valueOf("The MBean query \"") + sQuery + "\" ";
            if (e instanceof NoClassDefFoundError) {
                sMsg = String.valueOf(sMsg) + "requires a local MBeanServer (JDK 1.5 or JMX libraries) and will be ignored";
                nLevel = 2;
            } else {
                sMsg = String.valueOf(sMsg) + (String.valueOf("failed and will be ignored:\n") + Component.getStackTrace(e));
                nLevel = 1;
            }
            Component._trace(sMsg, nLevel);
        }
    }

    public void registerReporter() {
        ReportControl reporter = this.getReportControl();
        String sName = Registry.REPORTER_TYPE;
        if (reporter.isCentralized() ^ true) {
            sName = this.ensureGlobalName(sName);
        }
        this.register(sName, reporter);
        if (reporter.isAutoStart()) {
            reporter.start();
        }
    }

    public static void removeByPattern(Map mapRegistry, String sPattern) {
        ImmutableArrayList setPattern = new ImmutableArrayList(Base.parseDelimitedString(sPattern, ','));
        Iterator iter = mapRegistry.keySet().iterator();
        while (iter.hasNext()) {
            String sName = (String)iter.next();
            ImmutableArrayList setParts = new ImmutableArrayList(Base.parseDelimitedString(sName, ','));
            if (!setParts.containsAll(setPattern)) continue;
            iter.remove();
        }
    }

    public void reset() {
        if (this.isPrimary()) {
            Iterator iter = this.getLocalModels().keySet().iterator();
            while (iter.hasNext()) {
                String sName = (String)iter.next();
                if (!Gateway.isGlobal(sName)) continue;
                iter.remove();
            }
        }
    }

    public void setCluster(Cluster cluster) {
        Component._assert(cluster == null ? true : this.getCluster() == null, "Cluster is not resetable");
        this.__m_Cluster = cluster;
    }

    protected void setConfig(XmlElement xmlConfig) {
        this.__m_Config = xmlConfig;
    }

    protected void setCustomBeans(Map map) {
        this.__m_CustomBeans = map;
    }

    protected void setDomainName(String sDomain) {
        this.__m_DomainName = sDomain;
    }

    protected void setFilter(Filter filter) {
        this.__m_Filter = filter;
    }

    protected void setLocalModels(Map map) {
        this.__m_LocalModels = map;
    }

    protected void setPrimary(boolean fPrimary) {
        this.__m_Primary = fPrimary;
    }

    protected void setReadOnly(boolean fReadOnly) {
        this.__m_ReadOnly = fReadOnly;
    }

    protected void setReportControl(ReportControl rc) {
        this.__m_ReportControl = rc;
    }

    protected void setServiceName(String sName) {
        this.__m_ServiceName = sName;
    }

    public void trigger(String sName, String sType, String sMessage) throws IllegalArgumentException {
        this.ensureLocalModel(sName)._handleNotification(sType, sMessage);
    }

    public void trigger(String sName, Notification notification) throws IllegalArgumentException {
        this.ensureLocalModel(sName)._handleNotification(notification);
    }

    public void unregister(String sCanonicalName) {
        this.unregisterLocalModel(sCanonicalName);
    }

    public void unregisterLocalModel(String sCanonicalName) {
        if (this.isPrimary()) {
            Map mapModels = this.getLocalModels();
            String sName = MBeanHelper.stripDomain(sCanonicalName);
            if (sName.endsWith(",*")) {
                String sPattern = sName.substring(0, sName.length() - 2);
                Gateway.removeByPattern(mapModels, sPattern);
            } else {
                mapModels.remove(sName);
            }
        }
    }
}

