/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.dslquery;

import com.tangosol.coherence.dsltools.termtrees.AtomicTerm;
import com.tangosol.coherence.dsltools.termtrees.NodeTerm;
import com.tangosol.coherence.dsltools.termtrees.Term;
import com.tangosol.coherence.dsltools.termtrees.TermWalker;

public class AbstractCoherenceQueryWalker
implements TermWalker {
    protected String m_alias = null;

    @Override
    public void acceptNode(String functor, NodeTerm node) {
        if (functor.equals("literal")) {
            this.acceptLiteral((AtomicTerm)node.termAt(1));
        } else if (functor.equals("listNode")) {
            this.acceptList(node);
        } else if (functor.equals("identifier")) {
            String sid;
            if (this.m_alias != null && (sid = ((AtomicTerm)node.termAt(1)).getValue()).equals(this.m_alias)) {
                this.acceptCall("value", new NodeTerm("value"));
                return;
            }
            this.acceptIdentifier(((AtomicTerm)node.termAt(1)).getValue());
        } else if (functor.equals("binaryOperatorNode")) {
            this.acceptBinaryOperator(((AtomicTerm)node.termAt(1)).getValue(), node.termAt(2), node.termAt(3));
        } else if (functor.equals("unaryOperatorNode")) {
            this.acceptUnaryOperator(((AtomicTerm)node.termAt(1)).getValue(), node.termAt(2));
        } else if (functor.equals("bindingNode")) {
            String t = ((AtomicTerm)node.termAt(1)).getValue();
            AtomicTerm tm = (AtomicTerm)node.termAt(2).termAt(1);
            if (t.equals("?")) {
                this.acceptNumericBinding(tm.getNumber().intValue());
            } else {
                this.acceptKeyedBinding(tm.getValue());
            }
        } else if (functor.equals("callNode")) {
            this.acceptCall(node.termAt(1).getFunctor(), (NodeTerm)node.termAt(1));
        } else if (functor.equals("derefNode")) {
            AtomicTerm tid;
            Term t;
            if (this.m_alias != null && (t = node.termAt(1)).getFunctor().equals("identifier") && (tid = (AtomicTerm)t.termAt(1)).getValue().equals(this.m_alias)) {
                int cterms = node.length() - 1;
                if (cterms == 1) {
                    Term t2 = node.termAt(2);
                    t2.accept(this);
                    return;
                }
                Term[] ta = new Term[node.length() - 1];
                System.arraycopy(node.children(), 1, ta, 0, node.length() - 1);
                this.acceptPath(new NodeTerm(functor, ta));
                return;
            }
            this.acceptPath(node);
        } else {
            throw new RuntimeException("Unknown AST node: " + node.fullFormString());
        }
    }

    @Override
    public void acceptAtom(String sFunctor, AtomicTerm atom) {
    }

    @Override
    public void acceptTerm(String functor, Term term) {
    }

    protected void acceptLiteral(AtomicTerm atom) {
    }

    protected void acceptList(NodeTerm list) {
    }

    protected void acceptIdentifier(String s) {
    }

    protected void acceptBinaryOperator(String op, Term left, Term right) {
    }

    protected void acceptUnaryOperator(String op, Term term) {
    }

    protected void acceptNumericBinding(int offset) {
    }

    protected void acceptKeyedBinding(String key) {
    }

    protected void acceptCall(String function, NodeTerm args) {
    }

    protected void acceptPath(NodeTerm list) {
    }

    public void setAlias(String sAlias) {
        this.m_alias = sAlias;
    }
}

