/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.transaction;

import com.tangosol.coherence.transaction.Connection;
import com.tangosol.coherence.transaction.ConnectionFactory;
import com.tangosol.coherence.transaction.internal.ConfigHelper;
import com.tangosol.coherence.transaction.internal.ServiceConnection;

public class DefaultConnectionFactory
implements ConnectionFactory {
    private String m_sConfigURI;

    public DefaultConnectionFactory() {
    }

    public DefaultConnectionFactory(String sConfigURI) {
        this.m_sConfigURI = sConfigURI;
    }

    @Override
    public Connection createConnection() {
        return new ServiceConnection(ConfigHelper.ensureTransactionalService(null, this.m_sConfigURI, null, null));
    }

    @Override
    public Connection createConnection(String sServiceName) {
        return new ServiceConnection(ConfigHelper.ensureTransactionalService(sServiceName, this.m_sConfigURI, null, null));
    }

    @Override
    public Connection createConnection(ClassLoader loader) {
        return new ServiceConnection(ConfigHelper.ensureTransactionalService(null, this.m_sConfigURI, loader, null), loader);
    }

    @Override
    public Connection createConnection(String sServiceName, ClassLoader loader) {
        return new ServiceConnection(ConfigHelper.ensureTransactionalService(sServiceName, this.m_sConfigURI, loader, null), loader);
    }

    @Override
    public Connection createConnection(ConnectionFactory.ConnectionSpec connectionSpec) {
        ClassLoader loader = connectionSpec.getClassLoader();
        String sConfigURI = connectionSpec.getConfigURI();
        if (sConfigURI == null) {
            sConfigURI = this.m_sConfigURI;
        }
        ServiceConnection connection = new ServiceConnection(ConfigHelper.ensureTransactionalService(connectionSpec.getServiceName(), this.m_sConfigURI, loader, connectionSpec.getXmlConfig()), loader);
        connection.setAutoCommit(connectionSpec.isAutoCommit());
        connection.setIsolationLevel(connectionSpec.getIsolation());
        connection.setEager(connectionSpec.isEager());
        connection.setTransactionTimeout(connectionSpec.getTimeout());
        return connection;
    }
}

