/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.transaction.internal.operation;

import com.tangosol.coherence.transaction.internal.Message;
import com.tangosol.coherence.transaction.internal.Transaction;
import com.tangosol.coherence.transaction.internal.operation.AbstractOperation;
import com.tangosol.coherence.transaction.internal.operation.Operation;
import com.tangosol.coherence.transaction.internal.operation.ParallelAggregatorOperation;
import com.tangosol.coherence.transaction.internal.storage.Session;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.net.NamedCache;
import com.tangosol.util.Base;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class SizeOperation
extends AbstractOperation
implements ParallelAggregatorOperation {
    private Set m_currentXidSynKeys = new HashSet();

    public SizeOperation() {
    }

    public SizeOperation(String sServiceName) {
        super(sServiceName);
    }

    @Override
    public void initialize(Message msg) {
        Transaction tx = (Transaction)msg.getContext();
        Session session = tx.getSession();
        this.setCurrentXidSynKeys(session.getSyntheticKeyMap().get(this.getTableName()));
    }

    @Override
    public boolean isDeferrable() {
        return false;
    }

    @Override
    public NamedCache getTable() {
        return this.getSchema().getValuesTableByName(this.getTableName());
    }

    @Override
    public Operation.Id getId() {
        return Operation.Id.Size;
    }

    @Override
    public ParallelAggregatorOperation getParallelAggregator() {
        return this;
    }

    @Override
    public Object aggregateResults(Collection collResults) {
        int c = 0;
        Iterator iter = collResults.iterator();
        while (iter.hasNext()) {
            c += ((Integer)iter.next()).intValue();
        }
        return Base.makeInteger(c);
    }

    public void setCurrentXidSynKeys(Set currentXidSynKeys) {
        if (currentXidSynKeys == null) {
            currentXidSynKeys = new HashSet();
        }
        this.m_currentXidSynKeys = currentXidSynKeys;
    }

    public Set getCurrentXidSynKeys() {
        return this.m_currentXidSynKeys;
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        super.readExternal(in);
        this.m_currentXidSynKeys = new HashSet();
        ExternalizableHelper.readCollection(in, this.m_currentXidSynKeys, null);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        super.writeExternal(out);
        ExternalizableHelper.writeCollection(out, this.m_currentXidSynKeys);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        super.readExternal(in);
        in.readCollection(7, this.m_currentXidSynKeys);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        super.writeExternal(out);
        out.writeCollection(7, this.m_currentXidSynKeys);
    }
}

