/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.transaction.internal.storage;

import com.tangosol.coherence.transaction.internal.storage.KeyIndex;
import com.tangosol.coherence.transaction.internal.storage.LocalMemberState;
import com.tangosol.coherence.transaction.internal.storage.LocalPartitionState;
import com.tangosol.coherence.transaction.internal.storage.Schema;
import com.tangosol.coherence.transaction.internal.storage.SyntheticKey;
import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.util.ObservableHashMap;

public class KeyBackingMap
extends ObservableHashMap {
    private BackingMapManagerContext m_context;
    private String m_sTable;
    private String m_sService;

    public KeyBackingMap(String sTable, BackingMapManagerContext context) {
        this.m_context = context;
        this.m_sTable = Schema.getLogicalTableName(sTable);
        this.m_sService = context.getCacheService().getInfo().getServiceName();
    }

    @Override
    public Object put(Object oKey, Object oVal) {
        if (!this.m_context.isKeyOwned(oKey)) {
            Object oNatural = this.m_context.getKeyFromInternalConverter().convert(oKey);
            SyntheticKey oSynthetic = (SyntheticKey)this.m_context.getValueFromInternalConverter().convert(oVal);
            int iPartition = oSynthetic.getPartition();
            LocalPartitionState lps = LocalMemberState.getMemberState(this.m_sService).getLocalPartitionState(iPartition);
            KeyIndex keys = lps.getKeyIndex(this.m_sTable);
            keys.addKey(oSynthetic.getIndex(), oNatural);
        }
        return super.put(oKey, oVal);
    }
}

