/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.transaction.internal.storage;

import com.tangosol.coherence.transaction.internal.storage.KeyIndex;
import com.tangosol.coherence.transaction.internal.storage.LocalMemberState;
import com.tangosol.coherence.transaction.internal.storage.VersionDependencyManager;
import com.tangosol.coherence.transaction.internal.storage.VersionIndex;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class LocalPartitionState {
    private final int m_iPartition;
    private final Map<String, KeyIndex> m_keyIndexes = new HashMap<String, KeyIndex>();
    private final Map<String, VersionIndex> m_versionsIndexes = new ConcurrentHashMap<String, VersionIndex>();
    private final VersionDependencyManager m_dependencyManager;
    private long m_lLastGcCeiling = -1L;

    protected LocalPartitionState(int iPartition, LocalMemberState lms) {
        this.m_iPartition = iPartition;
        this.m_dependencyManager = new VersionDependencyManager(lms);
    }

    public int getPartition() {
        return this.m_iPartition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyIndex getKeyIndex(String sTable) {
        Map<String, KeyIndex> map = this.m_keyIndexes;
        synchronized (map) {
            KeyIndex index = this.m_keyIndexes.get(sTable);
            if (index == null) {
                index = new KeyIndex(this.m_iPartition);
                this.m_keyIndexes.put(sTable, index);
            }
            return index;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VersionIndex ensureVersionIndex(String sTable) {
        Map<String, VersionIndex> map = this.m_versionsIndexes;
        synchronized (map) {
            VersionIndex index = this.m_versionsIndexes.get(sTable);
            if (index == null) {
                index = new VersionIndex(sTable);
                this.m_versionsIndexes.put(sTable, index);
            }
            return index;
        }
    }

    public Map<String, VersionIndex> getExistingVersionIndexes() {
        return this.m_versionsIndexes;
    }

    public VersionDependencyManager getDependencyManager() {
        return this.m_dependencyManager;
    }

    public long getLastGcCeiling() {
        return this.m_lLastGcCeiling;
    }

    public void setLastGcCeiling(long lCeiling) {
        this.m_lLastGcCeiling = lCeiling;
    }
}

