/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.compiler.java;

import com.tangosol.dev.assembler.CodeAttribute;
import com.tangosol.dev.assembler.Dmul;
import com.tangosol.dev.assembler.Fmul;
import com.tangosol.dev.assembler.Imul;
import com.tangosol.dev.assembler.Lmul;
import com.tangosol.dev.compiler.CompilerException;
import com.tangosol.dev.compiler.Context;
import com.tangosol.dev.compiler.java.Expression;
import com.tangosol.dev.compiler.java.MultiplicativeExpression;
import com.tangosol.dev.compiler.java.Token;
import com.tangosol.util.ErrorList;

public class MultiplyExpression
extends MultiplicativeExpression {
    private static final String CLASS = "MultiplyExpression";

    public MultiplyExpression(Expression left, Token operator, Expression right) {
        super(left, operator, right);
    }

    @Override
    protected boolean compile(Context ctx, CodeAttribute code, boolean fReached, ErrorList errlist) throws CompilerException {
        if (!ctx.isDebug() && this.isConstant()) {
            return super.compile(ctx, code, fReached, errlist);
        }
        this.getLeftExpression().compile(ctx, code, fReached, errlist);
        this.getRightExpression().compile(ctx, code, fReached, errlist);
        switch (this.getType().getTypeString().charAt(0)) {
            case 'I': {
                code.add(new Imul());
                break;
            }
            case 'J': {
                code.add(new Lmul());
                break;
            }
            case 'F': {
                code.add(new Fmul());
                break;
            }
            case 'D': {
                code.add(new Dmul());
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return fReached;
    }

    @Override
    public Object getValue() {
        Expression left = this.getLeftExpression();
        Expression right = this.getRightExpression();
        Number nbrLeft = (Number)left.getValue();
        Number nbrRight = (Number)right.getValue();
        switch (left.getType().getTypeString().charAt(0)) {
            case 'I': {
                return MultiplyExpression.makeInteger(nbrLeft.intValue() * nbrRight.intValue());
            }
            case 'J': {
                return MultiplyExpression.makeLong(nbrLeft.longValue() * nbrRight.longValue());
            }
            case 'F': {
                return new Float(nbrLeft.floatValue() * nbrRight.floatValue());
            }
            case 'D': {
                return new Double(nbrLeft.doubleValue() * nbrRight.doubleValue());
            }
        }
        throw new IllegalStateException();
    }
}

