/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.cluster;

import com.tangosol.net.CacheFactory;
import com.tangosol.net.Cluster;
import com.tangosol.net.GuardSupport;
import com.tangosol.net.Guardable;
import com.tangosol.net.Guardian;
import com.tangosol.net.Service;
import com.tangosol.net.ServiceFailurePolicy;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;

public class DefaultServiceFailurePolicy
implements ServiceFailurePolicy {
    public static final int POLICY_EXIT_CLUSTER = 1;
    public static final int POLICY_EXIT_PROCESS = 2;
    public static final int POLICY_LOGGING = 3;
    private int m_nPolicyType;
    public static final int DEFAULT_LOGGING_INTERVAL = 60000;

    public DefaultServiceFailurePolicy(int nPolicyType) {
        this.m_nPolicyType = nPolicyType;
    }

    @Override
    public void onGuardableRecovery(Guardable guardable, Service service) {
        GuardSupport.logStackTraces();
        switch (this.getPolicyType()) {
            default: {
                CacheFactory.log("Attempting recovery of " + guardable, 2);
                guardable.recover();
                break;
            }
            case 3: {
                CacheFactory.log("Logging stacktrace due to soft-timeout", 2);
                Guardian.GuardContext context = guardable.getContext();
                if (context == null) break;
                context.heartbeat();
            }
        }
    }

    @Override
    public void onGuardableTerminate(Guardable guardable, Service service) {
        GuardSupport.logStackTraces();
        switch (this.getPolicyType()) {
            default: {
                CacheFactory.log("Terminating " + guardable, 2);
                guardable.terminate();
            }
            case 3: 
        }
    }

    @Override
    public void onServiceFailed(Cluster cluster) {
        String sHeader = "Coherence <Error>: ";
        switch (this.getPolicyType()) {
            default: {
                System.err.println(sHeader + "Halting this cluster node due to unrecoverable service failure");
                System.err.flush();
                try {
                    ClassHelper.invoke(cluster, "halt", ClassHelper.VOID);
                    break;
                }
                catch (Exception e) {
                    throw Base.ensureRuntimeException(e, "error finding method 'halt' for cluster object");
                }
            }
            case 2: {
                System.err.println(sHeader + "Halting JVM due to unrecoverable service failure");
                System.err.flush();
                Runtime.getRuntime().halt(-1);
            }
        }
    }

    public int getPolicyType() {
        return this.m_nPolicyType;
    }

    public String toString() {
        int nType = this.getPolicyType();
        String sType = nType == 1 ? "exit cluster" : (nType == 2 ? "exit process" : (nType == 3 ? "logging" : "unknown"));
        return "DefaultServiceFailurePolicy{PolicyType=" + sType + "}";
    }
}

