/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.journal;

import com.tangosol.io.BinaryStore;
import com.tangosol.io.BinaryStoreManager;
import com.tangosol.io.journal.FlashJournalRM;
import com.tangosol.io.journal.Journal;
import com.tangosol.io.journal.JournalBinaryStore;
import com.tangosol.io.journal.RamJournalRM;
import com.tangosol.net.CacheFactory;
import com.tangosol.util.Binary;
import com.tangosol.util.Daemon;
import com.tangosol.util.Disposable;
import com.tangosol.util.MapSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class BackupJournalRM
implements Disposable,
BinaryStoreManager {
    private final RamJournalRM m_jrnlrmRam;
    private final FlashJournalRM m_jrnlrmFlash;
    private final double m_dflLoadFactorLimit;
    private boolean m_fLimitExceeded;
    private final AtomicBoolean m_fEvacuated = new AtomicBoolean();
    private final Set<JournalImpl> m_setJournals = new MapSet(new ConcurrentHashMap());

    public BackupJournalRM(RamJournalRM jrnlrmRam, double dflLoadFactorLimit) {
        if (jrnlrmRam == null || jrnlrmRam.getState() != 2) {
            throw new IllegalStateException("A Running RAM Journal RM is required");
        }
        FlashJournalRM jrnlrmFlash = jrnlrmRam.getFlashJournalRM();
        if (jrnlrmFlash == null || jrnlrmFlash.getState() != 2) {
            throw new IllegalStateException("A Running Flash Journal RM is required");
        }
        this.m_jrnlrmRam = jrnlrmRam;
        this.m_jrnlrmFlash = jrnlrmFlash;
        this.m_dflLoadFactorLimit = dflLoadFactorLimit;
    }

    public RamJournalRM getRamJournalRM() {
        return this.m_jrnlrmRam;
    }

    public FlashJournalRM getFlashJournalRM() {
        return this.m_jrnlrmFlash;
    }

    public double getLoadFactorLimit() {
        return this.m_dflLoadFactorLimit;
    }

    public boolean isLimitExceeded() {
        if (this.m_fLimitExceeded) {
            return true;
        }
        if (this.m_jrnlrmRam.getHighestLoadFactor() > this.m_dflLoadFactorLimit) {
            this.m_fLimitExceeded = true;
            this.evacuateRam();
            return true;
        }
        return false;
    }

    @Override
    public JournalBinaryStore createBinaryStore() {
        JournalImpl journal = this.instantiateJournal();
        JournalBinaryStore store = new JournalBinaryStore(journal);
        journal.setConsumer(store);
        this.registerJournal(journal);
        return store;
    }

    @Override
    public void destroyBinaryStore(BinaryStore store) {
        if (store == null) {
            throw new IllegalArgumentException("BinaryStore required");
        }
        if (!(store instanceof JournalBinaryStore)) {
            throw new IllegalArgumentException("Invalid BinaryStore");
        }
        ((JournalBinaryStore)store).dispose();
    }

    public Journal createJournal(Journal.JournalConsumer consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException("JournalConsumer required");
        }
        JournalImpl journal = this.instantiateJournal();
        journal.setConsumer(consumer);
        this.registerJournal(journal);
        return journal;
    }

    @Override
    public void dispose() {
        Iterator<JournalImpl> iter = this.iterateJournals();
        while (iter.hasNext()) {
            iter.next().dispose();
            iter.remove();
        }
    }

    public void close() {
        this.dispose();
    }

    protected void evacuateRam() {
        if (this.m_fEvacuated.compareAndSet(false, true)) {
            final long ldtBefore = CacheFactory.getSafeTimeMillis();
            CacheFactory.log("Journal Resource Manager: Begin evacuation of RAM journal to flash journal at " + CacheFactory.formatDateTime(ldtBefore), 5);
            new Daemon(this.getClass().getSimpleName() + "-evacuator"){

                @Override
                public void run() {
                    long lMask = -4611686018427387904L;
                    try {
                        Iterator<JournalImpl> iter = BackupJournalRM.this.iterateJournals();
                        while (iter.hasNext()) {
                            Journal.JournalConsumer consumer = iter.next().getConsumer();
                            if (consumer == null) continue;
                            consumer.evacuate(-4611686018427387904L, -4611686018427387904L);
                        }
                        long ldtAfter = 1.getSafeTimeMillis();
                        CacheFactory.log("Journal Resource Manager: Completed evacuation of RAM journal to flash journal at " + 1.formatDateTime(ldtAfter) + " (evacuation duration " + (ldtAfter - ldtBefore) + "ms)", 5);
                    }
                    catch (Throwable t) {
                        CacheFactory.log("Journal Resource Manager: An exception occurred during RAM journal evacuation: " + t);
                    }
                }
            }.start();
        }
    }

    protected JournalImpl instantiateJournal() {
        RamConsumer consumerRam = this.instantiateRamConsumer();
        FlashConsumer consumerFlash = this.instantiateFlashConsumer();
        Journal jrnlRam = this.m_jrnlrmRam.createJournal(consumerRam);
        Journal jrnlFlash = this.m_jrnlrmFlash.createJournal(consumerFlash);
        JournalImpl jrnlBackup = this.instantiateJournal(jrnlRam, jrnlFlash);
        consumerRam.setBackupJournal(jrnlBackup);
        return jrnlBackup;
    }

    protected JournalImpl instantiateJournal(Journal jrnlRam, Journal jrnlFlash) {
        return new JournalImpl(jrnlRam, jrnlFlash);
    }

    protected void registerJournal(JournalImpl journal) {
        boolean fAdded = this.m_setJournals.add(journal);
        assert (fAdded);
    }

    protected void unregisterJournal(JournalImpl journal) {
        boolean fRemoved = this.m_setJournals.remove(journal);
        assert (fRemoved);
    }

    protected Iterator<JournalImpl> iterateJournals() {
        return this.m_setJournals.iterator();
    }

    protected RamConsumer instantiateRamConsumer() {
        return new RamConsumer();
    }

    protected FlashConsumer instantiateFlashConsumer() {
        return new FlashConsumer();
    }

    protected class FlashConsumer
    implements Journal.JournalConsumer {
        protected FlashConsumer() {
        }

        @Override
        public void evacuate(long lTicketMask, long lTicketValue) {
        }

        @Override
        public void dedupe(byte[][] aab) {
        }

        @Override
        public String getDescription() {
            return "FlashConsumer";
        }

        @Override
        public void dispose() {
        }
    }

    protected class RamConsumer
    implements Journal.JournalConsumer {
        private JournalImpl m_jrnlBackup;

        protected RamConsumer() {
        }

        @Override
        public void evacuate(long lTicketMask, long lTicketValue) {
            Journal.JournalConsumer consumer = this.getConsumer();
            if (consumer != null) {
                consumer.evacuate(lTicketMask, lTicketValue);
            }
        }

        @Override
        public void dedupe(byte[][] aab) {
            Journal.JournalConsumer consumer = this.getConsumer();
            if (consumer != null) {
                consumer.dedupe(aab);
            }
        }

        @Override
        public String getDescription() {
            return "RamConsumer";
        }

        @Override
        public void dispose() {
            JournalImpl jrnlBackup = this.m_jrnlBackup;
            if (jrnlBackup != null) {
                this.m_jrnlBackup = null;
                jrnlBackup.dispose();
            }
        }

        public JournalImpl getBackupJournal() {
            return this.m_jrnlBackup;
        }

        public void setBackupJournal(JournalImpl jrnlBackup) {
            if (jrnlBackup == null) {
                throw new IllegalArgumentException("Backup Journal required");
            }
            if (this.m_jrnlBackup != null) {
                throw new IllegalStateException("Backup Journal is immutable");
            }
            this.m_jrnlBackup = jrnlBackup;
        }

        public Journal.JournalConsumer getConsumer() {
            JournalImpl jrnlBackup = this.m_jrnlBackup;
            return jrnlBackup == null ? null : jrnlBackup.getConsumer();
        }
    }

    protected class JournalImpl
    implements Journal {
        private Journal.JournalConsumer m_consumer;
        private final Journal m_jrnlRam;
        private final Journal m_jrnlFlash;

        public JournalImpl(Journal jrnlRam, Journal jrnlFlash) {
            this.m_jrnlRam = jrnlRam;
            this.m_jrnlFlash = jrnlFlash;
        }

        @Override
        public long write(Binary bin) {
            return (BackupJournalRM.this.isLimitExceeded() ? this.m_jrnlFlash : this.m_jrnlRam).write(bin);
        }

        @Override
        public Binary read(long lTicket) {
            return this.m_jrnlRam.read(lTicket);
        }

        @Override
        public int release(long lTicket) {
            return this.m_jrnlRam.release(lTicket);
        }

        @Override
        public void dispose() {
            Journal.JournalConsumer consumer = this.m_consumer;
            if (consumer != null) {
                this.m_consumer = null;
                consumer.dispose();
                this.m_jrnlRam.dispose();
                this.m_jrnlFlash.dispose();
                BackupJournalRM.this.unregisterJournal(this);
            }
        }

        protected Journal.JournalConsumer getConsumer() {
            return this.m_consumer;
        }

        protected void setConsumer(Journal.JournalConsumer consumer) {
            if (this.m_consumer != null) {
                throw new IllegalStateException();
            }
            this.m_consumer = consumer;
        }

        public String toString() {
            return "BackupJournal{" + this.m_jrnlRam + "}";
        }
    }
}

