/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.pof;

import com.tangosol.io.DefaultSerializer;
import com.tangosol.io.Evolvable;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.Serializer;
import com.tangosol.io.pof.ConfigurablePofContext;
import com.tangosol.io.pof.PofBufferReader;
import com.tangosol.io.pof.PofBufferWriter;
import com.tangosol.io.pof.PofContext;
import com.tangosol.io.pof.PofHelper;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofSerializer;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.io.pof.PortableObjectSerializer;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryWriteBuffer;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.SafeHashSet;
import java.io.IOException;
import java.io.Serializable;
import java.util.Set;

public class SafeConfigurablePofContext
extends ConfigurablePofContext {
    public static final int TYPE_PORTABLE = 0x7FFFFFFE;
    public static final int TYPE_SERIALIZABLE = Integer.MAX_VALUE;
    private final PofSerializer m_serializerJava = new JavaPofSerializer();
    private final PofSerializer m_serializerPof = new SafePofSerializer();

    public SafeConfigurablePofContext() {
    }

    public SafeConfigurablePofContext(String sLocator) {
        super(sLocator);
    }

    public SafeConfigurablePofContext(XmlElement xml) {
        super(xml);
    }

    @Override
    public PofSerializer getPofSerializer(int nTypeId) {
        switch (nTypeId) {
            case 0x7FFFFFFE: {
                return this.m_serializerPof;
            }
            case 0x7FFFFFFF: {
                return this.m_serializerJava;
            }
        }
        return super.getPofSerializer(nTypeId);
    }

    @Override
    public Class getClass(int nTypeId) {
        switch (nTypeId) {
            case 0x7FFFFFFE: {
                return PortableObject.class;
            }
            case 0x7FFFFFFF: {
                return Serializable.class;
            }
        }
        return super.getClass(nTypeId);
    }

    @Override
    public int getUserTypeIdentifier(Class clz) {
        int nTypeId = this.getUserTypeIdentifierInternal(clz);
        if (nTypeId < 0) {
            if (this.isUserType(clz)) {
                return this.getGenericTypeId(clz);
            }
            throw new IllegalArgumentException("Unknown user type: " + clz);
        }
        return nTypeId;
    }

    @Override
    public int getUserTypeIdentifier(String sClass) {
        int nTypeId = this.getUserTypeIdentifierInternal(sClass);
        if (nTypeId < 0) {
            if (this.isUserType(sClass)) {
                return this.getGenericTypeId(this.loadClass(sClass));
            }
            throw new IllegalArgumentException("Unknown user type: " + sClass);
        }
        return nTypeId;
    }

    @Override
    public boolean isUserType(Class clz) {
        boolean fUserType = super.isUserType(clz);
        if (!fUserType && !PofHelper.isIntrinsicPofType(clz)) {
            fUserType = PortableObject.class.isAssignableFrom(clz) || Serializable.class.isAssignableFrom(clz);
        }
        return fUserType;
    }

    @Override
    public boolean isUserType(String sClass) {
        boolean fUserType = super.isUserType(sClass);
        if (!fUserType) {
            try {
                Class clz = this.loadClass(sClass);
                if (!PofHelper.isIntrinsicPofType(clz)) {
                    fUserType = PortableObject.class.isAssignableFrom(clz) || Serializable.class.isAssignableFrom(clz);
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return fUserType;
    }

    protected int getGenericTypeId(Class clz) {
        if (PortableObject.class.isAssignableFrom(clz)) {
            return 0x7FFFFFFE;
        }
        if (Serializable.class.isAssignableFrom(clz)) {
            return Integer.MAX_VALUE;
        }
        throw new IllegalArgumentException("The \"" + clz.getName() + "\" class is unsupported by " + this.getClass().getName());
    }

    public class SafePofSerializer
    extends ExternalizableHelper
    implements PofSerializer {
        private final PortableObjectSerializer m_serializer = new PortableObjectSerializer(0x7FFFFFFE);
        private final Set m_setRegisteredClasses = new SafeHashSet();

        @Override
        public void serialize(PofWriter out, Object o) throws IOException {
            BinaryWriteBuffer buffer = new BinaryWriteBuffer(8192);
            PofBufferWriter.UserTypeWriter writer = new PofBufferWriter.UserTypeWriter(buffer.getBufferOutput(), (PofContext)SafeConfigurablePofContext.this, 0x7FFFFFFE, -1);
            if (SafeConfigurablePofContext.this.isReferenceEnabled() && !(o instanceof Evolvable)) {
                ((PofBufferWriter)writer).enableReference();
            }
            this.m_serializer.serialize(writer, o);
            String sClass = o.getClass().getName();
            out.writeString(0, sClass);
            out.writeBinary(1, buffer.toBinary());
            out.writeRemainder(null);
            this.register(sClass);
        }

        @Override
        public Object deserialize(PofReader in) throws IOException {
            PortableObject po;
            String sClass = in.readString(0);
            Binary bin = in.readBinary(1);
            in.readRemainder();
            SafeConfigurablePofContext ctx = SafeConfigurablePofContext.this;
            try {
                po = (PortableObject)ctx.loadClass(sClass).newInstance();
            }
            catch (Throwable e) {
                throw SafePofSerializer.ensureRuntimeException(e, "Unable to instantiate PortableObject class: " + sClass);
            }
            ReadBuffer.BufferInput inInternal = bin.getBufferInput();
            int nType = inInternal.readPackedInt();
            if (nType != 0x7FFFFFFE) {
                throw new IOException("Invalid POF type: " + nType + " (" + 0x7FFFFFFE + " expected)");
            }
            int iVersion = inInternal.readPackedInt();
            PofBufferReader.UserTypeReader reader = new PofBufferReader.UserTypeReader(inInternal, ctx, 0x7FFFFFFE, iVersion);
            this.m_serializer.initialize(po, reader);
            this.register(sClass);
            return po;
        }

        protected void register(String sClass) {
            if (this.m_setRegisteredClasses.add(sClass)) {
                SafePofSerializer.log("TODO: Add the class \"" + sClass + "\" to the POF configuration file.");
            }
        }
    }

    public class JavaPofSerializer
    extends ExternalizableHelper
    implements PofSerializer {
        private final Serializer m_serializer = new DefaultSerializer(JavaPofSerializer.getContextClassLoader());
        private final Set m_setRegisteredClasses = new SafeHashSet();

        @Override
        public void serialize(PofWriter out, Object o) throws IOException {
            out.writeBinary(0, JavaPofSerializer.toBinary(o, this.m_serializer));
            out.writeRemainder(null);
            this.register(o);
        }

        @Override
        public Object deserialize(PofReader in) throws IOException {
            Object o = JavaPofSerializer.fromBinary(in.readBinary(0), this.m_serializer);
            in.registerIdentity(o);
            in.readRemainder();
            this.register(o);
            return o;
        }

        protected void register(Object o) {
            String sClass;
            if (o != null && this.m_setRegisteredClasses.add(sClass = o.getClass().getName())) {
                JavaPofSerializer.log("TODO: Add POF support for \"" + sClass + "\".");
            }
        }
    }
}

