/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class WrapperCollections {

    public static class ConcurrentWrapperEntry<K, V>
    implements Map.Entry<K, V> {
        private final Map.Entry<K, V> m_entryDelegate;
        protected final ReadWriteLock m_lock;
        protected final Lock m_lockShared;
        protected final Lock m_lockExclusive;

        public ConcurrentWrapperEntry(Map.Entry<K, V> entry) {
            this(entry, new ReentrantReadWriteLock());
        }

        protected ConcurrentWrapperEntry(Map.Entry<K, V> entry, ReadWriteLock lock) {
            this(entry, lock, false);
        }

        protected ConcurrentWrapperEntry(Map.Entry<K, V> entry, ReadWriteLock lock, boolean fStrict) {
            this.m_entryDelegate = entry;
            this.m_lock = lock;
            this.m_lockShared = fStrict ? lock.readLock() : null;
            this.m_lockExclusive = lock.writeLock();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public K getKey() {
            Lock lock = this.m_lockShared;
            if (lock != null) {
                lock.lock();
            }
            try {
                K k = this.getDelegate().getKey();
                return k;
            }
            finally {
                if (lock != null) {
                    lock.unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V getValue() {
            Lock lock = this.m_lockShared;
            if (lock != null) {
                lock.lock();
            }
            try {
                V v = this.getDelegate().getValue();
                return v;
            }
            finally {
                if (lock != null) {
                    lock.unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V setValue(V value) {
            Lock lock = this.m_lockExclusive;
            lock.lock();
            try {
                V v = this.getDelegate().setValue(value);
                return v;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object o) {
            Lock lock = this.m_lockShared;
            if (lock != null) {
                lock.lock();
            }
            try {
                boolean bl = ((Object)this.getDelegate()).equals(o);
                return bl;
            }
            finally {
                if (lock != null) {
                    lock.unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            Lock lock = this.m_lockShared;
            if (lock != null) {
                lock.lock();
            }
            try {
                int n = ((Object)this.getDelegate()).hashCode();
                return n;
            }
            finally {
                if (lock != null) {
                    lock.unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Lock lock = this.m_lockShared;
            if (lock != null) {
                lock.lock();
            }
            try {
                String string = this.getDelegate().toString();
                return string;
            }
            finally {
                if (lock != null) {
                    lock.unlock();
                }
            }
        }

        protected Map.Entry<K, V> getDelegate() {
            return this.m_entryDelegate;
        }

        protected ReadWriteLock getLock() {
            return this.m_lock;
        }
    }

    public static class ConcurrentWrapperEntrySet<K, V>
    extends ConcurrentWrapperSet<Map.Entry<K, V>>
    implements Set<Map.Entry<K, V>> {
        protected final boolean m_fStrict;

        protected ConcurrentWrapperEntrySet(Set<Map.Entry<K, V>> set, ReadWriteLock lock, boolean fStrict) {
            super(set, lock);
            this.m_fStrict = fStrict;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            Lock lock = this.m_lockShared;
            lock.lock();
            try {
                AbstractWrapperIterator abstractWrapperIterator = new AbstractWrapperIterator<Map.Entry<K, V>>(this.getDelegate().iterator()){

                    @Override
                    public Map.Entry<K, V> next() {
                        return new ConcurrentWrapperEntry((Map.Entry)this.getDelegate().next(), ConcurrentWrapperEntrySet.this.m_lock, ConcurrentWrapperEntrySet.this.m_fStrict);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void remove() {
                        Lock lock = ConcurrentWrapperEntrySet.this.m_lockExclusive;
                        lock.lock();
                        try {
                            this.getDelegate().remove();
                        }
                        finally {
                            lock.unlock();
                        }
                    }
                };
                return abstractWrapperIterator;
            }
            finally {
                lock.unlock();
            }
        }
    }

    public static class ConcurrentWrapperSet<E>
    extends ConcurrentWrapperCollection<E>
    implements Set<E> {
        public ConcurrentWrapperSet(Set<E> set) {
            super(set);
        }

        protected ConcurrentWrapperSet(Set<E> set, ReadWriteLock lock) {
            super(set, lock);
        }

        @Override
        protected Set<E> getDelegate() {
            return (Set)super.getDelegate();
        }
    }

    public static class ConcurrentWrapperCollection<E>
    implements Collection<E> {
        private final Collection<E> m_colDelegate;
        protected final ReadWriteLock m_lock;
        protected final Lock m_lockShared;
        protected final Lock m_lockExclusive;

        public ConcurrentWrapperCollection(Collection<E> col) {
            this(col, new ReentrantReadWriteLock());
        }

        protected ConcurrentWrapperCollection(Collection<E> col, ReadWriteLock lock) {
            this.m_colDelegate = col;
            this.m_lock = lock;
            this.m_lockShared = lock.readLock();
            this.m_lockExclusive = lock.writeLock();
        }

        protected Collection<E> getDelegate() {
            return this.m_colDelegate;
        }

        protected ReadWriteLock getLock() {
            return this.m_lock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Lock lock = this.m_lockShared;
            lock.lock();
            try {
                int n = this.getDelegate().size();
                return n;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEmpty() {
            Lock lock = this.m_lockShared;
            lock.lock();
            try {
                boolean bl = this.getDelegate().isEmpty();
                return bl;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object o) {
            Lock lock = this.m_lockShared;
            lock.lock();
            try {
                boolean bl = this.getDelegate().contains(o);
                return bl;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Iterator<E> iterator() {
            Lock lock = this.m_lockShared;
            lock.lock();
            try {
                AbstractWrapperIterator abstractWrapperIterator = new AbstractWrapperIterator<E>(this.getDelegate().iterator()){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void remove() {
                        Lock lock = ConcurrentWrapperCollection.this.m_lockExclusive;
                        lock.lock();
                        try {
                            this.getDelegate().remove();
                        }
                        finally {
                            lock.unlock();
                        }
                    }
                };
                return abstractWrapperIterator;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray() {
            Lock lock = this.m_lockShared;
            lock.lock();
            try {
                Object[] objectArray = this.getDelegate().toArray();
                return objectArray;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] a) {
            Lock lock = this.m_lockShared;
            lock.lock();
            try {
                T[] TArray = this.getDelegate().toArray(a);
                return TArray;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean add(E o) {
            Lock lock = this.m_lockExclusive;
            lock.lock();
            try {
                boolean bl = this.getDelegate().add(o);
                return bl;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object o) {
            Lock lock = this.m_lockExclusive;
            lock.lock();
            try {
                boolean bl = this.getDelegate().remove(o);
                return bl;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsAll(Collection<?> c) {
            Lock lock = this.m_lockShared;
            lock.lock();
            try {
                boolean bl = this.getDelegate().containsAll(c);
                return bl;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(Collection<? extends E> c) {
            Lock lock = this.m_lockExclusive;
            lock.lock();
            try {
                boolean bl = this.getDelegate().addAll(c);
                return bl;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean retainAll(Collection<?> c) {
            Lock lock = this.m_lockExclusive;
            lock.lock();
            try {
                boolean bl = this.getDelegate().retainAll(c);
                return bl;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeAll(Collection<?> c) {
            Lock lock = this.m_lockExclusive;
            lock.lock();
            try {
                boolean bl = this.getDelegate().removeAll(c);
                return bl;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Lock lock = this.m_lockExclusive;
            lock.lock();
            try {
                this.getDelegate().clear();
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object oOther) {
            Lock lock = this.m_lockShared;
            lock.lock();
            try {
                boolean bl = ((Object)this.getDelegate()).equals(oOther);
                return bl;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            Lock lock = this.m_lockShared;
            lock.lock();
            try {
                int n = ((Object)this.getDelegate()).hashCode();
                return n;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Lock lock = this.m_lockShared;
            lock.lock();
            try {
                String string = this.getDelegate().toString();
                return string;
            }
            finally {
                lock.unlock();
            }
        }
    }

    public static class ConcurrentWrapperMap<K, V>
    implements Map<K, V> {
        private final Map<K, V> m_mapDelegate;
        protected final ReadWriteLock m_lock;
        protected final Lock m_lockShared;
        protected final Lock m_lockExclusive;
        protected Set<K> m_setKeys;
        protected Set<Map.Entry<K, V>> m_setEntries;
        protected Collection<V> m_collValues;
        protected final boolean m_fStrict;

        public ConcurrentWrapperMap(Map<K, V> map) {
            this(map, new ReentrantReadWriteLock());
        }

        protected ConcurrentWrapperMap(Map<K, V> map, ReadWriteLock lock) {
            this(map, lock, false);
        }

        protected ConcurrentWrapperMap(Map<K, V> map, ReadWriteLock lock, boolean fStrict) {
            this.m_mapDelegate = map;
            this.m_lock = lock;
            this.m_lockShared = lock.readLock();
            this.m_lockExclusive = lock.writeLock();
            this.m_fStrict = fStrict;
        }

        protected Map<K, V> getDelegate() {
            return this.m_mapDelegate;
        }

        protected ReadWriteLock getLock() {
            return this.m_lock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Lock lock = this.m_lockExclusive;
            lock.lock();
            try {
                this.getDelegate().clear();
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsKey(Object oKey) {
            Lock lock = this.m_lockShared;
            lock.lock();
            try {
                boolean bl = this.getDelegate().containsKey(oKey);
                return bl;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsValue(Object oValue) {
            Lock lock = this.m_lockShared;
            lock.lock();
            try {
                boolean bl = this.getDelegate().containsValue(oValue);
                return bl;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            Lock lock = this.m_lockShared;
            lock.lock();
            try {
                Set<Map.Entry<K, V>> set = this.m_setEntries;
                if (set == null) {
                    this.m_setEntries = set = new ConcurrentWrapperEntrySet<K, V>(this.getDelegate().entrySet(), this.m_lock, this.m_fStrict);
                }
                Set<Map.Entry<K, V>> set2 = set;
                return set2;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V get(Object oKey) {
            Lock lock = this.m_lockShared;
            lock.lock();
            try {
                V v = this.getDelegate().get(oKey);
                return v;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEmpty() {
            Lock lock = this.m_lockShared;
            lock.lock();
            try {
                boolean bl = this.getDelegate().isEmpty();
                return bl;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<K> keySet() {
            Lock lock = this.m_lockShared;
            lock.lock();
            try {
                Set<K> set = this.m_setKeys;
                if (set == null) {
                    this.m_setKeys = set = new ConcurrentWrapperSet<K>(this.getDelegate().keySet(), this.m_lock);
                }
                Set<K> set2 = set;
                return set2;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V put(K oKey, V oValue) {
            Lock lock = this.m_lockExclusive;
            lock.lock();
            try {
                V v = this.getDelegate().put(oKey, oValue);
                return v;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void putAll(Map<? extends K, ? extends V> map) {
            Lock lock = this.m_lockExclusive;
            lock.lock();
            try {
                this.getDelegate().putAll(map);
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V remove(Object oKey) {
            Lock lock = this.m_lockExclusive;
            lock.lock();
            try {
                V v = this.getDelegate().remove(oKey);
                return v;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Lock lock = this.m_lockShared;
            lock.lock();
            try {
                int n = this.getDelegate().size();
                return n;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<V> values() {
            Lock lock = this.m_lockShared;
            lock.lock();
            try {
                Collection<V> coll = this.m_collValues;
                if (coll == null) {
                    this.m_collValues = coll = new ConcurrentWrapperCollection<V>(this.getDelegate().values(), this.m_lock);
                }
                Collection<V> collection = coll;
                return collection;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object oOther) {
            Lock lock = this.m_lockShared;
            lock.lock();
            try {
                boolean bl = ((Object)this.getDelegate()).equals(oOther);
                return bl;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            Lock lock = this.m_lockShared;
            lock.lock();
            try {
                int n = ((Object)this.getDelegate()).hashCode();
                return n;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Lock lock = this.m_lockShared;
            lock.lock();
            try {
                String string = this.getDelegate().toString();
                return string;
            }
            finally {
                lock.unlock();
            }
        }
    }

    public static abstract class AbstractWrapperSortedSet<E>
    extends AbstractWrapperSet<E>
    implements SortedSet<E> {
        private final SortedSet<E> m_setDelegate;

        protected AbstractWrapperSortedSet(SortedSet<E> set) {
            super(set);
            this.m_setDelegate = set;
        }

        @Override
        protected SortedSet<E> getDelegate() {
            return this.m_setDelegate;
        }

        @Override
        public Comparator<? super E> comparator() {
            return this.getDelegate().comparator();
        }

        @Override
        public SortedSet<E> subSet(E oFrom, E oTo) {
            return this.getDelegate().subSet(oFrom, oTo);
        }

        @Override
        public SortedSet<E> headSet(E oTo) {
            return this.getDelegate().headSet(oTo);
        }

        @Override
        public SortedSet<E> tailSet(E oFrom) {
            return this.getDelegate().tailSet(oFrom);
        }

        @Override
        public E first() {
            return this.getDelegate().first();
        }

        @Override
        public E last() {
            return this.getDelegate().last();
        }
    }

    public static abstract class AbstractWrapperEntry<K, V>
    implements Map.Entry<K, V> {
        private final Map.Entry<K, V> m_entryDelegate;

        protected AbstractWrapperEntry(Map.Entry<K, V> entry) {
            this.m_entryDelegate = entry;
        }

        protected Map.Entry<K, V> getDelegate() {
            return this.m_entryDelegate;
        }

        @Override
        public K getKey() {
            return this.getDelegate().getKey();
        }

        @Override
        public V getValue() {
            return this.getDelegate().getValue();
        }

        @Override
        public V setValue(V oValue) {
            return this.getDelegate().setValue(oValue);
        }

        @Override
        public boolean equals(Object o) {
            return ((Object)this.getDelegate()).equals(o);
        }

        @Override
        public int hashCode() {
            return ((Object)this.getDelegate()).hashCode();
        }

        public String toString() {
            return this.getDelegate().toString();
        }
    }

    public static abstract class AbstractWrapperMap<K, V>
    implements Map<K, V> {
        private final Map<K, V> m_mapDelegate;

        protected AbstractWrapperMap(Map<K, V> map) {
            this.m_mapDelegate = map;
        }

        protected Map<K, V> getDelegate() {
            return this.m_mapDelegate;
        }

        @Override
        public void clear() {
            this.getDelegate().clear();
        }

        @Override
        public boolean containsKey(Object oKey) {
            return this.getDelegate().containsKey(oKey);
        }

        @Override
        public boolean containsValue(Object oValue) {
            return this.getDelegate().containsValue(oValue);
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return this.getDelegate().entrySet();
        }

        @Override
        public V get(Object oKey) {
            return this.getDelegate().get(oKey);
        }

        @Override
        public boolean isEmpty() {
            return this.getDelegate().isEmpty();
        }

        @Override
        public Set<K> keySet() {
            return this.getDelegate().keySet();
        }

        @Override
        public V put(K oKey, V oValue) {
            return this.getDelegate().put(oKey, oValue);
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> map) {
            this.getDelegate().putAll(map);
        }

        @Override
        public V remove(Object oKey) {
            return this.getDelegate().remove(oKey);
        }

        @Override
        public int size() {
            return this.getDelegate().size();
        }

        @Override
        public Collection<V> values() {
            return this.getDelegate().values();
        }

        @Override
        public boolean equals(Object oOther) {
            return ((Object)this.getDelegate()).equals(oOther);
        }

        @Override
        public int hashCode() {
            return ((Object)this.getDelegate()).hashCode();
        }

        public String toString() {
            return this.getDelegate().toString();
        }
    }

    public static abstract class AbstractWrapperList<E>
    extends AbstractWrapperCollection<E>
    implements List<E> {
        private final List<E> m_listDelegate;

        protected AbstractWrapperList(List<E> list) {
            super(list);
            this.m_listDelegate = list;
        }

        @Override
        protected List<E> getDelegate() {
            return this.m_listDelegate;
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> c) {
            return this.getDelegate().addAll(index, c);
        }

        @Override
        public E get(int index) {
            return this.getDelegate().get(index);
        }

        @Override
        public E set(int index, E element) {
            return this.getDelegate().set(index, element);
        }

        @Override
        public void add(int index, E element) {
            this.getDelegate().add(index, element);
        }

        @Override
        public E remove(int index) {
            return this.getDelegate().remove(index);
        }

        @Override
        public int indexOf(Object o) {
            return this.getDelegate().indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.getDelegate().lastIndexOf(o);
        }

        @Override
        public ListIterator<E> listIterator() {
            return this.getDelegate().listIterator();
        }

        @Override
        public ListIterator<E> listIterator(int index) {
            return this.getDelegate().listIterator(index);
        }

        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            return this.getDelegate().subList(fromIndex, toIndex);
        }
    }

    public static abstract class AbstractWrapperSet<E>
    extends AbstractWrapperCollection<E>
    implements Set<E> {
        protected AbstractWrapperSet(Set<E> set) {
            super(set);
        }

        @Override
        protected Set<E> getDelegate() {
            return (Set)super.getDelegate();
        }
    }

    public static abstract class AbstractWrapperCollection<E>
    implements Collection<E> {
        private final Collection<E> m_colDelegate;

        protected AbstractWrapperCollection(Collection<E> col) {
            this.m_colDelegate = col;
        }

        protected Collection<E> getDelegate() {
            return this.m_colDelegate;
        }

        @Override
        public int size() {
            return this.getDelegate().size();
        }

        @Override
        public boolean isEmpty() {
            return this.getDelegate().isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.getDelegate().contains(o);
        }

        @Override
        public Iterator<E> iterator() {
            return this.getDelegate().iterator();
        }

        @Override
        public Object[] toArray() {
            return this.getDelegate().toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.getDelegate().toArray(a);
        }

        @Override
        public boolean add(E o) {
            return this.getDelegate().add(o);
        }

        @Override
        public boolean remove(Object o) {
            return this.getDelegate().remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.getDelegate().containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            return this.getDelegate().addAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.getDelegate().retainAll(c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.getDelegate().removeAll(c);
        }

        @Override
        public void clear() {
            this.getDelegate().clear();
        }

        @Override
        public boolean equals(Object o) {
            return ((Object)this.getDelegate()).equals(o);
        }

        @Override
        public int hashCode() {
            return ((Object)this.getDelegate()).hashCode();
        }

        public String toString() {
            return this.getDelegate().toString();
        }
    }

    public abstract class AbstractWrapperListIterator<E>
    extends AbstractWrapperIterator<E>
    implements ListIterator<E> {
        private final ListIterator<E> m_iterDelegate;

        protected AbstractWrapperListIterator(ListIterator<E> iter) {
            super(iter);
            this.m_iterDelegate = iter;
        }

        @Override
        protected ListIterator<E> getDelegate() {
            return this.m_iterDelegate;
        }

        @Override
        public void add(E o) {
            this.getDelegate().add(o);
        }

        @Override
        public boolean hasPrevious() {
            return this.getDelegate().hasPrevious();
        }

        @Override
        public int nextIndex() {
            return this.getDelegate().nextIndex();
        }

        @Override
        public E previous() {
            return this.getDelegate().previous();
        }

        @Override
        public int previousIndex() {
            return this.getDelegate().previousIndex();
        }

        @Override
        public void set(E o) {
            this.getDelegate().set(o);
        }
    }

    public static abstract class AbstractWrapperIterator<E>
    implements Iterator<E> {
        private final Iterator<E> m_iterDelegate;

        protected AbstractWrapperIterator(Iterator<E> iter) {
            this.m_iterDelegate = iter;
        }

        protected Iterator<E> getDelegate() {
            return this.m_iterDelegate;
        }

        @Override
        public boolean hasNext() {
            return this.getDelegate().hasNext();
        }

        @Override
        public E next() {
            return this.getDelegate().next();
        }

        @Override
        public void remove() {
            this.getDelegate().remove();
        }

        public boolean equals(Object o) {
            return this.getDelegate().equals(o);
        }

        public int hashCode() {
            return this.getDelegate().hashCode();
        }

        public String toString() {
            return this.getDelegate().toString();
        }
    }
}

