/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.extractor;

import com.tangosol.io.pof.PofContext;
import com.tangosol.io.pof.PofHelper;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.io.pof.reflect.PofNavigator;
import com.tangosol.io.pof.reflect.PofValue;
import com.tangosol.io.pof.reflect.PofValueParser;
import com.tangosol.io.pof.reflect.SimplePofPath;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.MapTrigger;
import com.tangosol.util.extractor.AbstractExtractor;
import java.io.IOException;
import java.io.NotActiveException;
import java.util.Map;

public class PofExtractor
extends AbstractExtractor
implements PortableObject {
    private PofNavigator m_navigator;
    private transient Class m_clz;
    private int m_nType;

    public PofExtractor() {
        this.m_nType = -65;
    }

    public PofExtractor(Class clz, int iProp) {
        this(clz, new SimplePofPath(iProp), 0);
    }

    public PofExtractor(Class clz, PofNavigator navigator) {
        this(clz, navigator, 0);
    }

    public PofExtractor(Class clz, PofNavigator navigator, int nTarget) {
        PofExtractor.azzert(navigator != null, "Navigator must not be null.");
        this.m_clz = clz;
        this.m_navigator = navigator;
        this.m_nTarget = nTarget;
        if (clz == null) {
            this.m_nType = -65;
        }
    }

    @Override
    public Object extractFromEntry(Map.Entry entry) {
        return this.extractInternal(entry, this.m_nTarget);
    }

    @Override
    public Object extractOriginalFromEntry(MapTrigger.Entry entry) {
        return this.extractInternal(entry, -1);
    }

    private Object extractInternal(Map.Entry entry, int nTarget) {
        Binary binTarget;
        PofContext ctx;
        BinaryEntry binEntry;
        try {
            binEntry = (BinaryEntry)entry;
            ctx = (PofContext)binEntry.getSerializer();
        }
        catch (ClassCastException cce) {
            String sReason = entry instanceof BinaryEntry ? "the configured Serializer is not a PofContext" : "the Map Entry is not a BinaryEntry";
            throw new UnsupportedOperationException("PofExtractor must be used with POF-encoded Binary entries; " + sReason);
        }
        switch (nTarget) {
            default: {
                binTarget = binEntry.getBinaryValue();
                break;
            }
            case 1: {
                binTarget = binEntry.getBinaryKey();
                break;
            }
            case -1: {
                binTarget = binEntry.getOriginalBinaryValue();
            }
        }
        if (binTarget == null) {
            return null;
        }
        PofValue valueRoot = PofValueParser.parse(binTarget, ctx);
        return this.m_navigator.navigate(valueRoot).getValue(this.getPofTypeId(ctx));
    }

    public PofNavigator getNavigator() {
        return this.m_navigator;
    }

    public Class getClassExtracted() {
        return this.m_clz;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof PofExtractor) {
            PofExtractor that = (PofExtractor)o;
            return this.m_nTarget == that.m_nTarget && PofExtractor.equals(this.m_navigator, that.m_navigator);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.m_navigator.hashCode() + this.m_nTarget;
    }

    @Override
    public String toString() {
        return ClassHelper.getSimpleName(this.getClass()) + "(target=" + (this.m_nTarget == 0 ? "VALUE" : "KEY") + ", navigator=" + this.m_navigator + ')';
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_nTarget = in.readInt(0);
        this.m_navigator = (PofNavigator)in.readObject(1);
        this.m_nType = (int)(in.readLong(2) + -65L);
        this.m_clz = null;
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        PofNavigator navigator = this.m_navigator;
        if (navigator == null) {
            throw new NotActiveException("PofExtractor was constructed without a navigator");
        }
        out.writeInt(0, this.m_nTarget);
        out.writeObject(1, navigator);
        out.writeLong(2, (long)this.getPofTypeId(out.getPofContext()) - -65L);
    }

    protected int getPofTypeId(PofContext ctx) {
        Class clz = this.m_clz;
        return clz == null ? this.m_nType : PofHelper.getPofTypeId(clz, ctx);
    }
}

