/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.filter;

import com.tangosol.util.Filter;
import com.tangosol.util.QueryContext;
import com.tangosol.util.QueryRecord;
import com.tangosol.util.SubSet;
import com.tangosol.util.filter.AndFilter;
import com.tangosol.util.filter.ArrayFilter;
import com.tangosol.util.filter.IndexAwareFilter;
import com.tangosol.util.filter.KeyFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AnyFilter
extends ArrayFilter {
    public AnyFilter() {
    }

    public AnyFilter(Filter[] afilter) {
        super(afilter);
    }

    @Override
    public boolean evaluate(Object o) {
        Filter[] afilter = this.m_aFilter;
        int c = afilter.length;
        for (int i = 0; i < c; ++i) {
            if (!afilter[i].evaluate(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int calculateEffectiveness(Map mapIndexes, Set setKeys) {
        ArrayFilter.WeightedFilter[] awf = this.calculateFilters(mapIndexes, setKeys);
        return awf[awf.length - 1].getEffectiveness();
    }

    @Override
    protected boolean evaluateEntry(Map.Entry entry, QueryContext ctx, QueryRecord.PartialResult.TraceStep step) {
        for (Filter filter : this.m_aFilter) {
            if (!this.evaluateFilter(filter, entry, ctx, step == null ? null : step.ensureStep(filter))) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Filter applyIndex(Map mapIndexes, Set setKeys, QueryContext ctx, QueryRecord.PartialResult.TraceStep step) {
        ArrayFilter.WeightedFilter[] awf = this.calculateFilters(mapIndexes, setKeys);
        int cFilters = awf.length;
        ArrayList<Filter> listFilter = new ArrayList<Filter>(cFilters);
        HashSet setMatch = new HashSet(setKeys.size());
        for (int i = 0; i < cFilters; ++i) {
            Filter filter = awf[i].getFilter();
            if (filter instanceof IndexAwareFilter) {
                Filter filterDefer;
                SubSet setRemain = new SubSet(setKeys);
                if (!setMatch.isEmpty()) {
                    setRemain.removeAll((Collection)setMatch);
                }
                if ((filterDefer = this.applyFilter(filter, i, mapIndexes, setRemain, ctx, step)) == null) {
                    setMatch.addAll(setRemain);
                    continue;
                }
                int cKeys = setKeys.size();
                int cRemain = setRemain.size();
                if (cRemain < cKeys) {
                    if (cRemain <= 0) continue;
                    KeyFilter filterKey = new KeyFilter(setRemain);
                    listFilter.add(new AndFilter(filterDefer, filterKey));
                    continue;
                }
                listFilter.add(filterDefer);
                continue;
            }
            listFilter.add(filter);
        }
        int cMatches = setMatch.size();
        cFilters = listFilter.size();
        if (cFilters == 0) {
            if (cMatches > 0) {
                setKeys.retainAll(setMatch);
            } else {
                setKeys.clear();
            }
            return null;
        }
        if (cFilters == 1 && cMatches == 0) {
            return (Filter)listFilter.get(0);
        }
        if (cMatches > 0) {
            KeyFilter filterKey = new KeyFilter(setMatch);
            listFilter.add(0, filterKey);
            ++cFilters;
        }
        return new AnyFilter(listFilter.toArray(new Filter[cFilters]));
    }
}

