/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.common.io;

import com.oracle.common.io.BufferManager;
import com.oracle.common.io.BufferSequence;
import java.nio.ByteBuffer;

public class MultiBufferSequence
implements BufferSequence {
    protected final BufferManager m_manager;
    protected ByteBuffer[] m_aBuffer;
    protected final int m_ofBuffer;
    protected final int m_cBuffer;
    protected final long m_cbBuffer;
    protected final int[] m_aPosLimit;
    protected int m_ofSafe;

    public MultiBufferSequence(BufferManager manager, ByteBuffer[] aBuffer) {
        this(manager, aBuffer, 0, aBuffer.length);
    }

    public MultiBufferSequence(BufferManager manager, ByteBuffer[] aBuffer, int of, int cBuffer) {
        this(manager, aBuffer, of, cBuffer, MultiBufferSequence.computeLength(aBuffer, of, cBuffer));
    }

    public MultiBufferSequence(BufferManager manager, ByteBuffer[] aBuffer, int of, int cBuffer, long cbBuffer) {
        if (aBuffer == null) {
            throw new IllegalArgumentException("buffer array cannot be null");
        }
        int[] aPosLimit = new int[cBuffer * 2];
        for (int i = 0; i < cBuffer; ++i) {
            ByteBuffer buff = aBuffer[of + i];
            aPosLimit[i] = buff.position();
            aPosLimit[cBuffer + i] = buff.limit();
        }
        this.m_manager = manager;
        this.m_aBuffer = aBuffer;
        this.m_ofBuffer = of;
        this.m_cBuffer = cBuffer;
        this.m_cbBuffer = cbBuffer;
        this.m_aPosLimit = aPosLimit;
    }

    @Override
    public long getLength() {
        return this.m_cbBuffer;
    }

    @Override
    public int getBufferCount() {
        return this.m_cBuffer;
    }

    @Override
    public ByteBuffer getBuffer(int iBuffer) {
        if (iBuffer < 0 || iBuffer >= this.m_cBuffer) {
            throw new IndexOutOfBoundsException();
        }
        return this.getSafeBuffer(iBuffer);
    }

    @Override
    public ByteBuffer[] getBuffers() {
        int cBuffer = this.m_cBuffer;
        ByteBuffer[] aBufferNew = new ByteBuffer[cBuffer];
        for (int i = 0; i < cBuffer; ++i) {
            aBufferNew[i] = this.getSafeBuffer(i);
        }
        return aBufferNew;
    }

    @Override
    public void getBuffers(int iBuffer, int cBuffers, ByteBuffer[] abufDest, int iDest) {
        int cBufferSrc = this.m_cBuffer;
        if (iBuffer < 0 || iBuffer + cBuffers > cBufferSrc) {
            throw new IndexOutOfBoundsException();
        }
        int eDest = iDest + cBuffers;
        while (iDest < eDest) {
            abufDest[iDest] = this.getSafeBuffer(iBuffer);
            ++iDest;
            ++iBuffer;
        }
    }

    @Override
    public void dispose() {
        ByteBuffer[] aBuffer = this.m_aBuffer;
        this.m_aBuffer = null;
        if (aBuffer == null) {
            throw new IllegalStateException("already disposed");
        }
        BufferManager manager = this.m_manager;
        if (manager != null) {
            int of;
            int eof = of + this.m_cBuffer;
            for (of = this.m_ofBuffer; of < eof; ++of) {
                manager.release(aBuffer[of]);
            }
        }
    }

    protected static long computeLength(ByteBuffer[] aBuffer, int of, int cBuffer) {
        long cb = 0L;
        int e = of + cBuffer;
        while (of < e) {
            cb += (long)aBuffer[of].remaining();
            ++of;
        }
        return cb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ByteBuffer getSafeBuffer(int i) {
        ByteBuffer buff = this.m_aBuffer[this.m_ofBuffer + i];
        if (i >= this.m_ofSafe) {
            MultiBufferSequence multiBufferSequence = this;
            synchronized (multiBufferSequence) {
                if (i >= this.m_ofSafe) {
                    this.m_ofSafe = i + 1;
                    return buff;
                }
            }
        }
        int[] aPosLimit = this.m_aPosLimit;
        buff = buff.duplicate();
        buff.limit(aPosLimit[this.m_cBuffer + i]).position(aPosLimit[i]);
        return buff;
    }
}

