/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Cluster;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.serviceMemberSet.MasterMemberSet;
import com.tangosol.coherence.component.net.message.DiscoveryMessage;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.net.internal.ClusterJoinException;
import com.tangosol.run.component.EventDeathException;
import com.tangosol.util.WrapperException;
import java.io.IOException;

public class ClusterService$NewMemberRequestIdReply
extends DiscoveryMessage {
    private int __m_MulticastTimeToLive;
    private String __m_ServiceVersion;
    private int __m_WkaHashCode;

    public ClusterService$NewMemberRequestIdReply() {
        this(null, null, true);
    }

    public ClusterService$NewMemberRequestIdReply(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setBufferUsageCounter(1);
            this.setMessageType(12);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public String getDescription() {
        return String.valueOf("ToMember=") + this.getToMember() + "\nServiceVersion=" + this.getServiceVersion();
    }

    public int getMulticastTimeToLive() {
        return this.__m_MulticastTimeToLive;
    }

    public String getServiceVersion() {
        return this.__m_ServiceVersion;
    }

    public int getWkaHashCode() {
        return this.__m_WkaHashCode;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/grid/ClusterService$NewMemberRequestIdReply".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new ClusterService$NewMemberRequestIdReply();
    }

    private final Component get_Module() {
        return ((Component)this).get_Parent();
    }

    public void onReceived() {
        super.onReceived();
        Member memberFrom = this.getFromMember();
        ClusterService service = (ClusterService)this.getService();
        switch (service.getState()) {
            case 0: {
                if (this.isReadError()) {
                    service.onMemberRejected(-ClusterService.REJECT_VERSION, memberFrom);
                    throw new EventDeathException("Version mismatch");
                }
                service.resetBroadcastCounter("the presence of an existing cluster", this);
                break;
            }
            case 1: {
                int iTtlSenior;
                if (this.isReadError()) {
                    service.onMemberRejected(-ClusterService.REJECT_VERSION, memberFrom);
                    throw new EventDeathException("Version mismatch");
                }
                service.resetBroadcastCounter("the presence of an existing cluster", this);
                if (!this.getToMember().getUid32().equals(service.getRequestMember().getUid32())) break;
                MasterMemberSet setMember = service.getClusterMemberSet();
                Cluster cluster = (Cluster)service.getCluster();
                Member memberOldest = service.ensureMember(memberFrom, this.getServiceVersion());
                Member memberThis = service.getRequestMember();
                if (!(setMember.getThisMember() == null)) {
                    if (setMember.getOldestMember() != memberOldest) {
                        throw new ClusterJoinException();
                    }
                    return;
                }
                memberThis.setId(this.getToMember().getId());
                memberThis = service.ensureMember(memberThis, service.getServiceVersion());
                memberThis.setPreferredPacketLength(cluster.getSocketManager().getPreferredUnicastUdpSocket().getPacketLength());
                memberThis.setPreferredPort(cluster.getSocketManager().getPreferredUnicastUdpSocket().getPort());
                setMember.setThisMember(memberThis);
                Component._trace(String.valueOf("This ") + memberThis.toString(Member.SHOW_LICENSE) + " joined " + service.formatClusterString() + " with senior " + memberOldest.toString(Member.SHOW_LICENSE), 3);
                if (service.isWkaEnabled()) {
                    if (!(service.getWkaHashCode() != this.getWkaHashCode())) break;
                    Component._trace(String.valueOf("This member is configured with a compatible but ") + "different WKA list then the senior " + memberOldest + ". It is strongly recommended to use the same WKA list for " + "all cluster members.", 2);
                    break;
                }
                int iTtlThis = service.getMulticastTimeToLive();
                if (!(iTtlThis != (iTtlSenior = this.getMulticastTimeToLive()))) break;
                Component._trace(String.valueOf("This member is configured with a multicast TTL of ") + iTtlThis + "; the senior " + memberOldest + " is " + "configured with a TTL of " + iTtlSenior + ". It is strongly recommended to use the same TTL setting for " + "all cluster members.", 2);
                break;
            }
            case 2: {
                service.validateSeniorBroadcast(this, null);
                break;
            }
        }
    }

    public void read(ReadBuffer.BufferInput input) throws IOException {
        super.read(input);
        this.setServiceVersion(input.readUTF());
        this.setMulticastTimeToLive(input.readInt());
        this.setWkaHashCode(input.readInt());
        this.ensureEOS(input);
    }

    public void setMulticastTimeToLive(int pMulticastTimeToLive) {
        this.__m_MulticastTimeToLive = pMulticastTimeToLive;
    }

    public void setServiceVersion(String sVersion) {
        this.__m_ServiceVersion = sVersion;
    }

    public void setWkaHashCode(int iHash) {
        this.__m_WkaHashCode = iHash;
    }

    public void write(WriteBuffer.BufferOutput output) throws IOException {
        super.write(output);
        output.writeUTF(this.getServiceVersion());
        output.writeInt(this.getMulticastTimeToLive());
        output.writeInt(this.getWkaHashCode());
    }
}

